/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsDirtyScopeManagerImpl.class);
    private final Project myProject;
    @NotNull
    private DirtBuilder myDirtBuilder = new DirtBuilder();
    @Nullable
    private DirtBuilder myDirtInProgress;
    @Nullable
    private ActionCallback myRefreshInProgress;
    private boolean myReady;
    private final Object LOCK = new Object();

    @NotNull
    public static VcsDirtyScopeManagerImpl getInstanceImpl(@NotNull Project project) {
        return (VcsDirtyScopeManagerImpl)VcsDirtyScopeManagerImpl.getInstance((Project)project);
    }

    public VcsDirtyScopeManagerImpl(@NotNull Project project) {
        this.myProject = project;
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> VcsDirtyScopeManagerImpl.this.markEverythingDirty(), ModalityState.NON_MODAL, VcsDirtyScopeManagerImpl.this.myProject.getDisposed());
            }
        });
    }

    private static ProjectLevelVcsManager getVcsManager(@NotNull Project project) {
        return ProjectLevelVcsManager.getInstance((Project)project);
    }

    private void startListenForChanges() {
        ReadAction.run(() -> {
            boolean ready = !this.myProject.isDisposed() && this.myProject.isOpen();
            Object object = this.LOCK;
            synchronized (object) {
                this.myReady = ready;
            }
            if (ready) {
                VcsDirtyScopeVfsListener.install(this.myProject);
                this.markEverythingDirty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEverythingDirty() {
        ActionCallback ongoingRefresh;
        boolean wasReady;
        if (!this.myProject.isOpen() || this.myProject.isDisposed() || VcsDirtyScopeManagerImpl.getVcsManager(this.myProject).getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
        }
        Object object = this.LOCK;
        synchronized (object) {
            wasReady = this.myReady;
            if (wasReady) {
                this.myDirtBuilder.markEverythingDirty();
            }
            ongoingRefresh = this.myRefreshInProgress;
        }
        if (ongoingRefresh != null) {
            ongoingRefresh.setRejected();
        }
        if (wasReady) {
            ChangeListManager.getInstance((Project)this.myProject).scheduleUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
            this.myDirtBuilder = new DirtBuilder();
            this.myDirtInProgress = null;
            this.myRefreshInProgress = null;
        }
    }

    @NotNull
    private Map<VcsRoot, Set<FilePath>> groupByVcs(@Nullable Iterable<? extends FilePath> from) {
        if (from == null) {
            return Collections.emptyMap();
        }
        ProjectLevelVcsManager vcsManager2 = VcsDirtyScopeManagerImpl.getVcsManager(this.myProject);
        HashMap<VcsRoot, Set<FilePath>> map2 = new HashMap<VcsRoot, Set<FilePath>>();
        for (FilePath filePath : from) {
            VcsRoot vcsRoot = vcsManager2.getVcsRootObjectFor(filePath);
            if (vcsRoot == null || vcsRoot.getVcs() == null) continue;
            Set pathSet = map2.computeIfAbsent(vcsRoot, key -> new THashSet(VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(key.getVcs())));
            pathSet.add(filePath);
        }
        return map2;
    }

    @NotNull
    private Map<VcsRoot, Set<FilePath>> groupFilesByVcs(@Nullable Collection<? extends VirtualFile> from) {
        if (from == null) {
            return Collections.emptyMap();
        }
        return this.groupByVcs(() -> ContainerUtil.mapIterator(from.iterator(), file -> VcsUtil.getFilePath((VirtualFile)file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileVcsPathsDirty(@NotNull Map<VcsRoot, Set<FilePath>> filesConverted, @NotNull Map<VcsRoot, Set<FilePath>> dirsConverted) {
        if (filesConverted.isEmpty() && dirsConverted.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("dirty files: %s; dirty dirs: %s; %s", VcsDirtyScopeManagerImpl.toString(filesConverted), VcsDirtyScopeManagerImpl.toString(dirsConverted), VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass()));
        }
        boolean hasSomethingDirty = false;
        for (VcsRoot vcsRoot : ContainerUtil.union(filesConverted.keySet(), dirsConverted.keySet())) {
            Set files = ContainerUtil.notNullize(filesConverted.get(vcsRoot));
            Set dirs = ContainerUtil.notNullize(dirsConverted.get(vcsRoot));
            Object object = this.LOCK;
            synchronized (object) {
                if (this.myReady) {
                    hasSomethingDirty |= this.myDirtBuilder.addDirtyFiles(vcsRoot, files, dirs);
                }
            }
        }
        if (hasSomethingDirty) {
            ChangeListManager.getInstance((Project)this.myProject).scheduleUpdate();
        }
    }

    public void filePathsDirty(@Nullable Collection<? extends FilePath> filesDirty, @Nullable Collection<? extends FilePath> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupByVcs(filesDirty), this.groupByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void filesDirty(@Nullable Collection<? extends VirtualFile> filesDirty, @Nullable Collection<? extends VirtualFile> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupFilesByVcs(filesDirty), this.groupFilesByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void fileDirty(@NotNull VirtualFile file) {
        this.fileDirty(VcsUtil.getFilePath((VirtualFile)file));
    }

    public void fileDirty(@NotNull FilePath file) {
        this.filePathsDirty(Collections.singleton(file), null);
    }

    public void dirDirtyRecursively(@NotNull VirtualFile dir) {
        this.dirDirtyRecursively(VcsUtil.getFilePath((VirtualFile)dir));
    }

    public void dirDirtyRecursively(@NotNull FilePath path2) {
        this.filePathsDirty(null, Collections.singleton(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsInvalidated retrieveScopes() {
        DirtBuilder dirtBuilder;
        ActionCallback callback2 = new ActionCallback();
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return null;
            }
            LOG.assertTrue(this.myDirtInProgress == null);
            this.myDirtInProgress = dirtBuilder = this.myDirtBuilder;
            this.myDirtBuilder = new DirtBuilder();
            this.myRefreshInProgress = callback2;
        }
        return this.calculateInvalidated(dirtBuilder, callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changesProcessed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtInProgress = null;
            this.myRefreshInProgress = null;
        }
    }

    @NotNull
    private VcsInvalidated calculateInvalidated(@NotNull DirtBuilder dirt, @NotNull ActionCallback callback2) {
        boolean isEverythingDirty = dirt.isEverythingDirty();
        List<VcsDirtyScopeImpl> scopes = dirt.buildScopes(this.myProject);
        return new VcsInvalidated(scopes, isEverythingDirty, callback2);
    }

    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<? extends FilePath> files) {
        return (Collection)ReadAction.compute(() -> {
            ArrayList<FilePath> result2 = new ArrayList<FilePath>();
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.myReady) {
                    return Collections.emptyList();
                }
                for (FilePath fp : files) {
                    if (!this.myDirtBuilder.isFileDirty(fp) && (this.myDirtInProgress == null || !this.myDirtInProgress.isFileDirty(fp))) continue;
                    result2.add(fp);
                }
            }
            return result2;
        });
    }

    @NotNull
    private static String toString(@NotNull Map<VcsRoot, Set<FilePath>> filesByVcs) {
        return StringUtil.join(filesByVcs.keySet(), vcs -> vcs.getVcs() + ": " + StringUtil.join((Collection)((Collection)filesByVcs.get(vcs)), path2 -> path2.getPath(), (String)"\n"), (String)"\n");
    }

    @Nullable
    private static Class<?> findFirstInterestingCallerClass() {
        for (int i = 1; i <= 7; ++i) {
            Class clazz = ReflectionUtil.findCallerClass((int)i);
            if (clazz != null && clazz.getName().contains(VcsDirtyScopeManagerImpl.class.getName())) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public static TObjectHashingStrategy<FilePath> getDirtyScopeHashingStrategy(@NotNull AbstractVcs vcs) {
        return vcs.needsCaseSensitiveDirtyScope() ? ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY : ContainerUtil.canonicalStrategy();
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            VcsDirtyScopeManagerImpl.getInstanceImpl(project).startListenForChanges();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.DIRTY_SCOPE_MANAGER.getOrder();
        }
    }
}

