/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DelayedNotificator
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance(DelayedNotificator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeListManagerImpl myManager;
    @NotNull
    private final ChangeListManagerImpl.Scheduler myScheduler;

    public DelayedNotificator(@NotNull Project project, @NotNull ChangeListManagerImpl manager, @NotNull ChangeListManagerImpl.Scheduler scheduler) {
        this.myProject = project;
        this.myManager = manager;
        this.myScheduler = scheduler;
    }

    public void callNotify(ChangeListCommand command) {
        this.myScheduler.submit(() -> {
            try {
                command.doNotify(this.getMulticaster());
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        });
    }

    public void changeListAdded(ChangeList list) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListAdded(list));
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        this.myScheduler.submit(() -> this.getMulticaster().changesRemoved(changes, fromList));
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        this.myScheduler.submit(() -> this.getMulticaster().changesAdded(changes, toList));
    }

    public void changeListRemoved(ChangeList list) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListRemoved(list));
    }

    public void changeListChanged(ChangeList list) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListChanged(list));
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListRenamed(list, oldName));
    }

    public void changeListDataChanged(@NotNull ChangeList list) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListDataChanged(list));
    }

    public void changeListCommentChanged(ChangeList list, String oldComment) {
        this.myScheduler.submit(() -> this.getMulticaster().changeListCommentChanged(list, oldComment));
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        this.myScheduler.submit(() -> this.getMulticaster().changesMoved(changes, fromList, toList));
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
        this.defaultListChanged(oldDefaultList, newDefaultList, false);
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
        this.myScheduler.submit(() -> this.getMulticaster().defaultListChanged(oldDefaultList, newDefaultList, automatic));
    }

    public void unchangedFileStatusChanged() {
        this.myScheduler.submit(() -> this.getMulticaster().unchangedFileStatusChanged());
    }

    public void changeListUpdateDone() {
        this.myScheduler.submit(() -> this.getMulticaster().changeListUpdateDone());
    }

    public void allChangeListsMappingsChanged() {
        this.myScheduler.submit(() -> this.getMulticaster().allChangeListsMappingsChanged());
    }

    public void changeListsForFileChanged(@NotNull FilePath path2, @NotNull Set<String> removedChangeListsIds, @NotNull Set<String> addedChangeListsIds) {
        this.myScheduler.submit(() -> {
            LocalChangeList changeList;
            Change change = this.myManager.getChange(path2);
            if (change == null) {
                return;
            }
            List<Change> changes = Collections.singletonList(change);
            for (String listId : removedChangeListsIds) {
                changeList = this.myManager.getChangeList(listId);
                if (changeList == null) continue;
                this.getMulticaster().changesRemoved(changes, (ChangeList)changeList);
            }
            for (String listId : addedChangeListsIds) {
                changeList = this.myManager.getChangeList(listId);
                if (changeList == null) continue;
                this.getMulticaster().changesAdded(changes, (ChangeList)changeList);
            }
        });
    }

    @NotNull
    private ChangeListListener getMulticaster() {
        return (ChangeListListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)ChangeListListener.TOPIC);
    }
}

