/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.CommonBundle;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import com.intellij.vcs.commit.SingleChangeListCommitter;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ChangeListOwner,
PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ChangeListManagerImpl.class);
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic(LocalChangeListsLoadedListener.class, Topic.BroadcastDirection.NONE);
    private final Project myProject;
    private final ChangesViewI myChangesViewManager;
    private final ChangelistConflictTracker myConflictTracker;
    private final Scheduler myScheduler = new Scheduler();
    private final EventDispatcher<ChangeListListener> myListeners = EventDispatcher.create(ChangeListListener.class);
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock = new Object();
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    private boolean myInitialUpdate = true;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private volatile boolean myShowLocalChangesInvalidated;
    private volatile String myFreezeName;
    @NotNull
    private final Set<String> myListsToBeDeletedSilently = new HashSet<String>();
    @NotNull
    private final Set<String> myListsToBeDeleted = new HashSet<String>();
    private boolean myEmptyListDeletionScheduled;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
    private static final IgnoredFileBean[] EMPTY_ARRAY = new IgnoredFileBean[0];

    public static ChangeListManagerImpl getInstanceImpl(@NotNull Project project) {
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance((Project)project);
    }

    public ChangeListManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myConflictTracker = new ChangelistConflictTracker(project, this);
        this.myComposite = FileHolderComposite.create(project);
        this.myDelayedNotificator = new DelayedNotificator(this.myProject, this, this.myScheduler);
        this.myWorker = new ChangeListWorker(this.myProject, this.myDelayedNotificator);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, this::updateImmediately);
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myProject.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)this.myListeners.getMulticaster());
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (automatic || oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
            }
        });
        VcsIgnoredFilesHolder.VCS_IGNORED_FILES_HOLDER_EP.addChangeListener((AreaInstance)this.myProject, () -> VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty(), (Disposable)this.myProject);
        VcsEP.EP_NAME.addChangeListener(() -> {
            this.resetChangedFiles();
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }, (Disposable)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == ChangeListManagerImpl.this.myProject) {
                        ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                    }
                }
            });
        }
    }

    public void dispose() {
        this.myUpdater.stop();
    }

    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList list) {
        this.scheduleAutomaticEmptyChangeListDeletion(list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList, boolean silently) {
        Object object = this.myDataLock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Schedule empty changelist deletion: %s, silently = %s", oldList.getName(), silently));
            }
            if (silently) {
                this.myListsToBeDeletedSilently.add(oldList.getId());
            } else {
                this.myListsToBeDeleted.add(oldList.getId());
            }
            if (!this.myEmptyListDeletionScheduled) {
                this.myEmptyListDeletionScheduled = true;
                this.invokeAfterUpdate(this::deleteEmptyChangeLists, InvokeAfterUpdateMode.SILENT, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmptyChangeLists() {
        List listsToBeDeleted;
        List listsToBeDeletedSilently;
        VcsConfiguration config = VcsConfiguration.getInstance((Project)this.myProject);
        Function toDeleteMapping = id -> {
            LocalChangeList list = this.getChangeList((String)id);
            if (list == null || list.isDefault() || list.isReadOnly() || !list.getChanges().isEmpty()) {
                return null;
            }
            return list;
        };
        Object object = this.myDataLock;
        synchronized (object) {
            boolean askLater;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, scheduled:\nsilently: %s\nasking: %s", this.myListsToBeDeletedSilently, this.myListsToBeDeleted));
            }
            this.myListsToBeDeleted.removeAll(this.myListsToBeDeletedSilently);
            listsToBeDeletedSilently = ContainerUtil.mapNotNull(this.myListsToBeDeletedSilently, (Function)toDeleteMapping);
            this.myListsToBeDeletedSilently.clear();
            boolean bl = askLater = this.myModalNotificationsBlocked && config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            if (!askLater) {
                listsToBeDeleted = ContainerUtil.mapNotNull(this.myListsToBeDeleted, (Function)toDeleteMapping);
                this.myListsToBeDeleted.clear();
            } else {
                listsToBeDeleted = Collections.emptyList();
            }
            this.myEmptyListDeletionScheduled = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, to be deleted:\nsilently: %s\nasking: %s", listsToBeDeletedSilently, listsToBeDeleted));
            }
        }
        if (config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY || config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && ApplicationManager.getApplication().isUnitTestMode()) {
            listsToBeDeleted.clear();
        }
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeletedSilently, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> true));
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeleted, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(this.myProject, config, toAsk)));
    }

    private static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project, final @NotNull VcsConfiguration config, @NotNull Collection<? extends ChangeList> lists) {
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list -> StringUtil.first((String)list.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog = new VcsConfirmationDialog(project, VcsBundle.message((String)"dialog.title.remove.empty.changelist", (Object[])new Object[0]), VcsBundle.message((String)"button.remove", (Object[])new Object[0]), CommonBundle.getCancelButtonText(), new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, VcsBundle.message((String)"checkbox.remember.my.choice", (Object[])new Object[0]));
        return dialog.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists();
    }

    private void startUpdater() {
        this.myUpdater.initialized();
        ((LocalChangeListsLoadedListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, LISTS_LOADED)).processLoadedLists(this.getChangeListsCopy());
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myConflictTracker.startTracking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.registerChangeTracker(filePath, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.unregisterChangeTracker(filePath, tracker);
        }
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title2, @Nullable ModalityState state) {
        this.invokeAfterUpdate(afterUpdate, mode, title2, null, state);
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title2, @Nullable Consumer<? super VcsDirtyScopeManager> dirtyScopeManagerFiller, @Nullable ModalityState state) {
        if (dirtyScopeManagerFiller != null && !this.myProject.isDisposed()) {
            dirtyScopeManagerFiller.consume((Object)VcsDirtyScopeManager.getInstance((Project)this.myProject));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title2, state);
    }

    @Override
    public void freeze(@NotNull String reason) {
        assert (ApplicationManager.getApplication().isHeadlessEnvironment() || !ApplicationManager.getApplication().isDispatchThread());
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    @Override
    public void waitForUpdate(@Nullable String operationName) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        CountDownLatch waiter = new CountDownLatch(1);
        this.invokeAfterUpdate(waiter::countDown, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, operationName, ModalityState.NON_MODAL);
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
    }

    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        this.myScheduler.submit(r);
    }

    public void executeUnderDataLock(@NotNull Runnable r) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                r.run();
            }
        });
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChangedFiles() {
        try {
            Object object = this.myDataLock;
            synchronized (object) {
                DataHolder dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), true);
                dataHolder.notifyStart();
                dataHolder.notifyEnd();
                ChangeListWorker updatedWorker = dataHolder.getChangeListUpdater().finish();
                this.myWorker.applyChangesFromUpdate(updatedWorker, new MyChangesDeltaForwarder(this.myProject, this.myScheduler));
                this.myComposite = dataHolder.getComposite();
                this.myUpdateException = null;
                this.myAdditionalInfo = null;
                this.myDelayedNotificator.unchangedFileStatusChanged();
                this.myDelayedNotificator.changeListUpdateDone();
                ((ChangesViewEx)this.myChangesViewManager).refreshImmediately();
            }
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    private boolean updateImmediately() {
        return (Boolean)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            if (!vcsManager2.hasActiveVcss()) {
                return true;
            }
            VcsDirtyScopeManagerImpl dirtyScopeManager = VcsDirtyScopeManagerImpl.getInstanceImpl(this.myProject);
            VcsInvalidated invalidated = dirtyScopeManager.retrieveScopes();
            if (ChangeListManagerImpl.checkScopeIsEmpty(invalidated)) {
                LOG.debug("[update] - dirty scope is empty");
                dirtyScopeManager.changesProcessed();
                return true;
            }
            boolean wasEverythingDirty = invalidated.isEverythingDirty();
            List<VcsDirtyScope> scopes = invalidated.getScopes();
            try {
                boolean takeChanges;
                boolean wasCancelled;
                DataHolder dataHolder;
                if (this.myUpdater.isStopped()) {
                    Boolean bl = true;
                    return bl;
                }
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), wasEverythingDirty);
                    this.myModifier.enterUpdate();
                    if (wasEverythingDirty) {
                        this.myUpdateException = null;
                        this.myAdditionalInfo = null;
                    }
                    if (LOG.isDebugEnabled()) {
                        String scopeInString = StringUtil.join(scopes, Object::toString, (String)"->\n");
                        LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\nignored: " + this.myComposite.getIgnoredFileHolder().values().size() + "\nunversioned: " + this.myComposite.getUnversionedFileHolder().getFiles().size() + "\ncurrent changes: " + this.myWorker);
                    }
                }
                dataHolder.notifyStart();
                this.myChangesViewManager.setBusy(true);
                this.myChangesViewManager.scheduleRefresh();
                SensitiveProgressWrapper vcsIndicator = new SensitiveProgressWrapper(ProgressManager.getInstance().getProgressIndicator());
                if (!this.myInitialUpdate) {
                    invalidated.doWhenCanceled(() -> vcsIndicator.cancel());
                }
                try {
                    ProgressManager.getInstance().executeProcessUnderProgress(() -> this.iterateScopes(dataHolder, scopes, (ProgressIndicator)vcsIndicator), (ProgressIndicator)vcsIndicator);
                }
                catch (ProcessCanceledException scopeInString) {
                    // empty catch block
                }
                Object object2 = this.myDataLock;
                synchronized (object2) {
                    wasCancelled = vcsIndicator.isCanceled();
                    takeChanges = this.myUpdateException == null && !wasCancelled;
                }
                this.myInitialUpdate = false;
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    this.clearCurrentRevisionsCache(invalidated);
                    Object object = this.myDataLock;
                    synchronized (object) {
                        dataHolder.notifyEnd();
                        if (takeChanges) {
                            ChangeListWorker updatedWorker = dataHolder.getChangeListUpdater().finish();
                            this.myModifier.finishUpdate(updatedWorker);
                            this.myWorker.applyChangesFromUpdate(updatedWorker, new MyChangesDeltaForwarder(this.myProject, this.myScheduler));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getUnversionedFileHolder().getFiles().size() + "\nchanges: " + this.myWorker);
                            }
                            boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                            this.myComposite = dataHolder.getComposite();
                            if (statusChanged) {
                                this.myDelayedNotificator.unchangedFileStatusChanged();
                            }
                            LOG.debug("[update] - success");
                        } else {
                            this.myModifier.finishUpdate(null);
                            LOG.debug("[update] - aborted");
                        }
                        this.myShowLocalChangesInvalidated = false;
                    }
                });
                for (VcsDirtyScope scope2 : scopes) {
                    if (!scope2.getVcs().isTrackingUnchangedContent()) continue;
                    scope2.iterateExistingInsideScope(file -> {
                        LastUnchangedContentTracker.markUntouched(file);
                        return true;
                    });
                }
                object2 = !wasCancelled;
                return object2;
            }
            catch (ProcessCanceledException dataHolder) {
            }
            catch (AssertionError | Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                dirtyScopeManager.changesProcessed();
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
            return true;
        });
    }

    private static boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<? extends VcsDirtyScope> scopes, @NotNull ProgressIndicator indicator) {
        ChangeListWorker.ChangeListUpdater updater = dataHolder.getChangeListUpdater();
        Getter disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(updater, dataHolder.getComposite(), (Getter<Boolean>)disposedGetter);
        for (VcsDirtyScope vcsDirtyScope : scopes) {
            indicator.checkCanceled();
            this.actualUpdate(builder, vcsDirtyScope, vcsDirtyScope.getVcs(), dataHolder, updater, indicator);
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myUpdateException != null) {
                    break;
                }
            }
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder, @NotNull VcsDirtyScope scope2, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope2);
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                builder.setCurrent(scope2);
                changeProvider.getChanges(scope2, (ChangelistBuilder)builder, indicator, gate);
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrow((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope2) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        return before != null && scope2.belongsTo(before.getFile()) || after != null && scope2.belongsTo(after.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeLists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedPaths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAllChanges();
        }
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        return ContainerUtil.mapNotNull(this.getUnversionedFilesPaths(), FilePath::getVirtualFile);
    }

    @NotNull
    public List<FilePath> getUnversionedFilesPaths() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getUnversionedFileHolder().getFiles();
            }
        });
    }

    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getModifiedWithoutEditingFileHolder().getFiles();
            }
        });
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        return ContainerUtil.mapNotNull(this.getIgnoredFilePaths(), FilePath::getVirtualFile);
    }

    @NotNull
    public List<FilePath> getIgnoredFilePaths() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<FilePath>(this.myComposite.getIgnoredFileHolder().values());
            }
        });
    }

    boolean isIgnoredInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
            }
        });
    }

    public List<VirtualFile> getLockedFolders() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLockedFileHolder().getFiles();
            }
        });
    }

    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
            }
        });
    }

    public boolean isLogicallyLocked(VirtualFile file) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLogicallyLockedFileHolder().containsKey(file);
            }
        });
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
            }
        });
    }

    public List<LocallyDeletedChange> getDeletedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().getFiles();
            }
        });
    }

    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        return (MultiMap)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
            }
        });
    }

    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(@NotNull VirtualFile file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(@Nullable String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListById(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        return this.addChangeList(name, comment, null);
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        return (LocalChangeList)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList;
            }
        });
    }

    public void removeChangeList(@NotNull String name) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(@NotNull LocalChangeList list) {
        this.removeChangeList(list.getName());
    }

    public void setDefaultChangeList(@NotNull String name, boolean automatic) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(name, automatic);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    public void setDefaultChangeList(@NotNull String name) {
        this.setDefaultChangeList(name, false);
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list) {
        this.setDefaultChangeList(list, false);
    }

    @Override
    public void setDefaultChangeList(@NotNull LocalChangeList list, boolean automatic) {
        this.setDefaultChangeList(list.getName(), automatic);
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String name, String newComment) {
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(name, StringUtil.notNullize((String)newComment));
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    @Override
    public boolean editChangeListData(@NotNull String name, @Nullable ChangeListData newData) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editData(name, newData);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list, Change ... changes) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list.getName(), changes);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultList().getName();
        }
    }

    public void notifyChangelistsChanged(@NotNull FilePath path2, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        this.myWorker.notifyChangelistsChanged(path2, beforeChangeListsIds, afterChangeListsIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(Arrays.asList(changes));
            return lists.size() == 1 ? lists.get(0).getName() : null;
        }
    }

    @Override
    public boolean isInUpdate() {
        return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file) {
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<? extends Change> changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedLists(changes);
        }
    }

    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull Change change) {
        return this.getAffectedLists(Collections.singletonList(change));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull VirtualFile file) {
        Object object = this.myDataLock;
        synchronized (object) {
            Change change = this.myWorker.getChangeForPath(VcsUtil.getFilePath((VirtualFile)file));
            if (change == null) {
                return Collections.emptyList();
            }
            return this.getChangeLists(change);
        }
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(change));
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull VirtualFile file) {
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file);
        }
    }

    public boolean isUnversioned(VirtualFile file) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getUnversionedFileHolder().containsFile(VcsUtil.getFilePath((VirtualFile)file));
            }
        });
    }

    @NotNull
    public FileStatus getStatus(@NotNull FilePath path2) {
        return this.getStatus(path2, path2.getVirtualFile());
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file) {
        return this.getStatus(VcsUtil.getFilePath((VirtualFile)file), file);
    }

    @NotNull
    private FileStatus getStatus(@NotNull FilePath path2, @Nullable VirtualFile file) {
        return (FileStatus)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean switched;
                if (this.myComposite.getUnversionedFileHolder().containsFile(path2)) {
                    return FileStatus.UNKNOWN;
                }
                if (file != null && this.myComposite.getModifiedWithoutEditingFileHolder().containsFile(file)) {
                    return FileStatus.HIJACKED;
                }
                if (this.myComposite.getIgnoredFileHolder().containsFile(path2)) {
                    return FileStatus.IGNORED;
                }
                FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(path2), (Object)FileStatus.NOT_CHANGED);
                if (file != null && FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file))) {
                    return FileStatus.SWITCHED;
                }
                return status;
            }
        });
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        return this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (!vf.isValid() || !vf.isDirectory()) {
            return ThreeState.NO;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.haveChangesUnder(vf);
        }
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        return this.getAllChanges().stream().filter(change -> ChangeListManagerImpl.isChangeUnder(dirPath, change)).collect(Collectors.toSet());
    }

    private static boolean isChangeUnder(@NotNull FilePath parent, @NotNull Change change) {
        FilePath after = ChangesUtil.getAfterPath((Change)change);
        FilePath before = ChangesUtil.getBeforePath((Change)change);
        return after != null && after.isUnder(parent, false) || !Comparing.equal((Object)before, (Object)after) && before != null && before.isUnder(parent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getVcsFor(change);
        }
    }

    @Override
    public void addUnversionedFiles(@NotNull LocalChangeList list, @NotNull List<? extends VirtualFile> files) {
        ScheduleForAdditionAction.addUnversionedFilesToVcs(this.myProject, list, files);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2, @NotNull Disposable disposable) {
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        this.myRegisteredCommitExecutors.add(executor);
    }

    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes) {
        this.doCommit(changeList, changes, false);
    }

    private void doCommit(LocalChangeList changeList, List<? extends Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        String commitMessage2 = StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment();
        ChangeListCommitState commitState = new ChangeListCommitState(changeList, changes, commitMessage2);
        SingleChangeListCommitter committer = new SingleChangeListCommitter(this.myProject, commitState, new CommitContext(), changeList.getName(), false);
        committer.addResultHandler(new ShowNotificationCommitResultHandler(committer));
        committer.runCommit(changeList.getName(), synchronously);
    }

    public void commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes) {
        this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ChangeListManagerSerialization.readExternal(element, this.myWorker);
        }
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Element getState() {
        ChangeListWorker worker;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, worker);
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(@NotNull List<? extends FilePath> paths) {
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable((Collection)ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        return Collections.unmodifiableList(this.myRegisteredCommitExecutors);
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path2) {
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path2) {
    }

    public void scheduleUnversionedUpdate() {
        Couple couple = (Couple)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                List<FilePath> unversioned = this.myComposite.getUnversionedFileHolder().getFiles();
                Collection<FilePath> ignored = this.myComposite.getIgnoredFileHolder().values();
                return Couple.of(unversioned, ignored);
            }
        });
        Collection unversioned = (Collection)couple.first;
        Collection ignored = (Collection)couple.second;
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        int ourPiecesLimit = 100;
        if (unversioned.size() + ignored.size() > 100) {
            vcsDirtyScopeManager.markEverythingDirty();
        } else {
            ArrayList<FilePath> dirs = new ArrayList<FilePath>();
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            for (FilePath filePath : ContainerUtil.concat((Iterable)unversioned, (Iterable)ignored)) {
                if (filePath.isDirectory()) {
                    dirs.add(filePath);
                    continue;
                }
                files.add(filePath);
            }
            vcsDirtyScopeManager.filePathsDirty(files, dirs);
        }
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
    }

    public IgnoredFileBean @NotNull [] getFilesToIgnore() {
        return EMPTY_ARRAY;
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file) {
        return this.isIgnoredFile(VcsUtil.getFilePath((VirtualFile)file));
    }

    public boolean isIgnoredFile(@NotNull FilePath file) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().containsFile(file);
            }
        });
    }

    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file) {
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchForFile(file);
            }
        });
    }

    public void waitUntilRefreshed() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        VcsDirtyScopeVfsListener.getInstance(this.myProject).waitForAsyncTaskCompletion();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> ((Semaphore)semaphore).up());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            while (!semaphore.waitFor(100L)) {
                UIUtil.dispatchAllInvocationEvents();
            }
        } else {
            semaphore.waitFor();
        }
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.cancelAll();
    }

    public void waitEverythingDoneInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.awaitAll();
    }

    public void forceStopInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.stop();
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public boolean ensureUpToDate() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        this.waitUntilRefreshed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    public void showLocalChangesInvalidated() {
        this.myShowLocalChangesInvalidated = true;
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(@Nls @Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    public void replaceCommitMessage(@NotNull String oldMessage, @NotNull String newMessage) {
        VcsConfiguration.getInstance((Project)this.myProject).replaceMessage(oldMessage, newMessage);
        for (LocalChangeList changeList : this.getChangeLists()) {
            if (!oldMessage.equals(changeList.getComment())) continue;
            this.editComment(changeList.getName(), newMessage);
        }
    }

    static class Scheduler {
        private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl Pool", (int)1);
        private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        private final ArrayDeque<Future<?>> myFutures = new ArrayDeque();

        Scheduler() {
        }

        public void schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
            ScheduledFuture<?> future2 = this.myExecutor.schedule(command, delay, unit);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        public void submit(@NotNull Runnable command) {
            Future<?> future2 = this.myExecutor.submit(command);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFuture(Future<?> future2) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            ArrayDeque<Future<?>> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                this.myFutures.add(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelAll() {
            ArrayDeque<Future<?>> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                for (Future<?> future2 : this.myFutures) {
                    future2.cancel(true);
                }
                this.myFutures.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitAll() {
            ArrayList<Exception> throwables = new ArrayList<Exception>();
            long start2 = System.currentTimeMillis();
            while (true) {
                Future<?> future2;
                if (System.currentTimeMillis() - start2 > TimeUnit.MINUTES.toMillis(10L)) {
                    this.cancelAll();
                    throwables.add(new IllegalStateException("Too long waiting for VCS update"));
                    break;
                }
                ArrayDeque<Future<?>> arrayDeque = this.myFutures;
                synchronized (arrayDeque) {
                    future2 = this.myFutures.peek();
                }
                if (future2 == null) break;
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
                try {
                    future2.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    continue;
                }
                catch (CancellationException ignore) {
                }
                catch (InterruptedException | ExecutionException e) {
                    throwables.add(e);
                }
                arrayDeque = this.myFutures;
                synchronized (arrayDeque) {
                    this.myFutures.remove(future2);
                }
            }
            CompoundRuntimeException.throwIfNotEmpty(throwables);
        }
    }

    private static class MyChangesDeltaForwarder
    implements ChangeListDeltaListener {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        MyChangesDeltaForwarder(Project project, @NotNull Scheduler scheduler) {
            this.myProject = project;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        }

        @Override
        public void modified(@NotNull BaseRevision was, @NotNull BaseRevision become) {
            this.doModify(was, become);
        }

        @Override
        public void added(@NotNull BaseRevision baseRevision) {
            this.doModify(baseRevision, baseRevision);
        }

        @Override
        public void removed(@NotNull BaseRevision baseRevision) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.changeRemoved(baseRevision.getPath(), vcs);
                }
                ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision.getPath());
            });
        }

        private void doModify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.changeUpdated(was.getPath(), vcs);
                }
                ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(become);
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            AbstractVcs vcs = baseRevision.getVcs();
            if (vcs != null) {
                return vcs;
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }
    }

    public static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            IProjectStore store = ProjectKt.getStateStore((Project)project);
            return !ProjectKt.isDirectoryBased((Project)project) && FileUtilRt.extensionEquals((String)filePath.getPath(), (String)"iws") || StringsKt.equals((String)filePath.getPath(), (String)store.getWorkspaceFilePath(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0) || DefaultIgnoredFileProvider.isShelfDirOrInsideIt(filePath, project);
        }

        private static boolean isShelfDirOrInsideIt(@NotNull FilePath filePath, @NotNull Project project) {
            String shelfPath = ShelveChangesManager.getShelfPath(project);
            return FileUtil.isAncestor((String)shelfPath, (String)filePath.getPath(), (boolean)false);
        }

        @NotNull
        public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
            LinkedHashSet<IgnoredFileBean> ignored = new LinkedHashSet<IgnoredFileBean>();
            String shelfPath = ShelveChangesManager.getShelfPath(project);
            ignored.add(IgnoredBeanFactory.ignoreUnderDirectory((String)shelfPath, (Project)project));
            String workspaceFilePath = ProjectKt.getStateStore((Project)project).getWorkspaceFilePath();
            if (workspaceFilePath != null) {
                ignored.add(IgnoredBeanFactory.ignoreFile((String)workspaceFilePath, (Project)project));
            }
            return ContainerUtil.unmodifiableOrEmptySet(ignored);
        }

        @NotNull
        public String getIgnoredGroupDescription() {
            return "Default ignored files";
        }
    }

    private final class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;

        private DataHolder(FileHolderComposite composite, ChangeListWorker.ChangeListUpdater changeListUpdater, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListUpdater = changeListUpdater;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListUpdater.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope2) {
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope2);
                this.myChangeListUpdater.notifyStartProcessingChanges(scope2);
            }
            this.myComposite.notifyVcsStarted(scope2.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        public ChangeListWorker.ChangeListUpdater getChangeListUpdater() {
            return this.myChangeListUpdater;
        }
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            ChangeListManagerImpl.getInstanceImpl(project).startUpdater();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.CHANGE_LIST_MANAGER.getOrder();
        }
    }
}

