/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.CacheableAnnotationProvider;
import org.jetbrains.annotations.NotNull;

@Service
public final class AnnotationsPreloader {
    private static final Logger LOG = Logger.getInstance(AnnotationsPreloader.class);
    private final MergingUpdateQueue myUpdateQueue;
    private final Project myProject;

    public AnnotationsPreloader(@NotNull Project project) {
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue("Annotations preloader queue", 1000, true, null, (Disposable)project, null, false);
    }

    private static boolean isEnabled() {
        return Registry.is((String)"vcs.annotations.preload") && !PowerSaveMode.isEnabled();
    }

    private void schedulePreloading(final @NotNull VirtualFile file) {
        if (this.myProject.isDisposed() || file.getFileType().isBinary()) {
            return;
        }
        this.myUpdateQueue.queue((Update)new DisposableUpdate((Disposable)this.myProject, file){

            @Override
            public void doRun() {
                try {
                    long start2 = 0L;
                    if (LOG.isDebugEnabled()) {
                        start2 = System.currentTimeMillis();
                    }
                    if (!FileEditorManager.getInstance((Project)AnnotationsPreloader.this.myProject).isFileOpen(file)) {
                        return;
                    }
                    FileStatus fileStatus = ChangeListManager.getInstance((Project)AnnotationsPreloader.this.myProject).getStatus(file);
                    if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
                        return;
                    }
                    AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)AnnotationsPreloader.this.myProject).getVcsFor(file);
                    if (vcs == null) {
                        return;
                    }
                    CacheableAnnotationProvider annotationProvider = (CacheableAnnotationProvider)ObjectUtils.tryCast((Object)vcs.getAnnotationProvider(), CacheableAnnotationProvider.class);
                    if (annotationProvider == null) {
                        return;
                    }
                    annotationProvider.populateCache(file);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Preloaded VCS annotations for ", new Object[]{file.getName(), " in ", String.valueOf(System.currentTimeMillis() - start2), "ms"});
                    }
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
        });
    }

    public static class AnnotationsPreloaderFileEditorManagerListener
    implements FileEditorManagerListener {
        private final Project myProject;

        public AnnotationsPreloaderFileEditorManagerListener(Project project) {
            this.myProject = project;
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (!AnnotationsPreloader.isEnabled()) {
                return;
            }
            VirtualFile file = event.getNewFile();
            if (file != null) {
                ((AnnotationsPreloader)this.myProject.getService(AnnotationsPreloader.class)).schedulePreloading(file);
            }
        }
    }
}

