/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.CacheOneStepIterator;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShowDiffFromAnnotation
extends DumbAwareAction
implements UpToDateLineNumberListener {
    @NotNull
    private final Project myProject;
    private final FileAnnotation myFileAnnotation;
    private final FileAnnotation.RevisionChangesProvider myChangesProvider;
    private int currentLine = -1;
    private static final int ourVicinity = 5;

    ShowDiffFromAnnotation(@NotNull Project project, @NotNull FileAnnotation fileAnnotation) {
        ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
        this.myProject = project;
        this.myFileAnnotation = fileAnnotation;
        this.myChangesProvider = fileAnnotation.getRevisionsChangesProvider();
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    public void update(@NotNull AnActionEvent e) {
        int number = this.currentLine;
        e.getPresentation().setVisible(this.myChangesProvider != null);
        e.getPresentation().setEnabled(this.myChangesProvider != null && number >= 0 && number < this.myFileAnnotation.getLineCount());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final int actualNumber = this.currentLine;
        if (actualNumber < 0) {
            return;
        }
        VcsRevisionNumber revisionNumber = this.myFileAnnotation.getLineRevisionNumber(actualNumber);
        if (revisionNumber == null) {
            return;
        }
        ChangeDiffRequestChain.Async requestChain = new ChangeDiffRequestChain.Async(){

            @NotNull
            protected ListSelection<ChangeDiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException {
                return ShowDiffFromAnnotation.loadRequests(ShowDiffFromAnnotation.this.myFileAnnotation, ShowDiffFromAnnotation.this.myChangesProvider, actualNumber);
            }
        };
        DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    @NotNull
    private static ListSelection<ChangeDiffRequestProducer> loadRequests(@NotNull FileAnnotation fileAnnotation, @NotNull FileAnnotation.RevisionChangesProvider changesProvider, int actualNumber) throws DiffRequestProducerException {
        try {
            Pair pair = changesProvider.getChangesIn(actualNumber);
            if (pair == null || pair.getFirst() == null || pair.getSecond() == null) {
                throw new DiffRequestProducerException("Can not load data to show diff");
            }
            FilePath targetPath = (FilePath)pair.getSecond();
            List changes = ContainerUtil.sorted((Collection)((CommittedChangeList)pair.getFirst()).getChanges(), ChangesComparator.getInstance(true));
            HashMap context = new HashMap();
            int idx = ShowDiffFromAnnotation.findSelfInList(changes, targetPath);
            if (idx != -1) {
                DiffNavigationContext navigationContext = ShowDiffFromAnnotation.createDiffNavigationContext(fileAnnotation, actualNumber);
                context.put(changes.get(idx), Collections.singletonMap(DiffUserDataKeysEx.NAVIGATION_CONTEXT, navigationContext));
            }
            ListSelection changeSelection = ListSelection.createAt((List)changes, (int)idx);
            return changeSelection.map(change -> ChangeDiffRequestProducer.create(fileAnnotation.getProject(), change, (Map)context.get(change)));
        }
        catch (VcsException e) {
            throw new DiffRequestProducerException((Throwable)e);
        }
    }

    private static int findSelfInList(@NotNull List<? extends Change> changes, @NotNull FilePath filePath) {
        int idx = -1;
        for (int i = 0; i < changes.size(); ++i) {
            Change change = changes.get(i);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().equals(filePath)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            return idx;
        }
        idx = 0;
        String name = filePath.getName();
        for (int i = 0; i < changes.size(); ++i) {
            Change change = changes.get(i);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().getName().equals(name)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Nullable
    private static DiffNavigationContext createDiffNavigationContext(final @NotNull FileAnnotation fileAnnotation, int actualLine) {
        String annotatedContent = fileAnnotation.getAnnotatedContent();
        if (StringUtil.isEmptyOrSpaces((String)annotatedContent)) {
            return null;
        }
        final String[] contentsLines = LineTokenizer.tokenize((CharSequence)annotatedContent, (boolean)false, (boolean)false);
        if (contentsLines.length <= actualLine) {
            return null;
        }
        final int correctedLine = ShowDiffFromAnnotation.correctActualLineIfTextEmpty(fileAnnotation, contentsLines, actualLine);
        return new DiffNavigationContext((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new CacheOneStepIterator((Iterator)new ContextLineIterator(contentsLines, fileAnnotation, correctedLine));
            }
        }, contentsLines[correctedLine]);
    }

    private static int correctActualLineIfTextEmpty(@NotNull FileAnnotation fileAnnotation, String @NotNull [] contentsLines, int actualLine) {
        VcsRevisionNumber revision = fileAnnotation.getLineRevisionNumber(actualLine);
        if (revision == null) {
            return actualLine;
        }
        if (!StringUtil.isEmptyOrSpaces((String)contentsLines[actualLine])) {
            return actualLine;
        }
        int upperBound = Math.min(actualLine + 5, contentsLines.length);
        for (int i = actualLine + 1; i < upperBound; ++i) {
            if (!revision.equals(fileAnnotation.getLineRevisionNumber(i)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i])) continue;
            return i;
        }
        int lowerBound = Math.max(actualLine - 5, 0);
        for (int i = actualLine - 1; i >= lowerBound; --i) {
            if (!revision.equals(fileAnnotation.getLineRevisionNumber(i)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i])) continue;
            return i;
        }
        return actualLine;
    }

    private static final class ContextLineIterator
    implements Iterator<String> {
        private final String @NotNull [] myContentsLines;
        private final VcsRevisionNumber myRevisionNumber;
        @NotNull
        private final FileAnnotation myAnnotation;
        private final int myStopAtLine;
        private int myCurrentLine;

        private ContextLineIterator(String @NotNull [] contentLines, @NotNull FileAnnotation annotation, int stopAtLine) {
            this.myAnnotation = annotation;
            this.myRevisionNumber = this.myAnnotation.originalRevision(stopAtLine);
            this.myStopAtLine = stopAtLine;
            this.myContentsLines = contentLines;
        }

        @Override
        public boolean hasNext() {
            return this.myRevisionNumber != null && this.lineNumberInBounds();
        }

        private boolean lineNumberInBounds() {
            return this.myCurrentLine < this.myContentsLines.length && this.myCurrentLine < this.myStopAtLine;
        }

        @Override
        public String next() {
            while (this.lineNumberInBounds()) {
                VcsRevisionNumber vcsRevisionNumber = this.myAnnotation.originalRevision(this.myCurrentLine);
                String text2 = this.myContentsLines[this.myCurrentLine];
                ++this.myCurrentLine;
                if (!this.myRevisionNumber.equals(vcsRevisionNumber) || StringUtil.isEmptyOrSpaces((String)text2)) continue;
                return text2;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

