/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ShowAnnotationColorsAction;
import com.intellij.openapi.vcs.actions.ShowHideAspectAction;
import com.intellij.openapi.vcs.actions.ShowShortenNames;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateActionGroup
extends ActionGroup
implements DumbAware {
    private final AnAction[] myActions;

    public AnnotateActionGroup(@NotNull List<AnnotationFieldGutter> gutters, @Nullable Couple<Map<VcsRevisionNumber, Color>> bgColorMap) {
        super(VcsBundle.message((String)"annotate.action.view.group.text", (Object[])new Object[0]), true);
        ArrayList<DumbAware> actions = new ArrayList<DumbAware>();
        for (AnnotationFieldGutter g : gutters) {
            if (g.getID() == null) continue;
            actions.add(new ShowHideAspectAction(g));
        }
        actions.add((DumbAware)Separator.getInstance());
        if (bgColorMap != null) {
            actions.add(new ShowAnnotationColorsAction());
        }
        actions.add(new ShowShortenNames());
        this.myActions = actions.toArray(AnAction.EMPTY_ARRAY);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return this.myActions;
    }

    static void revalidateMarkupInAllEditors() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (!(editor.getGutter() instanceof EditorGutterComponentEx)) continue;
            ((EditorGutterComponentEx)editor.getGutter()).revalidateMarkup();
        }
    }
}

