/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import org.jetbrains.annotations.NotNull;

public class ZipAndQueue {
    private final ZipperUpdater myZipperUpdater;
    private final BackgroundTaskQueue myQueue;
    private final Runnable myInZipper;
    private Task.Backgroundable myInvokedOnQueue;

    public ZipAndQueue(@NotNull Project project, int interval, String title2, @NotNull Disposable parentDisposable, final Runnable runnable) {
        int correctedInterval = interval <= 0 ? 300 : interval;
        this.myZipperUpdater = new ZipperUpdater(correctedInterval, parentDisposable);
        this.myQueue = new BackgroundTaskQueue(project, title2);
        this.myInZipper = () -> this.myQueue.run(this.myInvokedOnQueue);
        this.myInvokedOnQueue = new Task.Backgroundable(project, title2, false){

            public void run(@NotNull ProgressIndicator indicator) {
                runnable.run();
            }
        };
    }

    public void request() {
        this.myZipperUpdater.queue(this.myInZipper);
    }
}

