/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    public static final NotificationGroup NOTIFICATION_GROUP_ID = NotificationGroup.toolWindowGroup((String)"Vcs Messages", (String)"Version Control");
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = new NotificationGroup("Vcs Important Messages", NotificationDisplayType.STICKY_BALLOON, true);
    public static final NotificationGroup STANDARD_NOTIFICATION = new NotificationGroup("Vcs Notifications", NotificationDisplayType.BALLOON, true);
    public static final NotificationGroup SILENT_NOTIFICATION = new NotificationGroup("Vcs Silent Notifications", NotificationDisplayType.NONE, true);
    @NotNull
    private final Project myProject;

    public static VcsNotifier getInstance(@NotNull Project project) {
        return (VcsNotifier)ServiceManager.getService((Project)project, VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        notification.notify(this.myProject);
        return notification;
    }

    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyError(title2, message, (NotificationListener)null);
    }

    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, boolean showDetailsAction) {
        if (showDetailsAction && ProjectLevelVcsManager.getInstance((Project)this.myProject).isConsoleVisible()) {
            return this.notifyError(title2, message, this.createShowDetailsAction());
        }
        return this.notifyError(title2, message);
    }

    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.ERROR, actions);
    }

    @NotNull
    public Notification notifyWeakError(@NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyWeakError("", message);
    }

    @NotNull
    public Notification notifyWeakError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.ERROR, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationContent @NotNull String message) {
        return this.notifySuccess("", message);
    }

    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notifySuccess(title2, message, null);
    }

    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyInfo("", message);
    }

    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyInfo(title2, message, null);
    }

    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyMinorWarning(title2, message, null);
    }

    @NotNull
    public Notification notifyMinorWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(STANDARD_NOTIFICATION, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyWarning(title2, message, null);
    }

    @NotNull
    public Notification notifyWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantWarning(@Nls @NotNull String title2, @Nls @NotNull String message, NotificationAction ... actions) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.WARNING, actions);
    }

    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notifyMinorInfo(title2, message, (NotificationListener)null);
    }

    @NotNull
    public Notification notifyMinorInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(STANDARD_NOTIFICATION, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        return this.notify(STANDARD_NOTIFICATION, title2, message, NotificationType.INFORMATION, actions);
    }

    @NotNull
    public Notification notifyMinorInfo(boolean sticky, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        return this.notifyMinorInfo(sticky, null, title2, message, actions);
    }

    @NotNull
    public Notification notifyMinorInfo(boolean sticky, @NonNls @Nullable String notificationDisplayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        return this.notify(sticky ? IMPORTANT_ERROR_NOTIFICATION : STANDARD_NOTIFICATION, notificationDisplayId, title2, message, NotificationType.INFORMATION, actions);
    }

    public Notification logInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        return this.notify(SILENT_NOTIFICATION, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    public void showNotificationAndHideExisting(@NotNull Notification notificationToShow, @NotNull Class<? extends Notification> klass) {
        this.hideAllNotificationsByType(klass);
        notificationToShow.notify(this.myProject);
    }

    public void hideAllNotificationsByType(@NotNull Class<? extends Notification> klass) {
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        for (Notification notification : notificationsManager.getNotificationsOfType(klass, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    private static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2, @Nullable String notificationDisplayId) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = title2;
            title2 = "";
        }
        return notificationGroup.createNotification(title2, message, type, listener2, notificationDisplayId);
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        Notification notification = VcsNotifier.createNotification(notificationGroup, title2, message, type, listener2, null);
        return this.notify(notification);
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, NotificationAction ... actions) {
        return this.notify(notificationGroup, null, title2, message, type, actions);
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String notificationDisplayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, NotificationAction ... actions) {
        Notification notification = VcsNotifier.createNotification(notificationGroup, title2, message, type, null, notificationDisplayId);
        for (NotificationAction action : actions) {
            notification.addAction((AnAction)action);
        }
        return this.notify(notification);
    }

    @NotNull
    private NotificationAction createShowDetailsAction() {
        return NotificationAction.createSimple((String)VcsBundle.message((String)"notification.showDetailsInConsole", (Object[])new Object[0]), () -> {
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            vcsManager2.showConsole(() -> ((ProjectLevelVcsManager)vcsManager2).scrollConsoleToTheEnd());
        });
    }
}

