/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PathDescription;
import com.intellij.openapi.diff.impl.patch.StaticPathDescription;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaTextPatchBuilder {
    private IdeaTextPatchBuilder() {
    }

    private static List<BeforeAfter<AirContentRevision>> revisionsConvertor(@NotNull Project project, @NotNull List<? extends Change> changes, boolean honorExcludedFromCommit) {
        ArrayList<BeforeAfter<AirContentRevision>> result2 = new ArrayList<BeforeAfter<AirContentRevision>>(changes.size());
        IdeaTextPatchBuilder.addConvertChanges(project, changes, result2, honorExcludedFromCommit);
        return result2;
    }

    private static void addConvertChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull List<? super BeforeAfter<AirContentRevision>> result2, boolean honorExcludedFromCommit) {
        List<Change> otherChanges = PartialChangesUtil.processPartialChanges(project, changes, false, (PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean>)((PairFunction)(partialChanges, tracker) -> {
            if (!tracker.hasPartialChangesToCommit()) {
                return false;
            }
            List changelistIds = ContainerUtil.map((Collection)partialChanges, ChangeListChange::getChangeListId);
            Change change = ((ChangeListChange)partialChanges.get(0)).getChange();
            PartialCommitHelper helper = tracker.handlePartialCommit(Side.LEFT, changelistIds, honorExcludedFromCommit);
            String actualText = helper.getContent();
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), actualText)));
            return true;
        }));
        for (Change change : otherChanges) {
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), null)));
        }
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, Collection<? extends Change> changes, String basePath, boolean reversePatch) throws VcsException {
        return IdeaTextPatchBuilder.buildPatch(project, changes, basePath, reversePatch, false);
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, Collection<? extends Change> changes, String basePath, boolean reversePatch, boolean honorExcludedFromCommit) throws VcsException {
        List<Object> revisions;
        if (project != null) {
            revisions = IdeaTextPatchBuilder.revisionsConvertor(project, new ArrayList<Change>(changes), honorExcludedFromCommit);
        } else {
            revisions = new ArrayList(changes.size());
            for (Change change : changes) {
                revisions.add(new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision())));
            }
        }
        return TextPatchBuilder.buildPatch(revisions, basePath, reversePatch, () -> ProgressManager.checkCanceled());
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr) {
        return IdeaTextPatchBuilder.convertRevision(cr, null);
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr, @Nullable String actualTextContent) {
        if (cr == null) {
            return null;
        }
        FilePath fp = cr.getFile();
        StaticPathDescription description = new StaticPathDescription(fp.isDirectory(), fp.getIOFile().lastModified(), fp.getPath());
        if (actualTextContent != null) {
            return new PartialTextAirContentRevision(actualTextContent, cr, description, null);
        }
        if (cr instanceof BinaryContentRevision) {
            return new BinaryAirContentRevision((BinaryContentRevision)cr, description, null);
        }
        return new TextAirContentRevision(cr, description, null);
    }

    private static class PartialTextAirContentRevision
    extends TextAirContentRevision {
        @NotNull
        private final String myContent;

        PartialTextAirContentRevision(@NotNull String content2, @NotNull ContentRevision delegateRevision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            super(delegateRevision, description, timestamp);
            this.myContent = content2;
        }

        @Override
        public String getContentAsString() {
            return this.myContent;
        }

        @Override
        public byte[] getContentAsBytes() {
            return this.myContent.getBytes(this.getCharset());
        }
    }

    private static class TextAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final ContentRevision myRevision;
        @NotNull
        private final StaticPathDescription myDescription;
        @Nullable
        private final Long myTimestamp;

        TextAirContentRevision(@NotNull ContentRevision revision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            this.myRevision = revision;
            this.myDescription = description;
            this.myTimestamp = timestamp;
        }

        public boolean isBinary() {
            return false;
        }

        public String getContentAsString() throws VcsException {
            return this.myRevision.getContent();
        }

        public byte[] getContentAsBytes() throws VcsException {
            if (this.myRevision instanceof ByteBackedContentRevision) {
                return ((ByteBackedContentRevision)this.myRevision).getContentAsBytes();
            }
            String textContent = this.getContentAsString();
            if (textContent == null) {
                return null;
            }
            return textContent.getBytes(this.getCharset());
        }

        public String getRevisionNumber() {
            return this.myTimestamp != null ? null : this.myRevision.getRevisionNumber().asString();
        }

        @NotNull
        public PathDescription getPath() {
            return this.myDescription;
        }

        @NotNull
        public Charset getCharset() {
            return this.myRevision.getFile().getCharset();
        }

        @Nullable
        public String getLineSeparator() {
            VirtualFile virtualFile = this.myRevision.getFile().getVirtualFile();
            return virtualFile != null ? virtualFile.getDetectedLineSeparator() : null;
        }
    }

    private static class BinaryAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final BinaryContentRevision myRevision;
        @NotNull
        private final StaticPathDescription myDescription;
        @Nullable
        private final Long myTimestamp;

        BinaryAirContentRevision(@NotNull BinaryContentRevision revision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            this.myRevision = revision;
            this.myDescription = description;
            this.myTimestamp = timestamp;
        }

        public boolean isBinary() {
            return true;
        }

        public String getContentAsString() {
            throw new IllegalStateException();
        }

        public byte[] getContentAsBytes() throws VcsException {
            return this.myRevision.getBinaryContent();
        }

        public String getRevisionNumber() {
            return this.myTimestamp != null ? null : this.myRevision.getRevisionNumber().asString();
        }

        @NotNull
        public PathDescription getPath() {
            return this.myDescription;
        }
    }
}

