/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.StartUseVcsDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartUseVcsAction
extends DumbAwareAction {
    public StartUseVcsAction() {
        super(VcsBundle.messagePointer((String)"action.enable.version.control.integration.text", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = StartUseVcsAction.isEnabled(project);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
        if (enabled) {
            presentation.setText(VcsBundle.messagePointer((String)"action.enable.version.control.integration.text", (Object[])new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String vcsName;
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (!StartUseVcsAction.isEnabled(project)) {
            return;
        }
        StartUseVcsDialog dialog = new StartUseVcsDialog(project);
        dialog.show();
        if (dialog.getExitCode() == 0 && (vcsName = dialog.getVcs()).length() > 0) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsName);
            assert (vcs != null) : "No vcs found for name " + vcsName;
            vcs.enableIntegration();
        }
    }

    private static boolean isEnabled(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        ProjectLevelVcsManagerImpl manager = ProjectLevelVcsManagerImpl.getInstanceImpl(project);
        return manager.haveVcses() && !manager.hasAnyMappings();
    }
}

