/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNodeKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/dvcs/repo/Repository;", "repository", "(Lcom/intellij/dvcs/repo/Repository;)V", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManagerImpl;", "appendCurrentBranch", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "compareUserObjects", "", "o2", "getSortWeight", "getTextPresentation", "", "render", "selected", "", "expanded", "hasFocus", "Companion", "intellij.platform.vcs.dvcs.impl"})
public final class RepositoryChangesBrowserNode
extends ChangesBrowserNode<Repository> {
    private final VcsLogColorManagerImpl colorManager;
    public static final Companion Companion = new Companion(null);

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.setIcon((Icon)new ColorIcon(RepositoryChangesBrowserNodeKt.access$getICON_SIZE$p(), (Color)VcsLogColorManagerImpl.getBackgroundColor(this.colorManager.getRootColor(((Repository)this.getUserObject()).getRoot()))));
        renderer.append(' ' + this.getTextPresentation(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer);
        if (renderer.isShowingLocalChanges()) {
            this.appendCurrentBranch(renderer);
        }
    }

    private final void appendCurrentBranch(ChangesBrowserNodeRenderer renderer) {
        Repository repository = (Repository)this.getUserObject();
        BranchData branch = CurrentBranchComponent.Companion.getCurrentBranch(repository.getProject(), repository.getRoot());
        if (branch != null) {
            renderer.append(FontUtil.spaceAndThinSpace());
            String string = ' ' + CurrentBranchComponent.Companion.getPresentableText(branch) + ' ';
            Color color = renderer.getBackground();
            if (color == null) {
                color = UIUtil.getTreeBackground();
            }
            renderer.append(string, RepositoryChangesBrowserNodeKt.access$getBranchLabelAttributes(color));
            renderer.setBackgroundInsets(RepositoryChangesBrowserNodeKt.access$getBRANCH_BACKGROUND_INSETS$p());
            renderer.setToolTipText(CurrentBranchComponent.Companion.getSingleTooltip(branch));
        }
    }

    @Override
    public int getSortWeight() {
        return 3;
    }

    @Override
    public int compareUserObjects(@NotNull Repository o2) {
        return RepositoryChangesBrowserNode.access$compareFileNames$s-273927513(DvcsUtil.getShortRepositoryName((Repository)this.getUserObject()), DvcsUtil.getShortRepositoryName(o2));
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        return DvcsUtil.getShortRepositoryName((Repository)this.getUserObject());
    }

    public RepositoryChangesBrowserNode(@NotNull Repository repository) {
        super(repository);
        this.colorManager = Companion.getColorManager(repository.getProject());
    }

    public static final /* synthetic */ int access$compareFileNames$s-273927513(String p0, String p1) {
        return ChangesBrowserNode.compareFileNames(p0, p1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode$Companion;", "", "()V", "getColorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        @NotNull
        public final VcsLogColorManagerImpl getColorManager(@NotNull Project project) {
            Object object = VcsProjectLog.getInstance(project).getLogManager();
            if (object == null || (object = ((VcsLogManager)object).getColorManager()) == null) {
                object = new VcsLogColorManagerImpl(VcsLogManager.findLogProviders(ArraysKt.asList((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()), project).keySet());
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

