/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsRepositoryManager
implements Disposable {
    public static final ExtensionPointName<VcsRepositoryCreator> EP_NAME = new ExtensionPointName("com.intellij.vcsRepositoryCreator");
    private static final Logger LOG = Logger.getInstance(VcsRepositoryManager.class);
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED = new Topic(VcsRepositoryMappingListener.class, Topic.BroadcastDirection.NONE);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK = new ReentrantReadWriteLock();
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories = new HashMap<VirtualFile, Repository>();
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories = new HashMap<VirtualFile, Repository>();
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private volatile boolean myDisposed;

    @NotNull
    public static VcsRepositoryManager getInstance(@NotNull Project project) {
        return (VcsRepositoryManager)Objects.requireNonNull(project.getService(VcsRepositoryManager.class));
    }

    public VcsRepositoryManager(@NotNull Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::scheduleUpdate);
        EP_NAME.addChangeListener(() -> {
            this.disposeAllRepositories(false);
            this.scheduleUpdate();
            ((VcsRepositoryMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
        }, (Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
        this.disposeAllRepositories(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllRepositories(boolean disposeExternal) {
        this.REPO_LOCK.writeLock().lock();
        try {
            for (Repository repo : this.myRepositories.values()) {
                Disposer.dispose((Disposable)repo);
            }
            this.myRepositories.clear();
            if (disposeExternal) {
                for (Repository repo : this.myExternalRepositories.values()) {
                    Disposer.dispose((Disposable)repo);
                }
                this.myExternalRepositories.clear();
            }
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    private void scheduleUpdate() {
        if (this.myUpdateAlarm.isDisposed()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> this.checkAndUpdateRepositoriesCollection(null), 0);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file) {
        return this.getRepositoryForFile(file, false);
    }

    @Nullable
    public Repository getRepositoryForFileQuick(@NotNull VirtualFile file) {
        return this.getRepositoryForFile(file, true);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file, boolean quick) {
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        if (vcsRoot == null) {
            return this.getExternalRepositoryForFile(file);
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull FilePath file, boolean quick) {
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        if (vcsRoot == null) {
            return this.getExternalRepositoryForFile(file);
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getExternalRepositoryForFile(@NotNull VirtualFile file) {
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
            if (!entry.getKey().isValid() || !VfsUtilCore.isAncestor((VirtualFile)entry.getKey(), (VirtualFile)file, (boolean)false)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public Repository getExternalRepositoryForFile(@NotNull FilePath file) {
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
            if (!entry.getKey().isValid() || !FileUtil.isAncestor((String)entry.getKey().getPath(), (String)file.getPath(), (boolean)false)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Repository getRepositoryForRoot(@Nullable VirtualFile root, boolean updateIfNeeded) {
        if (root == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (updateIfNeeded && application.isDispatchThread() && !application.isUnitTestMode() && !application.isHeadlessEnvironment()) {
            updateIfNeeded = false;
            LOG.error("Do not call synchronous repository update in EDT");
        }
        this.REPO_LOCK.readLock().lock();
        try {
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root);
            if (repo != null) {
                Repository repository = repo;
                return repository;
            }
            Repository externalRepo = this.myExternalRepositories.get(root);
            if (externalRepo != null) {
                Repository repository = externalRepo;
                return repository;
            }
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (updateIfNeeded && ArrayUtil.contains((Object)root, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoriesCollection(root);
            this.REPO_LOCK.readLock().lock();
            try {
                Repository repository = this.myRepositories.get(root);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return null;
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root, repository);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public boolean isExternal(@NotNull Repository repository) {
        this.REPO_LOCK.readLock().lock();
        try {
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        try {
            ArrayList<Repository> arrayList = new ArrayList<Repository>(this.myRepositories.values());
            return arrayList;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> getExternalRepositories() {
        this.REPO_LOCK.readLock().lock();
        try {
            HashMap<VirtualFile, Repository> hashMap = new HashMap<VirtualFile, Repository>(this.myExternalRepositories);
            return hashMap;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateRepositoriesCollection(@Nullable VirtualFile checkedRoot) {
        this.MODIFY_LOCK.lock();
        try {
            HashMap<VirtualFile, Repository> repositories;
            this.REPO_LOCK.readLock().lock();
            try {
                repositories = new HashMap<VirtualFile, Repository>(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            if (checkedRoot != null && repositories.containsKey(checkedRoot)) {
                return;
            }
            Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.values());
            repositories.keySet().removeAll(invalidRoots);
            Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
            repositories.putAll(newRoots);
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    for (VirtualFile file : this.myRepositories.keySet()) {
                        Repository newRepo;
                        Repository oldRepo = this.myRepositories.get(file);
                        if (oldRepo == (newRepo = (Repository)repositories.get(file))) continue;
                        Disposer.dispose((Disposable)oldRepo);
                    }
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
        ((VcsRepositoryMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        HashMap<VirtualFile, Repository> newRootsMap = new HashMap<VirtualFile, Repository>();
        for (VcsRoot root : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            AbstractVcs vcs;
            VcsRepositoryCreator repositoryCreator;
            VirtualFile rootPath = root.getPath();
            if (knownRoots.contains(rootPath) || (repositoryCreator = VcsRepositoryManager.getRepositoryCreator(vcs = root.getVcs())) == null || (repository = repositoryCreator.createRepositoryIfValid(this.myProject, rootPath, this)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        return newRootsMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<Repository> repositories) {
        ArrayList<VirtualFile> invalidRepos = new ArrayList<VirtualFile>();
        for (Repository repo : repositories) {
            VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(repo.getRoot());
            if (vcsRoot != null && repo.getRoot().equals(vcsRoot.getPath()) && repo.getVcs().equals((Object)vcsRoot.getVcs())) continue;
            invalidRepos.add(repo.getRoot());
        }
        return invalidRepos;
    }

    @Nullable
    private static VcsRepositoryCreator getRepositoryCreator(@Nullable AbstractVcs vcs) {
        if (vcs == null) {
            return null;
        }
        return (VcsRepositoryCreator)EP_NAME.findFirstSafe(creator -> creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod()));
    }

    @NotNull
    public String toString() {
        return "RepositoryManager{myRepositories: " + this.myRepositories + '}';
    }

    public void checkAndUpdateRepositories() {
        this.checkAndUpdateRepositoriesCollection(null);
    }

    public void waitForAsyncTaskCompletion() {
        try {
            this.myUpdateAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            VcsRepositoryManager.getInstance(project).checkAndUpdateRepositoriesCollection(null);
        }

        @Override
        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }
    }
}

