/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.push.ui.VcsBranchEditorListener;
import com.intellij.dvcs.push.ui.VcsEditableComponent;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushLog
extends JPanel
implements DataProvider {
    @NonNls
    private static final String CONTEXT_MENU = "Vcs.Push.ContextMenu";
    @NonNls
    private static final String START_EDITING = "startEditing";
    @NonNls
    private static final String TREE_SPLITTER_PROPORTION = "Vcs.Push.Splitter.Tree.Proportion";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "Vcs.Push.Splitter.Details.Proportion";
    private final SimpleChangesBrowser myChangesBrowser;
    private final CheckboxTree myTree;
    private final MyTreeCellRenderer myTreeCellRenderer;
    private final JScrollPane myScrollPane;
    private final CommitDetailsPanel myDetailsPanel;
    private final MyShowDetailsAction myShowDetailsAction;
    private boolean myShouldRepaint = false;
    private boolean mySyncStrategy;
    @Nullable
    private String mySyncRenderedText;
    private final boolean myAllowSyncStrategy;

    public PushLog(Project project, final CheckedTreeNode root, boolean allowSyncStrategy) {
        this.myAllowSyncStrategy = allowSyncStrategy;
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeModel.nodeStructureChanged((TreeNode)root);
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, root){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }

            public boolean isPathEditable(TreePath path2) {
                return this.isEditable() && path2.getLastPathComponent() instanceof DefaultMutableTreeNode;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)node).fireOnSelectionChange(node.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path2 = PushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path2 == null) {
                    return "";
                }
                Object node = path2.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                if (node instanceof TooltipNode) {
                    String select = DvcsBundle.getString("push.select.all.commit.details");
                    return ((TooltipNode)node).getTooltip() + "<p style='font-style:italic;color:gray;'>" + select + "</p>";
                }
                return "";
            }

            public boolean stopEditing() {
                JComponent editedComponent;
                InputVerifier verifier;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode && (verifier = (editedComponent = (JComponent)node.getUserObject()).getInputVerifier()) != null && !verifier.verify(editedComponent)) {
                    return false;
                }
                boolean result2 = super.stopEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(node);
                return result2;
            }

            public void cancelEditing() {
                DefaultMutableTreeNode lastSelectedPathComponent = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                super.cancelEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(lastSelectedPathComponent);
            }

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, path2 -> {
                    Object pathComponent = path2.getLastPathComponent();
                    if (pathComponent instanceof RepositoryNode) {
                        return ((RepositoryNode)pathComponent).getRepositoryName();
                    }
                    return pathComponent.toString();
                });
            }
        };
        this.myTree.setUI((TreeUI)((Object)new MyTreeUi()));
        this.myTree.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.myTree.setEditable(true);
        this.myTree.setShowsRootHandles(root.getChildCount() > 1);
        MyTreeCellEditor treeCellEditor = new MyTreeCellEditor();
        this.myTree.setCellEditor((TreeCellEditor)treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode) {
                    JComponent editedComponent = (JComponent)node.getUserObject();
                    InputVerifier verifier = editedComponent.getInputVerifier();
                    if (verifier != null && !verifier.verify(editedComponent)) {
                        ((EditableTreeNode)((Object)node)).fireOnCancel();
                    } else if (PushLog.this.mySyncStrategy) {
                        PushLog.this.resetEditSync();
                        ContainerUtil.process((List)PushLog.getChildNodesByType((DefaultMutableTreeNode)root, RepositoryNode.class, false), node1 -> {
                            node1.fireOnChange();
                            return true;
                        });
                    } else {
                        ((EditableTreeNode)((Object)node)).fireOnChange();
                    }
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node)).fireOnCancel();
                }
                PushLog.this.resetEditSync();
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }
        });
        this.myTree.setInvokesStopCellEditing(true);
        this.myTree.setRootVisible(false);
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        VcsBranchEditorListener linkMouseListener = new VcsBranchEditorListener(this.myTreeCellRenderer);
        linkMouseListener.installOn((Component)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PushLog.this.updateChangesView();
            }
        });
        this.myTree.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof RepositoryNode && PushLog.this.myTree.isEditing()) {
                    PushLog.this.myTree.getCellEditor().getTreeCellEditorComponent((JTree)PushLog.this.myTree, node, true, false, false, PushLog.this.myTree.getRowForPath(TreeUtil.getPathFromRoot((TreeNode)node)));
                }
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "");
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)this.myTree);
        expandAllAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)this.myTree);
        CollapseAllAction collapseAll = new CollapseAllAction((JTree)this.myTree);
        collapseAll.registerCustomShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet(), (JComponent)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"Vcs.Log.ContextMenu", (String)CONTEXT_MENU);
        this.myChangesBrowser = new SimpleChangesBrowser(project, false, false){

            @Override
            @NotNull
            protected Border createViewerBorder() {
                return IdeBorderFactory.createBorder((int)2);
            }
        };
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)this.myTree);
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this.myChangesBrowser);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myChangesBrowser);
        this.myChangesBrowser.addToolbarAction((AnAction)editSourceAction);
        this.setDefaultEmptyText();
        this.myDetailsPanel = new CommitDetailsPanel(project, (Function1<? super CommitId, Unit>)((Function1)e -> Unit.INSTANCE));
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)this.myDetailsPanel, 20, 31);
        detailsScrollPane.setBorder((Border)JBUI.Borders.empty());
        detailsScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        BorderLayoutPanel detailsContentPanel = new BorderLayoutPanel();
        detailsContentPanel.addToCenter((Component)detailsScrollPane);
        OnePixelSplitter detailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.67f);
        detailsSplitter.setFirstComponent((JComponent)this.myChangesBrowser);
        this.myShowDetailsAction = new MyShowDetailsAction(project, arg_0 -> PushLog.lambda$new$1((JBSplitter)detailsSplitter, detailsContentPanel, arg_0));
        this.myShowDetailsAction.setEnabled(false);
        this.myChangesBrowser.addToolbarSeparator();
        this.myChangesBrowser.addToolbarAction((AnAction)this.myShowDetailsAction);
        OnePixelSplitter splitter = new OnePixelSplitter(TREE_SPLITTER_PROPORTION, 0.5f);
        final JComponent syncStrategyPanel = this.myAllowSyncStrategy ? this.createStrategyPanel() : null;
        this.myScrollPane = new JBScrollPane((Component)this.myTree){

            public void layout() {
                super.layout();
                if (syncStrategyPanel != null) {
                    Rectangle bounds = this.getViewport().getBounds();
                    int height = bounds.height - syncStrategyPanel.getPreferredSize().height;
                    this.getViewport().setBounds(bounds.x, bounds.y, bounds.width, height);
                    syncStrategyPanel.setBounds(bounds.x, bounds.y + height, bounds.width, syncStrategyPanel.getPreferredSize().height);
                }
            }
        };
        if (syncStrategyPanel != null) {
            this.myScrollPane.setViewport((JViewport)((Object)new MyTreeViewPort((Component)this.myTree, syncStrategyPanel.getPreferredSize().height)));
        }
        this.myScrollPane.getViewport().setScrollMode(0);
        this.myScrollPane.setOpaque(false);
        if (syncStrategyPanel != null) {
            this.myScrollPane.add(syncStrategyPanel);
        }
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        splitter.setFirstComponent((JComponent)this.myScrollPane);
        splitter.setSecondComponent((JComponent)detailsSplitter);
        this.setBorder(IdeBorderFactory.createBorder((int)8));
        this.setLayout(new BorderLayout());
        this.add((Component)splitter);
        this.myTree.setRowHeight(0);
    }

    public void highlightNodeOrFirst(@Nullable RepositoryNode repositoryNode, boolean shouldScrollTo) {
        TreePath selectionPath = repositoryNode != null ? TreeUtil.getPathFromRoot((TreeNode)((Object)repositoryNode)) : TreeUtil.getFirstNodePath((JTree)this.myTree);
        this.myTree.setSelectionPath(selectionPath);
        if (shouldScrollTo) {
            this.myTree.scrollPathToVisible(selectionPath);
        }
    }

    private void restoreSelection(@Nullable DefaultMutableTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
        }
    }

    private JComponent createStrategyPanel() {
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(RenderingUtil.getBackground((JTree)this.myTree));
        final LinkLabel linkLabel = new LinkLabel(DvcsBundle.getString("push.edit.all.targets"), null);
        linkLabel.setBorder(JBUI.Borders.empty((int)2));
        linkLabel.setListener((LinkListener)new LinkListener<String>(){

            public void linkSelected(LinkLabel<String> aSource, String aLinkData) {
                if (linkLabel.isEnabled()) {
                    PushLog.this.startSyncEditing();
                }
            }
        }, null);
        this.myTree.addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean editMode = (Boolean)evt.getNewValue();
                linkLabel.setEnabled(editMode == false);
                linkLabel.setPaintUnderline(editMode == false);
                linkLabel.repaint();
            }
        });
        labelPanel.add((Component)linkLabel, "East");
        return labelPanel;
    }

    private void startSyncEditing() {
        this.mySyncStrategy = true;
        DefaultMutableTreeNode nodeToEdit = this.getFirstNodeToEdit();
        if (nodeToEdit != null) {
            this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)nodeToEdit));
        }
    }

    @NotNull
    private static List<Change> collectAllChanges(@NotNull List<? extends CommitNode> commitNodes) {
        return CommittedChangesTreeBrowser.zipChanges(PushLog.collectChanges(commitNodes));
    }

    @NotNull
    private static List<CommitNode> collectSelectedCommitNodes(@NotNull List<DefaultMutableTreeNode> selectedNodes) {
        List nodes = StreamEx.of(selectedNodes).select(RepositoryNode.class).toFlatList(node -> PushLog.getChildNodesByType((DefaultMutableTreeNode)((Object)node), CommitNode.class, true));
        nodes.addAll(((StreamEx)StreamEx.of(selectedNodes).select(CommitNode.class).filter(node -> !nodes.contains(node))).toList());
        return nodes;
    }

    @NotNull
    private static List<Change> collectChanges(@NotNull List<? extends CommitNode> commitNodes) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (CommitNode commitNode : commitNodes) {
            changes.addAll(commitNode.getUserObject().getChanges());
        }
        return changes;
    }

    @NotNull
    private static <T> List<T> getChildNodesByType(@NotNull DefaultMutableTreeNode node, Class<T> type, boolean reverseOrder) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        if (node.getChildCount() < 1) {
            return nodes;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (type.isInstance(childNode)) {
                DefaultMutableTreeNode nodeT = childNode;
                if (reverseOrder) {
                    nodes.add(0, nodeT);
                } else {
                    nodes.add(nodeT);
                }
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
        return nodes;
    }

    @NotNull
    private static List<Integer> getSortedRows(int @NotNull [] rows) {
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        for (int row2 : rows) {
            sorted.add(row2);
        }
        sorted.sort(Collections.reverseOrder());
        return sorted;
    }

    private void updateChangesView() {
        List<CommitNode> commitNodes = this.getSelectedCommitNodes();
        if (!commitNodes.isEmpty()) {
            this.myChangesBrowser.getViewer().setEmptyText(DvcsBundle.message("push.no.differences", new Object[0]));
        } else {
            this.setDefaultEmptyText();
        }
        this.myChangesBrowser.setChangesToDisplay(PushLog.collectAllChanges(commitNodes));
        if (commitNodes.size() == 1 && this.getSelectedTreeNodes().stream().noneMatch(it -> it instanceof RepositoryNode)) {
            this.myDetailsPanel.setCommit((VcsCommitMetadata)commitNodes.get(0).getUserObject());
            this.myShowDetailsAction.setEnabled(true);
        } else {
            this.myShowDetailsAction.setEnabled(false);
        }
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText(DvcsBundle.message("push.no.commits.selected", new Object[0]));
    }

    @Nullable
    public Object getData(@NotNull String id) {
        if (VcsDataKeys.CHANGES.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return PushLog.collectAllChanges(commitNodes).toArray(new Change[0]);
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ContainerUtil.map2Array(commitNodes, VcsRevisionNumber.class, commitNode -> {
                Hash hash = (Hash)commitNode.getUserObject().getId();
                return new TextRevisionNumber(hash.asString(), hash.toShortString());
            });
        }
        return null;
    }

    @NotNull
    private List<CommitNode> getSelectedCommitNodes() {
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedTreeNodes();
        return selectedNodes.isEmpty() ? Collections.emptyList() : PushLog.collectSelectedCommitNodes(selectedNodes);
    }

    @NotNull
    private List<DefaultMutableTreeNode> getSelectedTreeNodes() {
        int[] rows = this.myTree.getSelectionRows();
        return rows != null && rows.length != 0 ? this.getNodesForRows(PushLog.getSortedRows(rows)) : ContainerUtil.emptyList();
    }

    @NotNull
    private List<DefaultMutableTreeNode> getNodesForRows(@NotNull List<Integer> rows) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (Integer row2 : rows) {
            TreePath path2 = this.myTree.getPathForRow(row2.intValue());
            Object pathComponent = path2 == null ? null : path2.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) continue;
            nodes.add((DefaultMutableTreeNode)pathComponent);
        }
        return nodes;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 10 && this.myTree.isEditing() && e.getModifiers() == 0 && pressed) {
            this.myTree.stopEditing();
            return true;
        }
        if (this.myAllowSyncStrategy && e.getKeyCode() == 113 && e.getModifiers() == 8 && pressed) {
            this.startSyncEditing();
            return true;
        }
        if (CheckboxTreeHelper.isToggleEvent((KeyEvent)e, (JComponent)this.myTree) && pressed) {
            this.toggleRepositoriesFromCommits();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private void toggleRepositoriesFromCommits() {
        LinkedHashSet checkedNodes = (LinkedHashSet)((StreamEx)StreamEx.of(this.getSelectedTreeNodes()).map(n -> n instanceof CommitNode ? n.getParent() : n).select(CheckedTreeNode.class).filter(CheckedTreeNode::isEnabled)).toCollection(LinkedHashSet::new);
        if (checkedNodes.isEmpty()) {
            return;
        }
        boolean newState = !((CheckedTreeNode)checkedNodes.iterator().next()).isChecked();
        checkedNodes.forEach(n -> this.myTree.setNodeState(n, newState));
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNodeToEdit() {
        RepositoryNode selectedNode;
        if (this.myTree.getLastSelectedPathComponent() instanceof RepositoryNode && (selectedNode = (RepositoryNode)this.myTree.getLastSelectedPathComponent()).isEditableNow()) {
            return selectedNode;
        }
        List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
        RepositoryNode editableNode = (RepositoryNode)ContainerUtil.find(repositoryNodes, repositoryNode -> repositoryNode.isEditableNow());
        if (editableNode != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((Object)editableNode));
        }
        return editableNode;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public CheckboxTree getTree() {
        return this.myTree;
    }

    public void selectIfNothingSelected(@NotNull TreeNode node) {
        if (this.myTree.isSelectionEmpty()) {
            this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    public void setChildren(@NotNull DefaultMutableTreeNode parentNode, @NotNull Collection<? extends DefaultMutableTreeNode> childrenNodes) {
        parentNode.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : childrenNodes) {
            parentNode.add(defaultMutableTreeNode);
        }
        if (!this.myTree.isEditing()) {
            this.refreshNode(parentNode);
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)parentNode);
            if (this.myTree.getSelectionModel().isPathSelected(path2)) {
                this.updateChangesView();
            }
        } else {
            this.myShouldRepaint = true;
        }
    }

    private void refreshNode(@NotNull DefaultMutableTreeNode parentNode) {
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(parentNode);
        this.autoExpandChecked(parentNode);
        this.myShouldRepaint = false;
    }

    private void autoExpandChecked(@NotNull DefaultMutableTreeNode node) {
        if (node.getChildCount() <= 0) {
            return;
        }
        if (node instanceof RepositoryNode) {
            this.expandIfChecked((RepositoryNode)((Object)node));
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (!(childNode instanceof RepositoryNode)) {
                return;
            }
            this.expandIfChecked((RepositoryNode)((Object)childNode));
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
    }

    private void expandIfChecked(@NotNull RepositoryNode node) {
        if (node.isChecked()) {
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)((Object)node));
            this.myTree.expandPath(path2);
        }
    }

    private void setSyncText(String value) {
        this.mySyncRenderedText = value;
    }

    public void fireEditorUpdated(@NotNull String currentText) {
        if (this.mySyncStrategy) {
            List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
            for (RepositoryNode node : repositoryNodes) {
                if (!node.isEditableNow()) continue;
                node.forceUpdateUiModelWithTypedText(currentText);
            }
            this.setSyncText(currentText);
            this.myTree.repaint();
        }
    }

    private void resetEditSync() {
        if (this.mySyncStrategy) {
            this.mySyncStrategy = false;
            this.mySyncRenderedText = null;
        }
    }

    private static /* synthetic */ void lambda$new$1(JBSplitter detailsSplitter, BorderLayoutPanel detailsContentPanel, Boolean state) {
        detailsSplitter.setSecondComponent((JComponent)(state != false ? detailsContentPanel : null));
    }

    private static class MyShowDetailsAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final PushSettings mySettings;
        @NotNull
        private final Consumer<Boolean> myOnUpdate;

        MyShowDetailsAction(@NotNull Project project, @NotNull Consumer<Boolean> onUpdate) {
            super(DvcsBundle.message("push.show.details", new Object[0]), AllIcons.Actions.PreviewDetailsVertically);
            this.mySettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
            this.myOnUpdate = onUpdate;
        }

        private boolean getValue() {
            return this.mySettings.getShowDetailsInPushDialog();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.getValue();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setShowDetailsInPushDialog(state);
            this.myOnUpdate.accept(state);
        }

        public void setEnabled(boolean enabled) {
            this.myOnUpdate.accept(enabled && this.getValue());
            super.setEnabled(enabled);
        }
    }

    private static class MyTreeViewPort
    extends JBViewport {
        final int myHeightToReduce;

        MyTreeViewPort(@Nullable Component view, int heightToReduce) {
            this.setView(view);
            this.myHeightToReduce = heightToReduce;
        }

        public Dimension getExtentSize() {
            Dimension defaultSize = super.getExtentSize();
            return new Dimension(defaultSize.width, defaultSize.height - this.myHeightToReduce);
        }
    }

    private class MyTreeUi
    extends WideSelectionTreeUI {
        private final ComponentListener myTreeSizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MyTreeUi.this.updateSizes();
            }
        };
        private final AncestorListener myTreeAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                super.ancestorMoved(event);
                MyTreeUi.this.updateSizes();
            }
        };

        private MyTreeUi() {
        }

        private void updateSizes() {
            this.treeState.invalidateSizes();
            this.tree.repaint();
        }

        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.myTreeSizeListener);
            this.tree.addAncestorListener(this.myTreeAncestorListener);
        }

        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.myTreeSizeListener);
            this.tree.removeAncestorListener(this.myTreeAncestorListener);
            super.uninstallListeners();
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row2, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row2, depth, expanded, size);
                    dimensions.width = Math.max(PushLog.this.myScrollPane != null ? PushLog.this.myScrollPane.getViewport().getWidth() - this.getRowX(row2, depth) : ((PushLog)PushLog.this).myTree.getMinimumSize().width, dimensions.width);
                    return dimensions;
                }
            };
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private RepositoryWithBranchPanel myValue;

        private MyTreeCellEditor() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row2) {
            RepositoryWithBranchPanel panel2;
            this.myValue = panel2 = (RepositoryWithBranchPanel)((Object)((DefaultMutableTreeNode)value).getUserObject());
            PushLog.this.myTree.firePropertyChange("tree.edit.mode", false, true);
            return panel2.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row2, true);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)anEvent;
                TreePath path2 = PushLog.this.myTree.getClosestPathForLocation(me.getX(), me.getY());
                int row2 = PushLog.this.myTree.getRowForLocation(me.getX(), me.getY());
                PushLog.this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)PushLog.this.myTree, path2.getLastPathComponent(), false, false, true, row2, true);
                Object tag = me.getClickCount() >= 1 ? PushLogTreeUtil.getTagAtForRenderer(PushLog.this.myTreeCellRenderer, me) : null;
                return tag instanceof VcsEditableComponent;
            }
            TreePath treePath = PushLog.this.myTree.getAnchorSelectionPath();
            if (treePath == null) {
                return true;
            }
            Object treeNode = treePath.getLastPathComponent();
            return treeNode instanceof EditableTreeNode && ((EditableTreeNode)treeNode).isEditableNow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return;
            }
            this.myCheckbox.setBorder(null);
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            renderer.setIpad((Insets)JBUI.emptyInsets());
            if (value instanceof RepositoryNode) {
                RepositoryNode valueNode = (RepositoryNode)value;
                boolean isCheckboxVisible = valueNode.isCheckboxVisible();
                this.myCheckbox.setVisible(isCheckboxVisible);
                if (!isCheckboxVisible) {
                    renderer.setIpad((Insets)JBUI.insets((int)0, (int)10));
                }
                if (valueNode.isChecked() && valueNode.isLoading()) {
                    this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
                } else {
                    this.myCheckbox.setSelected(valueNode.isChecked());
                }
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (value instanceof CustomRenderedTreeNode) {
                if (tree.isEditing() && PushLog.this.mySyncStrategy && value instanceof RepositoryNode) {
                    ((RepositoryNode)value).render(renderer, PushLog.this.mySyncRenderedText);
                } else {
                    ((CustomRenderedTreeNode)value).render(renderer);
                }
            } else {
                renderer.append(userObject == null ? "" : userObject.toString());
            }
        }
    }
}

