/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import com.intellij.openapi.vcs.actions.VcsQuickListPopupAction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsQuickListContentProvider
implements VcsQuickListContentProvider {
    @Nullable
    public List<AnAction> getVcsActions(@Nullable Project project, @Nullable AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null || !this.replaceVcsActionsFor(activeVcs, dataContext)) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        ActionGroup vcsGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("Vcs.Operations.Popup");
        ActionGroup vcsAwareGroup = (ActionGroup)ContainerUtil.find((Object[])vcsGroup.getChildren(null), action -> {
            if (action instanceof CustomisedActionGroup) {
                action = ((CustomisedActionGroup)action).getOrigin();
            }
            return action instanceof VcsQuickListPopupAction.VcsAware;
        });
        if (vcsAwareGroup != null) {
            ContainerUtil.addAll(actions, (Object[])vcsAwareGroup.getChildren(null));
        }
        List<AnAction> providerActions = this.collectVcsSpecificActions(manager);
        actions.removeAll(providerActions);
        actions.add((AnAction)Separator.getInstance());
        actions.addAll(providerActions);
        return actions;
    }

    @NotNull
    protected abstract String getVcsName();

    protected abstract List<AnAction> collectVcsSpecificActions(@NotNull ActionManager var1);

    public boolean replaceVcsActionsFor(@NotNull AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        return this.getVcsName().equals(activeVcs.getName());
    }

    protected static void add(String actionName, ActionManager manager, List<? super AnAction> actions) {
        AnAction action = manager.getAction(actionName);
        assert (action != null) : "Can not find action " + actionName;
        actions.add((AnAction)action);
    }
}

