/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

@State(name="TerminalArrangementManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class TerminalArrangementManager
implements PersistentStateComponent<TerminalArrangementState> {
    private static final Logger LOG = Logger.getInstance(TerminalArrangementManager.class);
    private final TerminalWorkingDirectoryManager myWorkingDirectoryManager;
    private ToolWindow myTerminalToolWindow;
    private TerminalArrangementState myState;
    private final Set<String> myTrackingCommandHistoryFileNames = ContainerUtil.newConcurrentSet();

    public TerminalArrangementManager() {
        this.myWorkingDirectoryManager = new TerminalWorkingDirectoryManager();
    }

    public void setToolWindow(@NotNull ToolWindow terminalToolWindow) {
        this.myTerminalToolWindow = terminalToolWindow;
        this.myWorkingDirectoryManager.init(terminalToolWindow);
    }

    @Nullable
    public TerminalArrangementState getState() {
        if (!TerminalArrangementManager.isAvailable() || this.myTerminalToolWindow == null) {
            return null;
        }
        return this.calcArrangementState(this.myTerminalToolWindow);
    }

    public void loadState(@NotNull TerminalArrangementState state) {
        if (TerminalArrangementManager.isAvailable()) {
            this.myState = state;
            this.myTrackingCommandHistoryFileNames.addAll(TerminalArrangementManager.getCommandHistoryFileNames(state));
        }
    }

    @NotNull
    private static List<String> getCommandHistoryFileNames(@NotNull TerminalArrangementState state) {
        return ContainerUtil.mapNotNull(state.myTabStates, tabState -> tabState.myCommandHistoryFileName);
    }

    @Nullable
    public TerminalArrangementState getArrangementState() {
        return this.myState;
    }

    @NotNull
    private TerminalArrangementState calcArrangementState(@NotNull ToolWindow terminalToolWindow) {
        TerminalArrangementState arrangementState = new TerminalArrangementState();
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            JBTerminalWidget terminalWidget = TerminalView.getWidgetByContent(content);
            if (terminalWidget == null) continue;
            TerminalTabState tabState = new TerminalTabState();
            tabState.myTabName = content.getTabName();
            tabState.myWorkingDirectory = this.myWorkingDirectoryManager.getWorkingDirectory(content);
            String historyFilePath = ShellTerminalWidget.getCommandHistoryFilePath(terminalWidget);
            tabState.myCommandHistoryFileName = historyFilePath != null ? PathUtil.getFileName((String)historyFilePath) : null;
            arrangementState.myTabStates.add(tabState);
        }
        Content selectedContent = contentManager.getSelectedContent();
        arrangementState.mySelectedTabIndex = selectedContent == null ? -1 : contentManager.getIndexOfContent(selectedContent);
        this.deleteUnusedCommandHistoryFiles(TerminalArrangementManager.getCommandHistoryFileNames(arrangementState));
        return arrangementState;
    }

    public void register(@NotNull JBTerminalWidget terminalWidget, @Nullable TerminalTabState tabState) {
        File historyFile;
        String historyFileName;
        if (!TerminalArrangementManager.isAvailable()) {
            return;
        }
        File historyDir = TerminalArrangementManager.getCommandHistoryDirectory();
        if (!FileUtil.createDirectory((File)historyDir)) {
            LOG.warn("No such directory " + historyDir.getAbsolutePath());
            return;
        }
        String string = historyFileName = tabState != null ? tabState.myCommandHistoryFileName : null;
        if (historyFileName == null) {
            try {
                historyFile = FileUtil.createTempFile((File)historyDir, (String)"history-", null, (boolean)true, (boolean)false);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        historyFile = new File(historyDir, historyFileName);
        if (!historyFile.isFile()) {
            try {
                historyFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myTrackingCommandHistoryFileNames.add(historyFile.getName());
        if (terminalWidget instanceof ShellTerminalWidget) {
            ((ShellTerminalWidget)terminalWidget).setCommandHistoryFilePath(historyFile.getAbsolutePath());
        }
    }

    @NotNull
    private static File getCommandHistoryDirectory() {
        return PathManager.getConfigDir().resolve("terminal/history").toFile();
    }

    private void deleteUnusedCommandHistoryFiles(@NotNull List<String> keepCommandHistoryFileNames) {
        this.myTrackingCommandHistoryFileNames.removeAll(keepCommandHistoryFileNames);
        File historyDir = null;
        for (String fileName : this.myTrackingCommandHistoryFileNames) {
            File file;
            if (historyDir == null) {
                historyDir = TerminalArrangementManager.getCommandHistoryDirectory();
            }
            if (!(file = new File(historyDir, fileName)).exists() || FileUtil.delete((File)file)) continue;
            LOG.warn("Cannot delete " + file.getAbsolutePath());
        }
        this.myTrackingCommandHistoryFileNames.clear();
    }

    @NotNull
    public static TerminalArrangementManager getInstance(@NotNull Project project) {
        return (TerminalArrangementManager)ServiceManager.getService((Project)project, TerminalArrangementManager.class);
    }

    static boolean isAvailable() {
        return Registry.is((String)"terminal.persistent.tabs");
    }
}

