/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.Comparing;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.LanguageLevel;

public class JpsJavaModuleExtensionImpl
extends JpsCompositeElementBase<JpsJavaModuleExtensionImpl>
implements JpsJavaModuleExtension {
    private static final JpsUrlListRole JAVADOC_ROOTS_ROLE = new JpsUrlListRole("javadoc roots");
    private static final JpsUrlListRole ANNOTATIONS_ROOTS_ROLE = new JpsUrlListRole("annotation roots");
    private String myOutputUrl;
    private String myTestOutputUrl;
    private boolean myInheritOutput;
    private boolean myExcludeOutput;
    private LanguageLevel myLanguageLevel;

    public JpsJavaModuleExtensionImpl() {
        this.myContainer.setChild((JpsElementChildRole)JAVADOC_ROOTS_ROLE);
        this.myContainer.setChild((JpsElementChildRole)ANNOTATIONS_ROOTS_ROLE);
    }

    private JpsJavaModuleExtensionImpl(JpsJavaModuleExtensionImpl original) {
        super((JpsCompositeElementBase)original);
        this.myOutputUrl = original.myOutputUrl;
        this.myTestOutputUrl = original.myTestOutputUrl;
        this.myLanguageLevel = original.myLanguageLevel;
    }

    @NotNull
    public JpsJavaModuleExtensionImpl createCopy() {
        return new JpsJavaModuleExtensionImpl(this);
    }

    @NotNull
    public JpsUrlList getAnnotationRoots() {
        return (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)ANNOTATIONS_ROOTS_ROLE);
    }

    @NotNull
    public JpsUrlList getJavadocRoots() {
        return (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)JAVADOC_ROOTS_ROLE);
    }

    public String getOutputUrl() {
        return this.myOutputUrl;
    }

    public void setOutputUrl(String outputUrl) {
        if (!Objects.equals(this.myOutputUrl, outputUrl)) {
            this.myOutputUrl = outputUrl;
            this.fireElementChanged();
        }
    }

    public String getTestOutputUrl() {
        return this.myTestOutputUrl;
    }

    public void setTestOutputUrl(String testOutputUrl) {
        if (!Objects.equals(this.myTestOutputUrl, testOutputUrl)) {
            this.myTestOutputUrl = testOutputUrl;
            this.fireElementChanged();
        }
    }

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void setLanguageLevel(LanguageLevel languageLevel) {
        if (!Comparing.equal((Object)this.myLanguageLevel, (Object)languageLevel)) {
            this.myLanguageLevel = languageLevel;
            this.fireElementChanged();
        }
    }

    public void applyChanges(@NotNull JpsJavaModuleExtensionImpl modified) {
        this.setLanguageLevel(modified.myLanguageLevel);
        this.setInheritOutput(modified.myInheritOutput);
        this.setExcludeOutput(modified.myExcludeOutput);
        this.setOutputUrl(modified.myOutputUrl);
        this.setTestOutputUrl(modified.myTestOutputUrl);
    }

    public boolean isInheritOutput() {
        return this.myInheritOutput;
    }

    public void setInheritOutput(boolean inheritOutput) {
        if (this.myInheritOutput != inheritOutput) {
            this.myInheritOutput = inheritOutput;
            this.fireElementChanged();
        }
    }

    public boolean isExcludeOutput() {
        return this.myExcludeOutput;
    }

    public void setExcludeOutput(boolean excludeOutput) {
        if (this.myExcludeOutput != excludeOutput) {
            this.myExcludeOutput = excludeOutput;
            this.fireElementChanged();
        }
    }
}

