/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class IgnoredPatternSet {
    private final Set<String> myMasks = new LinkedHashSet<String>();
    private final FileTypeAssocTable<Boolean> myIgnorePatterns = new FileTypeAssocTable().copy();

    @NotNull
    Set<String> getIgnoreMasks() {
        return Collections.unmodifiableSet(this.myMasks);
    }

    public void setIgnoreMasks(@NotNull String list) {
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            String ignoredFile = tokenizer.nextToken();
            this.addIgnoreMask(ignoredFile);
        }
    }

    void addIgnoreMask(@NotNull String ignoredFile) {
        if (this.myIgnorePatterns.findAssociatedFileType(ignoredFile) == null) {
            this.myMasks.add(ignoredFile);
            this.myIgnorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    public boolean isIgnored(@NotNull CharSequence fileName) {
        if (this.myIgnorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return StringUtil.endsWith((CharSequence)fileName, (CharSequence)".__del__");
    }

    void clearPatterns() {
        this.myMasks.clear();
        this.myIgnorePatterns.removeAllAssociations(Boolean.TRUE);
    }
}

