/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.util.PairConsumer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jetbrains.annotations.NotNull;

public abstract class TreeModelAdapter
implements TreeModelListener {
    @NotNull
    public static TreeModelListener create(final @NotNull PairConsumer<? super TreeModelEvent, ? super EventType> consumer) {
        return new TreeModelAdapter(){

            @Override
            protected void process(@NotNull TreeModelEvent event, @NotNull EventType type) {
                consumer.consume((Object)event, (Object)type);
            }
        };
    }

    protected void process(@NotNull TreeModelEvent event, @NotNull EventType type) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent event) {
        if (event != null) {
            this.process(event, EventType.StructureChanged);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent event) {
        if (event != null) {
            this.process(event, EventType.NodesChanged);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent event) {
        if (event != null) {
            this.process(event, EventType.NodesInserted);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent event) {
        if (event != null) {
            this.process(event, EventType.NodesRemoved);
        }
    }

    public static enum EventType {
        StructureChanged,
        NodesChanged,
        NodesInserted,
        NodesRemoved;

    }
}

