/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupUiUtil {
    private static String ourSystemLaFClassName;
    private static volatile StyleSheet ourDefaultHtmlKitCss;
    public static final String ARIAL_FONT_NAME = "Arial";

    @NotNull
    public static String getSystemLookAndFeelClassName() {
        if (ourSystemLaFClassName != null) {
            return ourSystemLaFClassName;
        }
        if (SystemInfo.isLinux) {
            try {
                String name = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                Class<?> cls = Class.forName(name);
                LookAndFeel laf = (LookAndFeel)cls.newInstance();
                if (laf.isSupportedLookAndFeel()) {
                    ourSystemLaFClassName = name;
                    return ourSystemLaFClassName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ourSystemLaFClassName = UIManager.getSystemLookAndFeelClassName();
        return ourSystemLaFClassName;
    }

    public static void initDefaultLaF() throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        StartupUiUtil.blockATKWrapper();
        Activity activity = StartUpMeasurer.startActivity((String)"LaF initialization");
        UIManager.setLookAndFeel(StartupUiUtil.getSystemLookAndFeelClassName());
        activity.end();
    }

    public static void configureHtmlKitStylesheet() {
        if (ourDefaultHtmlKitCss != null) {
            return;
        }
        Activity activity = StartUpMeasurer.startActivity((String)"html kit configuration");
        HTMLEditorKit kit = new HTMLEditorKit();
        ourDefaultHtmlKitCss = kit.getStyleSheet();
        kit.setStyleSheet(null);
        UIManager.getDefaults().put("javax.swing.JLabel.userStyleSheet", JBHtmlEditorKit.createStyleSheet());
        activity.end();
    }

    @NotNull
    public static StyleSheet createStyleSheet(@NotNull String css) {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.loadRules(new StringReader(css), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return styleSheet;
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    @ApiStatus.Internal
    public static int doGetLcdContrastValueForSplash(boolean isUnderDarcula) {
        if (SystemInfo.isMacIntel64) {
            return isUnderDarcula ? 140 : 230;
        }
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map == null) {
            return 140;
        }
        Object o = map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
        if (o == null) {
            return 140;
        }
        int lcdContrastValue = (Integer)o;
        return StartupUiUtil.normalizeLcdContrastValue(lcdContrastValue);
    }

    static int normalizeLcdContrastValue(int lcdContrastValue) {
        return lcdContrastValue < 100 || lcdContrastValue > 250 ? 140 : lcdContrastValue;
    }

    private static void blockATKWrapper() {
        if (!SystemInfo.isLinux || !SystemProperties.getBooleanProperty((String)"linux.jdk.accessibility.atkwrapper.block", (boolean)true)) {
            return;
        }
        if (ScreenReader.isEnabled("org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            Logger.getInstance(StartupUiUtil.class).info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
    }

    static StyleSheet getDefaultHtmlKitCss() {
        return ourDefaultHtmlKitCss;
    }

    public static boolean isJreHiDPI() {
        return JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable Component comp) {
        GraphicsConfiguration gc = comp != null ? comp.getGraphicsConfiguration() : null;
        return JreHiDpiUtil.isJreHiDPI(gc);
    }

    public static boolean isJreHiDPI(@Nullable ScaleContext ctx) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(ctx));
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        return StartupUiUtil.getCenterPoint(new Rectangle(container), child);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        return new Point(container.x + (container.width - child.width) / 2, container.y + (container.height - child.height) / 2);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        StartupUiUtil.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    @Deprecated
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, int width, int height, @Nullable ImageObserver observer) {
        StartupUiUtil.drawImage(g, image, x, y, width, height, null, observer);
    }

    static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, int width, int height, @Nullable BufferedImageOp op, ImageObserver observer) {
        Rectangle srcBounds = width >= 0 && height >= 0 ? new Rectangle(x, y, width, height) : null;
        StartupUiUtil.drawImage(g, image, new Rectangle(x, y, width, height), srcBounds, op, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable ImageObserver observer) {
        StartupUiUtil.drawImage(g, image, dstBounds, null, null, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        int userWidth = ImageUtil.getUserWidth(image);
        int userHeight = ImageUtil.getUserHeight(image);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean hasDstSize = dw >= 0 && dh >= 0;
        Graphics invG = null;
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate = hidpiImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if ((scale = hidpiImage.getScale()) == (tx = ((Graphics2D)g).getTransform()).getScaleX()) {
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        double _scale = scale;
        Function size = size1 -> (int)Math.round((double)size1.intValue() * _scale);
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = (Integer)size.fun((Object)dw);
                dh = (Integer)size.fun((Object)dh);
            }
            if (srcBounds != null) {
                int sh;
                int sx = (Integer)size.fun((Object)srcBounds.x);
                int sy = (Integer)size.fun((Object)srcBounds.y);
                int sw = srcBounds.width >= 0 ? (Integer)size.fun((Object)srcBounds.width) : (Integer)size.fun((Object)userWidth) - sx;
                int n = sh = srcBounds.height >= 0 ? (Integer)size.fun((Object)srcBounds.height) : (Integer)size.fun((Object)userHeight) - sy;
                if (!hasDstSize) {
                    dw = (Integer)size.fun((Object)userWidth);
                    dh = (Integer)size.fun((Object)userHeight);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }

    public static void drawImage(@NotNull Graphics g, @NotNull BufferedImage image, @Nullable BufferedImageOp op, int x, int y) {
        StartupUiUtil.drawImage(g, image, x, y, -1, -1, op, null);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static boolean isDialogFont(@NotNull Font font) {
        return "Dialog".equals(font.getFamily(Locale.US));
    }
}

