/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Couple;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Centerizer
extends JPanel {
    private TYPE type;

    public Centerizer(@NotNull JComponent comp) {
        this(comp, TYPE.BOTH);
    }

    public Centerizer(@NotNull JComponent comp, @NotNull TYPE type) {
        super(false);
        this.type = type;
        this.setOpaque(false);
        this.setBorder(null);
        this.setFocusable(false);
        this.add(comp);
    }

    @Nullable
    private Component getComponent() {
        if (this.getComponentCount() != 1) {
            return null;
        }
        return this.getComponent(0);
    }

    @Override
    public void doLayout() {
        Component c = this.getComponent();
        if (c == null) {
            return;
        }
        Dimension compSize = c.getPreferredSize();
        Dimension size = this.getSize();
        Couple x = this.type == TYPE.BOTH || this.type == TYPE.HORIZONTAL ? Centerizer.getFit(compSize.width, size.width) : Couple.of((Object)0, (Object)compSize.width);
        Couple y = this.type == TYPE.BOTH || this.type == TYPE.VERTICAL ? Centerizer.getFit(compSize.height, size.height) : Couple.of((Object)0, (Object)compSize.height);
        c.setBounds((Integer)x.first, (Integer)y.first, (Integer)x.second, (Integer)y.second);
    }

    private static Couple<Integer> getFit(int compSize, int containerSize) {
        if (compSize >= containerSize) {
            return Couple.of((Object)0, (Object)compSize);
        }
        int position = containerSize / 2 - compSize / 2;
        return Couple.of((Object)position, (Object)compSize);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getComponent() != null ? this.getComponent().getPreferredSize() : super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getComponent() != null ? this.getComponent().getMinimumSize() : super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getComponent() != null ? this.getComponent().getMaximumSize() : super.getPreferredSize();
    }

    public static enum TYPE {
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }
}

