/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ui.StartupUiUtil;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.Map;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public final class FontUtil {
    @NotNull
    public static String leftArrow(@NotNull Font font) {
        return FontUtil.canDisplay(font, '\u2190', "<-");
    }

    @NotNull
    public static String rightArrow(@NotNull Font font) {
        return FontUtil.canDisplay(font, '\u2192', "->");
    }

    public static boolean isValidFont(@NotNull Font font) {
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static String upArrow(@NotNull Font font, @NotNull String defaultValue) {
        return FontUtil.canDisplay(font, '\u2191', defaultValue);
    }

    @NotNull
    public static String canDisplay(@NotNull Font font, char value, @NotNull String defaultValue) {
        return font.canDisplay(value) ? String.valueOf(value) : defaultValue;
    }

    @NotNull
    public static String spaceAndThinSpace() {
        return " " + FontUtil.thinSpace();
    }

    @NotNull
    public static String thinSpace() {
        return FontUtil.canDisplay(StartupUiUtil.getLabelFont(), '\u2009', " ");
    }

    @NotNull
    public static Font minusOne(@NotNull Font font) {
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    @NotNull
    public static Font deriveFont(@NotNull Font oldFont, @NotNull Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        Font newFont = oldFont.deriveFont(attributes);
        return oldFont instanceof UIResource ? new FontUIResource(newFont) : newFont;
    }

    @NotNull
    public static Font disableKerning(@NotNull Font font) {
        return FontUtil.deriveFont(font, DisableKerning.LAZY);
    }

    @NotNull
    public static Font enableKerning(@NotNull Font font) {
        return FontUtil.deriveFont(font, EnableKerning.LAZY);
    }

    private static final class EnableKerning {
        private static final Map<AttributedCharacterIterator.Attribute, Integer> LAZY = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);

        private EnableKerning() {
        }
    }

    private static final class DisableKerning {
        private static final Map<AttributedCharacterIterator.Attribute, Integer> LAZY = Collections.singletonMap(TextAttribute.KERNING, null);

        private DisableKerning() {
        }
    }
}

