/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentTreeEventDispatcher<T extends EventListener> {
    private final Class<T> myListenerClass;
    private final T myMulticaster;

    public static <T extends EventListener> ComponentTreeEventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        return ComponentTreeEventDispatcher.create(null, listenerClass);
    }

    public static <T extends EventListener> ComponentTreeEventDispatcher<T> create(@Nullable Component root, @NotNull Class<T> listenerClass) {
        return new ComponentTreeEventDispatcher<T>(root, listenerClass);
    }

    private ComponentTreeEventDispatcher(@Nullable Component root, @NotNull Class<T> listenerClass) {
        this.myListenerClass = listenerClass;
        this.myMulticaster = (EventListener)EventDispatcher.createMulticaster(listenerClass, null, () -> {
            JBTreeTraverser traverser = UIUtil.uiTraverser(root);
            if (root == null) {
                traverser = (JBTreeTraverser)traverser.withRoots(Arrays.asList(Window.getWindows()));
            }
            return traverser.postOrderDfsTraversal().filter(this.myListenerClass);
        });
    }

    @NotNull
    public T getMulticaster() {
        return this.myMulticaster;
    }
}

