/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import org.jetbrains.annotations.NotNull;

public abstract class Scaler {
    protected double initialScale = this.currentScale();

    private double alignedScale() {
        return this.currentScale() / this.initialScale;
    }

    public boolean isPreScaled() {
        return this.initialScale != 1.0;
    }

    public void setPreScaled(boolean preScaled) {
        this.initialScale = preScaled ? this.currentScale() : 1.0;
    }

    public double scaleVal(double value) {
        return value * this.alignedScale();
    }

    protected abstract double currentScale();

    public boolean update(@NotNull Scaler scaler) {
        boolean updated = this.initialScale != scaler.initialScale;
        this.initialScale = scaler.initialScale;
        return updated;
    }
}

