/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSDefaults {
    private static final Logger LOG = Logger.getInstance(NSDefaults.class);
    public static final String ourTouchBarDomain = "com.apple.touchbar.agent";
    public static final String ourTouchBarNode = "PresentationModePerApp";
    public static final String ourTouchBarShowFnValue = "functionKeys";

    public static boolean isShowFnKeysEnabled(String appId) {
        Path path = Path.createDomainPath(ourTouchBarDomain, ourTouchBarNode);
        String sval = path.readStringVal(appId);
        return sval != null && sval.equals(ourTouchBarShowFnValue);
    }

    public static boolean setShowFnKeysEnabled(String appId, boolean val) {
        return NSDefaults.setShowFnKeysEnabled(appId, val, false);
    }

    public static boolean setShowFnKeysEnabled(String appId, boolean val, boolean performExtraDebugChecks) {
        Path path;
        String sval;
        if (!NSDefaults.isDomainExists(ourTouchBarDomain)) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put(ourTouchBarNode, new HashMap());
            NSDefaults.createPersistentDomain(ourTouchBarDomain, vals);
            if (!NSDefaults.isDomainExists(ourTouchBarDomain)) {
                LOG.error("can't create domain 'com.apple.touchbar.agent'");
                return false;
            }
        }
        boolean settingEnabled = (sval = (path = Path.createDomainPath(ourTouchBarDomain, ourTouchBarNode)).readStringVal(appId)) != null && sval.equals(ourTouchBarShowFnValue);
        String initDesc = "appId='" + appId + "', value (requested be set) ='" + val + "', initial path (tail) value = '" + sval + "', path='" + path.toString() + "'";
        if (val == settingEnabled) {
            if (performExtraDebugChecks) {
                LOG.error("nothing to change: " + initDesc);
            }
            return false;
        }
        path.writeStringValue(appId, val ? ourTouchBarShowFnValue : null);
        if (performExtraDebugChecks) {
            boolean isFNEnabled;
            sval = path.readStringVal(appId, true);
            boolean bl = isFNEnabled = sval != null && sval.equals(ourTouchBarShowFnValue);
            if (val != isFNEnabled) {
                LOG.error("can't write value '" + val + "' (was written just now, but read '" + sval + "'): " + initDesc);
            } else {
                LOG.error("value '" + val + "' was written from second attempt: " + initDesc);
            }
        }
        return true;
    }

    public static String readStringVal(String domain, String key) {
        Path result = new Path();
        result.myPath.add(new Path.Node("persistentDomainForName:", domain));
        return result.readStringVal(key);
    }

    public static boolean isDomainExists(String domain) {
        Path result = new Path();
        result.myPath.add(new Path.Node("persistentDomainForName:", domain));
        return result.lastValidPos() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPersistentDomain(@NotNull String domainName, @Nullable Map<String, Object> values) {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults == null || defaults.equals((Object)ID.NIL)) {
                return;
            }
            ID dict = Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
            if (values != null) {
                for (Map.Entry<String, Object> me : values.entrySet()) {
                    Object val = me.getValue();
                    if (val instanceof String) {
                        Foundation.invoke(dict, "setObject:forKey:", new Object[]{Foundation.nsString((String)val), Foundation.nsString(me.getKey())});
                        continue;
                    }
                    if (val instanceof Map) {
                        ID internalDict = Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
                        Foundation.invoke(dict, "setObject:forKey:", new Object[]{internalDict, Foundation.nsString(me.getKey())});
                        continue;
                    }
                    LOG.error("unsupported type of domain value: " + String.valueOf(val));
                }
            }
            Foundation.invoke(defaults, "setPersistentDomain:forName:", new Object[]{dict, Foundation.nsString(domainName)});
        }
        finally {
            pool.drain();
        }
    }

    public static void removePersistentDomain(@NotNull String domainName) {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults == null || defaults.equals((Object)ID.NIL)) {
                return;
            }
            Foundation.invoke(defaults, "removePersistentDomainForName:", new Object[]{Foundation.nsString(domainName)});
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDarkMenuBar() {
        assert (SystemInfo.isMac);
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults == null || defaults.equals((Object)ID.NIL)) {
                boolean bl = false;
                return bl;
            }
            ID valObj = Foundation.invoke(defaults, "objectForKey:", new Object[]{Foundation.nsString("AppleInterfaceStyle")});
            if (valObj == null || valObj.equals((Object)ID.NIL)) {
                boolean bl = false;
                return bl;
            }
            String sval = Foundation.toStringViaUTF8(valObj);
            boolean bl = sval != null && sval.equals("Dark");
            return bl;
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _listAllKeys() {
        ArrayList<String> res = new ArrayList<String>(100);
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            ID allKeysDict = Foundation.invoke(defaults, "dictionaryRepresentation", new Object[0]);
            ID allKeysArr = Foundation.invoke(allKeysDict, "allKeys", new Object[0]);
            ID count = Foundation.invoke(allKeysArr, "count", new Object[0]);
            for (int c = 0; c < count.intValue(); ++c) {
                ID nsKeyName = Foundation.invoke(allKeysArr, "objectAtIndex:", c);
                String keyName = Foundation.toStringViaUTF8(nsKeyName);
                res.add(keyName);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            pool.drain();
        }
    }

    private static class Path {
        @NotNull
        private final ArrayList<Node> myPath = new ArrayList();

        private Path() {
        }

        public String toString() {
            String res = "";
            for (Node pn : this.myPath) {
                if (!res.isEmpty()) {
                    res = res + " | ";
                }
                res = res + pn.toString();
            }
            return res;
        }

        String readStringVal(@NotNull String key) {
            return this.readStringVal(key, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String readStringVal(@NotNull String key, boolean doSyncronize) {
            if (this.myPath.isEmpty()) {
                return null;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults == null || defaults.equals((Object)ID.NIL)) {
                    String string = null;
                    return string;
                }
                if (doSyncronize) {
                    Foundation.invoke(defaults, "synchronize", new Object[0]);
                }
                this._readPath(defaults);
                Node tail = this.myPath.get(this.myPath.size() - 1);
                if (!tail.isValid()) {
                    String string = null;
                    return string;
                }
                ID valObj = Foundation.invoke(tail.cachedNodeObj, "objectForKey:", new Object[]{Foundation.nsString(key)});
                if (valObj == null || valObj.equals((Object)ID.NIL)) {
                    String string = null;
                    return string;
                }
                String string = Foundation.toStringViaUTF8(valObj);
                return string;
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeStringValue(@NotNull String key, String val) {
            if (this.myPath.isEmpty()) {
                return;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults == null || defaults.equals((Object)ID.NIL)) {
                    return;
                }
                this._readPath(defaults);
                int pos = this.myPath.size() - 1;
                Node child = this.myPath.get(pos--);
                if (!child.isValid() && val == null) {
                    return;
                }
                child.writeStringValue(key, val);
                while (pos >= 0) {
                    Node parent = this.myPath.get(pos--);
                    ID mnode = Foundation.invoke(parent.cachedNodeObj, "mutableCopy", new Object[0]);
                    Foundation.invoke(mnode, "setObject:forKey:", new Object[]{child.cachedNodeObj, Foundation.nsString(child.myNodeName)});
                    parent.cachedNodeObj = mnode;
                    child = parent;
                }
                String topWriteSelector = child.isDomain() ? "setPersistentDomain:forName:" : "setObject:forKey:";
                Foundation.invoke(defaults, topWriteSelector, new Object[]{child.cachedNodeObj, Foundation.nsString(child.myNodeName)});
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int lastValidPos() {
            if (this.myPath.isEmpty()) {
                return -1;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults == null || defaults.equals((Object)ID.NIL)) {
                    int n = -1;
                    return n;
                }
                this._readPath(defaults);
                for (int pos = 0; pos < this.myPath.size(); ++pos) {
                    Node pn = this.myPath.get(pos);
                    if (pn.isValid()) continue;
                    int n = pos - 1;
                    return n;
                }
                int n = this.myPath.size() - 1;
                return n;
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        @NotNull
        static Path createDomainPath(@NotNull String domain, String @NotNull [] nodes) {
            Path result = new Path();
            result.myPath.add(new Node("persistentDomainForName:", domain));
            for (String nodeName : nodes) {
                result.myPath.add(new Node("objectForKey:", nodeName));
            }
            return result;
        }

        @NotNull
        static Path createDomainPath(@NotNull String domain, @NotNull String nodeName) {
            Path result = new Path();
            result.myPath.add(new Node("persistentDomainForName:", domain));
            result.myPath.add(new Node("objectForKey:", nodeName));
            return result;
        }

        private void _readPath(ID parent) {
            if (this.myPath.isEmpty()) {
                return;
            }
            for (Node pn : this.myPath) {
                pn.readNode(parent);
                if (!pn.isValid()) {
                    return;
                }
                parent = pn.cachedNodeObj;
            }
        }

        private void _resetPathCache() {
            for (Node pn : this.myPath) {
                pn.cachedNodeObj = ID.NIL;
            }
        }

        private static class Node {
            @NotNull
            private final String mySelector;
            @NotNull
            private final String myNodeName;
            @NotNull
            private ID cachedNodeObj = ID.NIL;

            Node(@NotNull String selector, @NotNull String nodeName) {
                this.mySelector = selector;
                this.myNodeName = nodeName;
            }

            public String toString() {
                return String.format("sel='%s' nodeName='%s'", this.mySelector, this.myNodeName);
            }

            boolean isValid() {
                return !this.cachedNodeObj.equals((Object)ID.NIL);
            }

            boolean isDomain() {
                return this.mySelector.equals("persistentDomainForName:");
            }

            void readNode(ID parent) {
                this.cachedNodeObj = ID.NIL;
                if (parent == null || parent.equals((Object)ID.NIL)) {
                    return;
                }
                ID nodeObj = Foundation.invoke(parent, this.mySelector, new Object[]{Foundation.nsString(this.myNodeName)});
                if (nodeObj == null || nodeObj.equals((Object)ID.NIL)) {
                    return;
                }
                this.cachedNodeObj = nodeObj;
            }

            private static ID _createDictionary() {
                return Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
            }

            void writeStringValue(@NotNull String key, String val) {
                ID mnode;
                if (!this.isValid()) {
                    if (val == null) {
                        return;
                    }
                    mnode = Node._createDictionary();
                } else {
                    mnode = Foundation.invoke(this.cachedNodeObj, "mutableCopy", new Object[0]);
                }
                if (mnode == null || mnode.equals((Object)ID.NIL)) {
                    return;
                }
                if (val != null) {
                    Foundation.invoke(mnode, "setObject:forKey:", new Object[]{Foundation.nsString(val), Foundation.nsString(key)});
                } else {
                    Foundation.invoke(mnode, "removeObjectForKey:", new Object[]{Foundation.nsString(key)});
                }
                this.cachedNodeObj = mnode;
            }
        }
    }
}

