/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JBColor
extends Color {
    public static final Color PanelBackground = JBColor.namedColor("Panel.background", 0xFFFFFF);
    private final Color darkColor;
    private final NotNullProducer<? extends Color> func;
    public static final JBColor red;
    public static final JBColor RED;
    public static final JBColor blue;
    public static final JBColor BLUE;
    public static final JBColor white;
    public static final JBColor WHITE;
    public static final JBColor black;
    public static final JBColor BLACK;
    public static final JBColor gray;
    public static final JBColor GRAY;
    public static final JBColor lightGray;
    public static final JBColor LIGHT_GRAY;
    public static final JBColor darkGray;
    public static final JBColor DARK_GRAY;
    public static final JBColor pink;
    public static final JBColor PINK;
    public static final JBColor orange;
    public static final JBColor ORANGE;
    public static final JBColor yellow;
    public static final JBColor YELLOW;
    public static final JBColor green;
    public static final JBColor GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    private static final Map<String, Color> defaultThemeColors;

    public JBColor(int rgb, int darkRGB) {
        this(new Color(rgb), new Color(darkRGB));
    }

    public JBColor(@NotNull Color regular, @NotNull Color dark) {
        super(regular.getRGB(), regular.getAlpha() != 255);
        this.darkColor = dark;
        this.func = null;
    }

    public JBColor(@NotNull NotNullProducer<? extends Color> function) {
        super(0);
        this.darkColor = null;
        this.func = function;
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, int defaultValueRGB) {
        return JBColor.namedColor(propertyName, new Color(defaultValueRGB));
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, int defaultValueRGB, int darkValueRGB) {
        return JBColor.namedColor(propertyName, new JBColor(defaultValueRGB, darkValueRGB));
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, @NotNull Color defaultColor) {
        return new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)() -> {
            Color color = (Color)ObjectUtils.notNull((Object)UIManager.getColor(propertyName), () -> (Color)ObjectUtils.notNull((Object)JBColor.findPatternMatch(propertyName), (Object)defaultColor));
            if (UIManager.get(propertyName) == null) {
                UIManager.put(propertyName, color);
            }
            return color;
        }));
    }

    private static Color findPatternMatch(@NotNull String name) {
        Object value = UIManager.get("*");
        if (value instanceof Map) {
            Map cache;
            Map map = (Map)value;
            HashMap o = UIManager.get("*cache");
            if (!(o instanceof Map)) {
                o = new HashMap();
                UIManager.put("*cache", o);
            }
            if ((cache = (Map)o).containsKey(name)) {
                return (Color)cache.get(name);
            }
            Color color = null;
            for (Map.Entry entry : map.entrySet()) {
                Object result;
                if (!(entry.getKey() instanceof String) || !name.endsWith((String)entry.getKey()) || !((result = map.get(entry.getKey())) instanceof Color)) continue;
                color = (Color)result;
                break;
            }
            cache.put(name, color);
            return color;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static Color link() {
        return JBUI.CurrentTheme.Link.linkColor();
    }

    public static void setDark(boolean dark) {
        Lazy.DARK = dark;
    }

    public static boolean isBright() {
        return !Lazy.DARK;
    }

    private Color getDarkVariant() {
        return this.darkColor;
    }

    @NotNull
    Color getColor() {
        return this.func != null ? (Color)this.func.produce() : (Lazy.DARK ? this.getDarkVariant() : this);
    }

    @Override
    public int getRed() {
        Color c = this.getColor();
        return c == this ? super.getRed() : c.getRed();
    }

    @Override
    public int getGreen() {
        Color c = this.getColor();
        return c == this ? super.getGreen() : c.getGreen();
    }

    @Override
    public int getBlue() {
        Color c = this.getColor();
        return c == this ? super.getBlue() : c.getBlue();
    }

    @Override
    public int getAlpha() {
        Color c = this.getColor();
        return c == this ? super.getAlpha() : c.getAlpha();
    }

    @Override
    public int getRGB() {
        Color c = this.getColor();
        return c == this ? super.getRGB() : c.getRGB();
    }

    @Override
    @NotNull
    public Color brighter() {
        if (this.func != null) {
            return new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)() -> ((Color)this.func.produce()).brighter()));
        }
        return new JBColor(super.brighter(), this.getDarkVariant().brighter());
    }

    @Override
    @NotNull
    public Color darker() {
        if (this.func != null) {
            return new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)() -> ((Color)this.func.produce()).darker()));
        }
        return new JBColor(super.darker(), this.getDarkVariant().darker());
    }

    @Override
    public int hashCode() {
        Color c = this.getColor();
        return c == this ? super.hashCode() : c.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        Color c = this.getColor();
        return c == this ? super.equals(obj) : c.equals(obj);
    }

    @Override
    public String toString() {
        Color c = this.getColor();
        return c == this ? super.toString() : c.toString();
    }

    @Override
    public float @NotNull [] getRGBComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getRGBComponents(compArray) : c.getRGBComponents(compArray);
    }

    @Override
    public float @NotNull [] getRGBColorComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getRGBComponents(compArray) : c.getRGBColorComponents(compArray);
    }

    @Override
    public float @NotNull [] getComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getComponents(compArray) : c.getComponents(compArray);
    }

    @Override
    public float @NotNull [] getColorComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getColorComponents(compArray) : c.getColorComponents(compArray);
    }

    @Override
    public float @NotNull [] getComponents(@NotNull ColorSpace colorSpace, float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getComponents(colorSpace, compArray) : c.getComponents(colorSpace, compArray);
    }

    @Override
    public float @NotNull [] getColorComponents(@NotNull ColorSpace colorSpace, float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getColorComponents(colorSpace, compArray) : c.getColorComponents(colorSpace, compArray);
    }

    @Override
    @NotNull
    public ColorSpace getColorSpace() {
        Color c = this.getColor();
        return c == this ? super.getColorSpace() : c.getColorSpace();
    }

    @Override
    @NotNull
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform affineTransform, RenderingHints hints) {
        Color c = this.getColor();
        return c == this ? super.createContext(cm, r, r2d, affineTransform, hints) : c.createContext(cm, r, r2d, affineTransform, hints);
    }

    @Override
    public int getTransparency() {
        Color c = this.getColor();
        return c == this ? super.getTransparency() : c.getTransparency();
    }

    @NotNull
    public static Color foreground() {
        return new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)UIUtil::getLabelForeground));
    }

    @NotNull
    public static Color background() {
        return new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)UIUtil::getListBackground));
    }

    @NotNull
    public static Color border() {
        return JBColor.namedColor("Borders.color", new JBColor(Gray._192, Gray._50));
    }

    @NotNull
    public static Color get(@NotNull String colorId, @NotNull Color defaultColor) {
        return new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)() -> {
            Color color = defaultThemeColors.get(colorId);
            if (color != null) {
                return color;
            }
            defaultThemeColors.put(colorId, defaultColor);
            return defaultColor;
        }));
    }

    static {
        RED = red = new JBColor(Color.red, DarculaColors.RED);
        BLUE = blue = new JBColor(Color.blue, DarculaColors.BLUE);
        WHITE = white = new JBColor(Color.white, JBColor.background());
        BLACK = black = new JBColor(Color.black, JBColor.foreground());
        GRAY = gray = new JBColor(Gray._128, Gray._128);
        LIGHT_GRAY = lightGray = new JBColor(Gray._192, Gray._64);
        DARK_GRAY = darkGray = new JBColor(Gray._64, Gray._192);
        PINK = pink = new JBColor(Color.pink, Color.pink);
        ORANGE = orange = new JBColor(Color.orange, new Color(159, 107, 0));
        YELLOW = yellow = new JBColor(Color.yellow, new Color(138, 138, 0));
        GREEN = green = new JBColor(Color.green, new Color(98, 150, 85));
        MAGENTA = magenta = new JBColor(Color.magenta, new Color(151, 118, 169));
        CYAN = cyan = new JBColor(Color.cyan, new Color(0, 137, 137));
        defaultThemeColors = new HashMap<String, Color>();
    }

    private static final class Lazy {
        private static volatile boolean DARK = StartupUiUtil.isUnderDarcula();

        private Lazy() {
        }
    }
}

