/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public class FilledRoundedBorder
extends LineBorder {
    private final int myArcSize;

    public FilledRoundedBorder(@NotNull Color color, int arcSize, int thickness) {
        super(color, thickness);
        this.myArcSize = arcSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.lineColor);
        RoundRectangle2D.Float area = new RoundRectangle2D.Float(x, y, width, height, this.myArcSize, this.myArcSize);
        g2d.fill(area);
        config.restore();
    }
}

