/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    public static <T> T getClientProperty(@NotNull JComponent component, @NotNull Key<T> key) {
        return (T)component.getClientProperty(key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component, @NotNull Key<T> key, T value) {
        component.putClientProperty(key, value);
    }

    public static boolean isDisableAutoRequestFocus() {
        return Registry.is((String)"suppress.focus.stealing.disable.auto.request.focus", (boolean)true) && !SystemInfo.isXfce && !SystemInfo.isI3;
    }

    public static boolean isMinimized(@Nullable Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)window;
        return frame.getExtendedState() == 1;
    }

    @NotNull
    public static Window getActiveWindow() {
        for (Window each : Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            return each;
        }
        return JOptionPane.getRootFrame();
    }

    @NotNull
    public static Component findUltimateParent(@NotNull Component c) {
        Component parent = c;
        Container nextParent;
        while ((nextParent = parent.getParent()) != null) {
            parent = nextParent;
        }
        return parent;
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    @Nullable
    public static Component findParentByCondition(@Nullable Component c, @NotNull Predicate<? super Component> condition) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!condition.test(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component) {
        while (component != null) {
            if (type.isInstance(component)) {
                return (T)component;
            }
            component = component.getParent();
        }
        return null;
    }
}

