/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.project.ProjectSdkData;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencySyncIssue;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClassSetImportModelProvider;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=0x7FFFFFFE)
public class CommonGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(CommonGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        IntelliJSettings intellijSettings;
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        if (externalProject != null) {
            ideProject.createChild(ExternalProjectDataCache.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
        if ((intellijSettings = (IntelliJSettings)this.resolverCtx.getExtraProject(IntelliJProjectSettings.class)) != null) {
            ideProject.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        CommonGradleProjectResolverExtension.populateProjectSdkModel(gradleProject, ideProject);
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        DataNode<ModuleData> mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
        ModuleData mainModuleData = (ModuleData)mainModuleNode.getData();
        String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
        String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
        String jdkName = CommonGradleProjectResolverExtension.getJdkName(gradleModule);
        String[] moduleGroup = null;
        if (!this.resolverCtx.isUseQualifiedModuleNames()) {
            moduleGroup = CommonGradleProjectResolverExtension.getIdeModuleGroup(mainModuleData.getInternalName(), gradleModule);
            mainModuleData.setIdeModuleGroup(moduleGroup);
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
            assert (externalProject != null);
            for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                String moduleId = GradleProjectResolverUtil.getModuleId(this.resolverCtx, gradleModule, sourceSet);
                String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                String moduleInternalName = GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, sourceSet.getName(), this.resolverCtx);
                GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                sourceSetData.setGroup(externalProject.getGroup());
                if ("main".equals(sourceSet.getName())) {
                    sourceSetData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                }
                sourceSetData.setVersion(externalProject.getVersion());
                sourceSetData.setIdeModuleGroup(moduleGroup);
                sourceSetData.internalSetSourceCompatibility(sourceSet.getSourceCompatibility());
                sourceSetData.internalSetTargetCompatibility(sourceSet.getTargetCompatibility());
                sourceSetData.internalSetSdkName(jdkName);
                THashSet artifacts = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                if ("main".equals(sourceSet.getName())) {
                    Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                    if (defaultArtifacts != null) {
                        artifacts.addAll(defaultArtifacts);
                    }
                } else if ("test".equals(sourceSet.getName())) {
                    sourceSetData.setProductionModuleId(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, "main", this.resolverCtx));
                    Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                    if (testsArtifacts != null) {
                        artifacts.addAll(testsArtifacts);
                    }
                }
                artifacts.addAll(sourceSet.getArtifacts());
                for (ExternalSourceDirectorySet directorySet : sourceSet.getSources().values()) {
                    artifacts.addAll(directorySet.getGradleOutputDirs());
                }
                sourceSetData.setArtifacts(new ArrayList(artifacts));
                DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                assert (sourceSetMap != null);
                sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
                CommonGradleProjectResolverExtension.populateModuleSdkModel(gradleModule, (DataNode<? extends ModuleData>)sourceSetDataNode);
            }
        } else {
            try {
                IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                if (languageSettings != null) {
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.internalSetSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.internalSetTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                mainModuleData.internalSetSdkName(jdkName);
            }
            catch (UnsupportedMethodException languageSettings) {
                // empty catch block
            }
        }
        CommonGradleProjectResolverExtension.populateModuleSdkModel(gradleModule, mainModuleNode);
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        return mainModuleNode;
    }

    private static void populateProjectSdkModel(@NotNull IdeaProject ideaProject, @NotNull DataNode<? extends ProjectData> projectNode) {
        String sdkName = CommonGradleProjectResolverExtension.resolveJdkName(ideaProject.getJdkName());
        ProjectSdkData projectSdkData = new ProjectSdkData(sdkName);
        projectNode.createChild(ProjectSdkData.KEY, (Object)projectSdkData);
    }

    private static void populateModuleSdkModel(@NotNull IdeaModule ideaModule, @NotNull DataNode<? extends ModuleData> moduleNode) {
        String sdkName = CommonGradleProjectResolverExtension.resolveJdkName(ideaModule.getJdkName());
        ModuleSdkData moduleSdkData = new ModuleSdkData(sdkName);
        moduleNode.createChild(ModuleSdkData.KEY, (Object)moduleSdkData);
    }

    @Nullable
    private static String resolveJdkName(@Nullable String jdkNameOrVersion) {
        if (jdkNameOrVersion == null) {
            return null;
        }
        Sdk sdk = SdkLookupUtil.lookupSdk(builder -> builder.withSdkName(jdkNameOrVersion).withSdkType(ExternalSystemJdkUtil.getJavaSdkType()).onDownloadableSdkSuggested(__ -> SdkLookupDecision.STOP));
        return sdk == null ? null : sdk.getName();
    }

    private static String @NotNull [] getIdeModuleGroup(String moduleName, IdeaModule gradleModule) {
        String gradlePath = gradleModule.getGradleProject().getPath();
        String rootName = gradleModule.getProject().getName();
        if (StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath)) {
            return new String[]{moduleName};
        }
        return (rootName + gradlePath).split(":");
    }

    @Nullable
    private static String getJdkName(@NotNull IdeaModule gradleModule) {
        try {
            return gradleModule.getJdkName();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectImportAction.AllModels models;
        ExternalTestsModel externalTestsModel;
        IntelliJSettings intellijSettings;
        GradleExtensions gradleExtensions = this.resolverCtx.getExtraProject(gradleModule, GradleExtensions.class);
        if (gradleExtensions != null) {
            boolean useCustomSerialization = Registry.is((String)"gradle.tooling.custom.serializer", (boolean)true);
            DefaultGradleExtensions extensions = useCustomSerialization ? (DefaultGradleExtensions)gradleExtensions : new DefaultGradleExtensions(gradleExtensions);
            ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
            if (externalProject != null) {
                extensions.addTasks(externalProject.getTasks().values());
            }
            ideModule.createChild(GradleExtensionsDataService.KEY, (Object)extensions);
        }
        if ((intellijSettings = this.resolverCtx.getExtraProject(gradleModule, IntelliJSettings.class)) != null) {
            ideModule.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        if ((externalTestsModel = (ExternalTestsModel)(models = this.resolverCtx.getModels()).getModel((ProjectModel)gradleModule, ExternalTestsModel.class)) != null) {
            for (ExternalTestSourceMapping testSourceMapping : externalTestsModel.getTestSourceMappings()) {
                String testName = testSourceMapping.getTestName();
                String testTaskName = testSourceMapping.getTestTaskPath();
                Set sourceFolders = testSourceMapping.getSourceFolders();
                TestData testData = new TestData(GradleConstants.SYSTEM_ID, testName, testTaskName, sourceFolders);
                ideModule.createChild(ProjectKeys.TEST, (Object)testData);
            }
        }
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (externalProject != null) {
            this.addExternalProjectContentRoots(gradleModule, ideModule, externalProject);
        }
        PathPrefixTreeMap contentRootIndex = new PathPrefixTreeMap();
        for (Object contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            contentRootIndex.set(contentRootData.getRootPath(), (Object)contentRootData);
        }
        DomainObjectSet contentRoots = gradleModule.getContentRoots();
        if (contentRoots == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            boolean oldGradle = false;
            String contentRootPath = FileUtil.toCanonicalPath((String)rootDirectory.getAbsolutePath());
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, contentRootPath);
            contentRootIndex.set(contentRootPath, (Object)ideContentRoot);
            if (!this.resolverCtx.isResolveModulePerSourceSet()) {
                List testResourceDirectories;
                List resourceDirectories;
                List testDirectories;
                List sourceDirectories;
                block11: {
                    sourceDirectories = gradleContentRoot.getSourceDirectories().getAll();
                    testDirectories = gradleContentRoot.getTestDirectories().getAll();
                    resourceDirectories = Collections.emptyList();
                    testResourceDirectories = Collections.emptyList();
                    try {
                        Set<File> notResourceDirs = CommonGradleProjectResolverExtension.collectExplicitNonResourceDirectories(externalProject);
                        resourceDirectories = gradleContentRoot.getResourceDirectories().getAll();
                        CommonGradleProjectResolverExtension.removeDuplicateResources(sourceDirectories, resourceDirectories, notResourceDirs);
                        testResourceDirectories = gradleContentRoot.getTestResourceDirectories().getAll();
                        CommonGradleProjectResolverExtension.removeDuplicateResources(testDirectories, testResourceDirectories, notResourceDirs);
                    }
                    catch (UnsupportedMethodException e) {
                        oldGradle = true;
                        LOG.debug(e.getMessage());
                        if (externalProject != null) break block11;
                        CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                        CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                    }
                }
                if (!oldGradle) {
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, sourceDirectories);
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, testDirectories);
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.RESOURCE, resourceDirectories);
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST_RESOURCE, testResourceDirectories);
                }
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) == null) continue;
            for (File file : excluded) {
                ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
            }
        }
        LinkedHashSet<String> existsContentRoots = new LinkedHashSet<String>();
        for (DataNode contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            existsContentRoots.add(contentRootData.getRootPath());
        }
        for (ContentRootData ideContentRoot : contentRootIndex.getValues()) {
            if (existsContentRoots.contains(ideContentRoot.getRootPath())) continue;
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    @Nullable
    private static ExternalProject getExternalProject(@NotNull IdeaModule gradleModule, @NotNull ProjectResolverContext resolverCtx) {
        ExternalProject project = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (project == null && resolverCtx.isResolveModulePerSourceSet()) {
            LOG.error("External Project model is missing for module-per-sourceSet import mode. Please, check import log for error messages.");
        }
        return project;
    }

    private void addExternalProjectContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull ExternalProject externalProject) {
        CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

            @Override
            public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                    ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                    ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                    for (File file : sourceDirectorySet.getSrcDirs()) {
                        ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                        ideContentRoot.storePath(sourceType, file.getAbsolutePath());
                        dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                    }
                }
            }
        });
    }

    private static void removeDuplicateResources(@NotNull List<? extends IdeaSourceDirectory> sourceDirectories, @NotNull List<? extends IdeaSourceDirectory> resourceDirectories, @NotNull Set<File> notResourceDirs) {
        resourceDirectories.removeIf(ideaSourceDirectory -> notResourceDirs.contains(ideaSourceDirectory.getDirectory()));
        CommonGradleProjectResolverExtension.removeAll(sourceDirectories, resourceDirectories);
    }

    @NotNull
    private static Set<File> collectExplicitNonResourceDirectories(@Nullable ExternalProject externalProject) {
        if (externalProject == null) {
            return Collections.emptySet();
        }
        return (Set)externalProject.getSourceSets().values().stream().flatMap(ss -> ss.getSources().entrySet().stream().filter(e -> !((IExternalSystemSourceType)e.getKey()).isResource()).flatMap(e -> ((ExternalSourceDirectorySet)e.getValue()).getSrcDirs().stream())).collect(Collectors.toCollection(() -> new THashSet(FileUtil.FILE_HASHING_STRATEGY)));
    }

    private static void removeAll(List<? extends IdeaSourceDirectory> list, List<? extends IdeaSourceDirectory> toRemove) {
        Set files = toRemove.stream().map(o -> o.getDirectory()).collect(Collectors.toSet());
        list.removeIf(o -> files.contains(o.getDirectory()));
    }

    private static void processSourceSets(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        HashMap<String, DataNode> sourceSetsMap = new HashMap<String, DataNode>();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        boolean inheritOutputDirs;
        ModuleData moduleData = (ModuleData)ideModule.getData();
        moduleData.useExternalCompilerOutput(this.resolverCtx.isDelegatedBuild());
        File ideaOutDir = new File(moduleData.getLinkedExternalProjectPath(), "out");
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            final HashSet outputDirs = new HashSet();
            assert (externalProject != null);
            CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    MultiMap gradleOutputMap = (MultiMap)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS);
                    if (gradleOutputMap == null) {
                        gradleOutputMap = MultiMap.create();
                        dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)gradleOutputMap);
                    }
                    ModuleData moduleData = (ModuleData)dataNode.getData();
                    moduleData.useExternalCompilerOutput(CommonGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild());
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        File ideOutputDir = CommonGradleProjectResolverExtension.getIdeOutputDir(sourceDirectorySet);
                        File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(sourceDirectorySet);
                        File outputDir = CommonGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild() ? gradleOutputDir : ideOutputDir;
                        moduleData.setCompileOutputPath(sourceType, ideOutputDir == null ? null : ideOutputDir.getAbsolutePath());
                        moduleData.setExternalCompilerOutputPath(sourceType, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        if (outputDir == null) continue;
                        outputDirs.add(outputDir.getPath());
                        for (File file : sourceDirectorySet.getGradleOutputDirs()) {
                            String gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)file.getAbsolutePath());
                            gradleOutputMap.putValue((Object)sourceType, (Object)gradleOutputPath);
                            if (file.getPath().equals(outputDir.getPath())) continue;
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                    }
                }
            });
            if (outputDirs.stream().anyMatch(path -> FileUtil.isAncestor((File)ideaOutDir, (File)new File((String)path), (boolean)false))) {
                CommonGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        boolean bl = inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        if (moduleCompilerOutput != null) {
            File outputDir = moduleCompilerOutput.getOutputDir();
            if (outputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, new File(ideaOutDir, "production/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, new File(ideaOutDir, "production/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.SOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            File testOutputDir = moduleCompilerOutput.getTestOutputDir();
            if (testOutputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, new File(ideaOutDir, "test/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, new File(ideaOutDir, "test/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST_RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            if (!(this.resolverCtx.isDelegatedBuild() || inheritOutputDirs || outputDir != null && testOutputDir != null)) {
                CommonGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Nullable
    public static File getGradleOutputDir(@NotNull ExternalProject externalProject, @NotNull String sourceSetName, @NotNull ExternalSystemSourceType sourceType) {
        ExternalSourceSet sourceSet = (ExternalSourceSet)externalProject.getSourceSets().get(sourceSetName);
        if (sourceSet == null) {
            return null;
        }
        return CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalSourceDirectorySet)sourceSet.getSources().get(sourceType));
    }

    @Nullable
    private static File getIdeOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getOutputDir();
    }

    @Nullable
    private static File getGradleOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getGradleOutputDirs().stream().findFirst().orElse(null);
    }

    private static void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        ContentRootData excludedContentRootData;
        DataNode contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootDataDataNode == null || !FileUtil.isAncestor((File)new File(((ContentRootData)contentRootDataDataNode.getData()).getRootPath()), (File)ideaOutDir, (boolean)false)) {
            excludedContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getAbsolutePath());
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
        } else {
            excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
        }
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getAbsolutePath());
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
            assert (sourceSetMap != null);
            assert (artifactsMap != null);
            assert (externalProject != null);
            CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    GradleProjectResolverUtil.buildDependencies(CommonGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                }
            });
            return;
        }
        List dependencies = gradleModule.getDependencies().getAll();
        if (dependencies == null) {
            return;
        }
        ArrayList<String> orphanModules = new ArrayList<String>();
        HashMap<String, ModuleData> modulesIndex = new HashMap<String, ModuleData>();
        for (DataNode dataNode : ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE)) {
            modulesIndex.put(((ModuleData)dataNode.getData()).getExternalName(), (ModuleData)dataNode.getData());
        }
        for (int i2 = 0; i2 < dependencies.size(); ++i2) {
            ModuleDependencyData d;
            IdeaDependency dependency = (IdeaDependency)dependencies.get(i2);
            if (dependency == null) continue;
            DependencyScope scope = CommonGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = CommonGradleProjectResolverExtension.buildDependency(this.resolverCtx, ideModule, (IdeaModuleDependency)dependency, modulesIndex);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                d.setOrder(i2);
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            d.setOrder(i2);
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String msg = "Can't find the following module" + (orphanModules.size() > 1 ? "s" : "") + ": " + StringUtil.join(orphanModules, (String)", ") + "\nIt can be caused by composite build configuration inside your *.gradle scripts with Gradle version older than 3.3.\nTry Gradle 3.3 or better or enable 'Create separate module per source set' option";
            NotificationData notification2 = new NotificationData("Gradle project structure problems", msg, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification2);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        ArrayList<TaskData> tasks = new ArrayList<TaskData>();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        String rootProjectPath = ((ProjectData)ideProject.getData()).getLinkedExternalProjectPath();
        try {
            File rootDir = gradleModule.getGradleProject().getProjectIdentifier().getBuildIdentifier().getRootDir();
            rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)rootDir.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
        }
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (externalProject != null) {
            boolean isFlatProject = !FileUtil.isAncestor((String)rootProjectPath, (String)moduleConfigPath, (boolean)false);
            for (ExternalTask task2 : externalProject.getTasks().values()) {
                String taskName = isFlatProject ? task2.getQName() : task2.getName();
                String taskGroup = task2.getGroup();
                if (taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
                String taskPath = isFlatProject ? rootProjectPath : moduleConfigPath;
                String escapedTaskName = ParametersListUtil.escape((CharSequence)taskName);
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, escapedTaskName, taskPath, task2.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task2.getType());
                taskData.setTest(task2.isTest());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task2.getName(), (CharSequence)task2.getQName()));
                tasks.add(taskData);
            }
            return tasks;
        }
        for (GradleTask task3 : gradleModule.getGradleProject().getTasks()) {
            String taskName = task3.getName();
            String taskGroup = CommonGradleProjectResolverExtension.getTaskGroup(task3);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task3.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        return tasks;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task2) {
        String taskGroup;
        try {
            taskGroup = task2.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        return ContainerUtil.newLinkedHashSet((Object[])new Class[]{BuildScriptClasspathModel.class, GradleExtensions.class, ExternalTestsModel.class, IntelliJProjectSettings.class, IntelliJSettings.class});
    }

    @Override
    @NotNull
    public ProjectImportModelProvider getModelProvider() {
        return new ClassSetImportModelProvider(this.getExtraProjectModelClasses(), (Set)ContainerUtil.newLinkedHashSet((Object[])new Class[]{ExternalProject.class, IdeaProject.class}));
    }

    @Override
    public Set<Class<?>> getTargetTypes() {
        return ContainerUtil.newLinkedHashSet((Object[])new Class[]{ExternalProjectDependency.class, ExternalLibraryDependency.class, FileCollectionDependency.class, UnresolvedExternalDependency.class});
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters) {
        String dispatchPort = parameters.get("DEBUG_DISPATCH_PORT");
        if (dispatchPort == null) {
            return;
        }
        String debugOptions = parameters.get("DEBUG_OPTIONS");
        if (debugOptions == null) {
            debugOptions = "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        String esRtJarPath = FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(ExternalSystemSourceType.class));
        lines.add("initscript { dependencies { classpath files(\"" + esRtJarPath + "\") } }");
        for (DebuggerBackendExtension extension : DebuggerBackendExtension.EP_NAME.getExtensionList()) {
            lines.addAll(extension.initializationCode(dispatchPort, debugOptions));
        }
        String script = StringUtil.join(lines, (String)SystemProperties.getLineSeparator());
        initScriptConsumer.consume((Object)script);
    }

    private static void populateContentRoot(@NotNull PathPrefixTreeMap<ContentRootData> contentRootIndex, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                CommonGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                CommonGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            String path = FileUtil.toCanonicalPath((String)ideaSourceDirectory.getDirectory().getAbsolutePath());
            if (contentRootIndex.getAllAncestorKeys(path).isEmpty()) {
                ContentRootData contentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, path);
                contentRootIndex.set(path, (Object)contentRootData);
            }
            List ancestors = contentRootIndex.getAllAncestorKeys(path);
            String contentRootPath = (String)ancestors.get(ancestors.size() - 1);
            ContentRootData contentRoot = (ContentRootData)contentRootIndex.get(contentRootPath);
            assert (contentRoot != null);
            contentRoot.storePath(dirSourceType, path);
        }
    }

    private static void printToolingProxyDiagnosticInfo(@Nullable Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@NotNull ProjectResolverContext resolverContext, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull Map<String, ModuleData> registeredModulesIndex) throws IllegalStateException {
        ModuleData moduleData;
        ModuleData moduleData2;
        IdeaModule dependencyModule;
        GradleVersion projectGradleVersion;
        GradleExecutionSettings gradleExecutionSettings = resolverContext.getSettings();
        String projectGradleVersionString = resolverContext.getProjectGradleVersion();
        if (gradleExecutionSettings != null && projectGradleVersionString != null && (projectGradleVersion = GradleVersion.version((String)projectGradleVersionString)).compareTo(GradleVersion.version((String)"4.0")) < 0 && (dependencyModule = CommonGradleProjectResolverExtension.getDependencyModuleByReflection(dependency)) != null && (moduleData2 = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByModule(resolverContext, dependencyModule)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData2);
        }
        String moduleName = dependency.getTargetModuleName();
        if (gradleExecutionSettings != null && (moduleData = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByGradleModuleName(moduleName)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
        }
        ModuleData registeredModuleData = registeredModulesIndex.get(moduleName);
        if (registeredModuleData != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), registeredModuleData);
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModulesIndex.keySet()));
    }

    @Nullable
    private static IdeaModule getDependencyModuleByReflection(@NotNull IdeaModuleDependency dependency) {
        Method getDependencyModule = ReflectionUtil.getMethod(dependency.getClass(), (String)"getDependencyModule", (Class[])new Class[0]);
        if (getDependencyModule != null) {
            try {
                Object result = getDependencyModule.invoke((Object)dependency, new Object[0]);
                return (IdeaModule)result;
            }
            catch (IllegalAccessException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        String libraryName;
        LibraryLevel level;
        File binaryPath = dependency.getFile();
        if (binaryPath == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getName().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            if (binaryPath.isFile()) {
                boolean isModuleLocalLibrary = false;
                try {
                    isModuleLocalLibrary = FileUtil.isAncestor((File)gradleModule.getGradleProject().getProjectDirectory(), (File)binaryPath, (boolean)false);
                }
                catch (UnsupportedMethodException unsupportedMethodException) {
                    // empty catch block
                }
                level = isModuleLocalLibrary ? LibraryLevel.MODULE : LibraryLevel.PROJECT;
                libraryName = this.chooseName(binaryPath, level, ideProject);
            } else {
                level = LibraryLevel.MODULE;
                libraryName = "";
            }
            if (unresolved) {
                libraryName = binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                libraryName = StringUtil.join((Collection)StringUtil.split((String)libraryName, (String)" "), (String)":");
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtilRt.getNameWithoutExtension((String)binaryPath.getName());
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (!unresolved && StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getName(), (String)"jar")) {
            libraryName = libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getName());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (moduleVersion != null) {
            library.setGroup(moduleVersion.getGroup());
            library.setArtifactId(moduleVersion.getName());
            library.setVersion(moduleVersion.getVersion());
        }
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        } else {
            boolean isOfflineWork = this.resolverCtx.getSettings() != null && this.resolverCtx.getSettings().isOfflineWork();
            String message = String.format("Could not resolve %s.", libraryName);
            UnresolvedDependencySyncIssue buildIssue = new UnresolvedDependencySyncIssue(libraryName, message, this.resolverCtx.getProjectPath(), isOfflineWork);
            this.resolverCtx.report(MessageEvent.Kind.ERROR, buildIssue);
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
            if (this.resolverCtx instanceof DefaultProjectResolverContext) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(this.resolverCtx, ((DefaultProjectResolverContext)this.resolverCtx).getGradleUserHome(), library);
            }
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT && !GradleProjectResolverUtil.linkProjectLibrary(this.resolverCtx, ideProject, library)) {
            level = LibraryLevel.MODULE;
        }
        return new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
    }

    private String chooseName(File path, LibraryLevel level, DataNode<ProjectData> ideProject) {
        String candidateName;
        DataNode libraryData;
        String fileName = FileUtilRt.getNameWithoutExtension((String)path.getName());
        if (level == LibraryLevel.MODULE) {
            return fileName;
        }
        int count = 0;
        while ((libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, arg_0 -> CommonGradleProjectResolverExtension.lambda$chooseName$10(candidateName = fileName + (count == 0 ? "" : "_" + count), arg_0))) != null) {
            if (((LibraryData)libraryData.getData()).getPaths(LibraryPathType.BINARY).contains(FileUtil.toSystemIndependentName((String)path.getAbsolutePath()))) {
                return candidateName;
            }
            ++count;
        }
        return candidateName;
    }

    private static /* synthetic */ boolean lambda$chooseName$10(String candidateName, DataNode node) {
        return ((LibraryData)node.getData()).getExternalName().equals(candidateName);
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

