/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.util.regex.Matcher;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

public abstract class AbstractProjectImportErrorHandler {
    public static final String OPEN_GRADLE_SETTINGS = "Please fix the project's Gradle settings.";
    public static final String SET_UP_HTTP_PROXY = "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
    public static final String UNEXPECTED_ERROR_FILE_BUG = "This is an unexpected error. Please file a bug containing the idea.log file.";
    public static final String FIX_GRADLE_VERSION = "Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
    public static final String EMPTY_LINE = "\n\n";

    @Nullable
    public abstract ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment var1, @NotNull Throwable var2, @NotNull String var3, @Nullable String var4);

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        return GradleExecutionErrorHandler.createUserFriendlyError(msg, location, quickFixes);
    }

    @NotNull
    public String parseMissingMethod(@NotNull String rootCauseText) {
        Matcher matcher = GradleExecutionErrorHandler.MISSING_METHOD_PATTERN.matcher(rootCauseText);
        return matcher.find() ? matcher.group(1) : "";
    }
}

