/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings2, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener2) {
        ModelBuilder result = connection.model(modelType);
        if (settings2 != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings2, listener2, connection);
        }
        return result;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        BuildLauncher result = connection.newBuild();
        if (settings2 != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings2, listener2, connection);
        }
        return result;
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        return this.execute(projectPath, settings2, null, null, null, f);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        File projectPathFile = new File(projectPath);
        if (projectPathFile.isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings2 != null && !(arguments = settings2.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings2.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return (T)GradleConnectorService.withGradleConnection(projectDir, taskId, settings2, listener2, cancellationToken, connection -> {
            String userDir = null;
            if (!GradleEnvironment.ADJUST_USER_DIR) {
                try {
                    userDir = System.getProperty("user.dir");
                    if (userDir != null) {
                        System.setProperty("user.dir", projectDir);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Object object = f.fun(connection);
                return object;
            }
            catch (ExternalSystemException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
            finally {
                if (userDir != null) {
                    System.setProperty("user.dir", userDir);
                }
            }
        });
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        this.ensureInstalledWrapper(id, projectPath, settings2, null, listener2, cancellationToken);
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (!settings2.getDistributionType().isWrapped()) {
            return;
        }
        if (settings2.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        GradleConnectorService.withGradleConnection(projectPath, id, settings2, listener2, cancellationToken, connection -> {
            long ttlInMs = settings2.getRemoteProcessIdleTtlInMs();
            try {
                settings2.setRemoteProcessIdleTtlInMs(100L);
                try {
                    File wrapperFilesLocation = FileUtil.createTempDirectory((String)"wrap", (String)"loc");
                    String fileName = "gradle-wrapper";
                    File jarFile = new File(wrapperFilesLocation, "gradle-wrapper.jar");
                    File scriptFile = new File(wrapperFilesLocation, "gradlew");
                    File pathToProperties = new File(wrapperFilesLocation, "path.tmp");
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)wrapperFilesLocation), "GradleExecutionHelper cleanup"));
                    StringJoiner lines = new StringJoiner(SystemProperties.getLineSeparator());
                    lines.add("");
                    lines.add("gradle.projectsEvaluated { gr ->");
                    lines.add("  def wrapper = gr.rootProject.tasks[\"wrapper\"]");
                    lines.add("  if (wrapper != null) {");
                    lines.add("    if (wrapper.jarFile.exists()) {");
                    lines.add("      wrapper.jarFile = new File('" + StringUtil.escapeBackSlashes((String)jarFile.getCanonicalPath()) + "')");
                    lines.add("      wrapper.scriptFile = new File('" + StringUtil.escapeBackSlashes((String)scriptFile.getCanonicalPath()) + "')");
                    lines.add("    }");
                    if (gradleVersion != null) {
                        lines.add("    wrapper.gradleVersion = '" + gradleVersion.getVersion() + "'");
                    }
                    lines.add("    wrapper.doLast {");
                    lines.add("      new File('" + StringUtil.escapeBackSlashes((String)pathToProperties.getCanonicalPath()) + "').write wrapper.propertiesFile.getCanonicalPath()");
                    lines.add("    }");
                    lines.add("  }");
                    lines.add("}");
                    lines.add("");
                    File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(lines.toString(), "wrapper_init");
                    settings2.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
                    BuildLauncher launcher = this.getBuildLauncher(id, (ProjectConnection)connection, settings2, listener2);
                    launcher.withCancellationToken(cancellationToken);
                    launcher.forTasks(new String[]{"wrapper"});
                    launcher.run();
                    settings2.setWrapperPropertyFile(FileUtil.loadFile((File)pathToProperties));
                }
                catch (IOException e) {
                    LOG.warn("Can't update wrapper", (Throwable)e);
                }
            }
            catch (Throwable e) {
                LOG.warn("Can't update wrapper", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause));
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
            finally {
                settings2.setRemoteProcessIdleTtlInMs(ttlInMs);
            }
            return null;
        });
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(ProjectResolverContext projectResolverContext) {
        return GradleExecutionHelper.getBuildEnvironment(projectResolverContext.getConnection(), projectResolverContext.getExternalSystemTaskId(), projectResolverContext.getListener(), projectResolverContext.getCancellationTokenSource());
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection) {
        GradleExecutionHelper.prepare(operation, id, settings2, listener2, connection, (OutputStream)new OutputWrapper(listener2, id, true), (OutputStream)new OutputWrapper(listener2, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError) {
        BuildIdentifier buildIdentifier;
        Application application;
        ArrayList<String> filteredArgs;
        String gradleVersion;
        List<String> jvmArgs = settings2.getJvmArguments();
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, (CancellationToken)null);
        String string = gradleVersion = buildEnvironment != null ? buildEnvironment.getGradle().getGradleVersion() : null;
        if (!jvmArgs.isEmpty()) {
            List<String> merged;
            if (buildEnvironment != null) {
                BuildIdentifier buildIdentifier2 = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
                List buildJvmArguments = buildIdentifier2 == null || "buildSrc".equals(buildIdentifier2.getRootDir().getName()) ? ContainerUtil.emptyList() : buildEnvironment.getJava().getJvmArguments();
                merged = GradleExecutionHelper.mergeJvmArgs(settings2.getServiceDirectory(), buildJvmArguments, jvmArgs);
            } else {
                merged = jvmArgs;
            }
            filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation.setJvmArguments(ArrayUtilRt.toStringArray((Collection)filteredArgs));
        }
        if (settings2.isOfflineWork()) {
            settings2.withArgument("--offline");
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode() && !settings2.getArguments().contains("--quiet") && !settings2.getArguments().contains("--debug")) {
            settings2.withArgument("--info");
        }
        filteredArgs = new ArrayList<String>();
        if (!settings2.getArguments().isEmpty()) {
            String loggableArgs = StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(settings2.getArguments()), (String)" ");
            LOG.info("Passing command-line args to Gradle Tooling API: " + loggableArgs);
            filteredArgs.addAll(ContainerUtil.mapNotNull((Collection)settings2.getArguments(), s -> StringUtil.isEmpty((String)s) ? null : s));
            GradleExecutionHelper.replaceTestCommandOptionWithInitScript(filteredArgs);
        }
        filteredArgs.add("-Didea.active=true");
        filteredArgs.add("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        operation.withArguments(ArrayUtilRt.toStringArray(filteredArgs));
        GradleExecutionHelper.setupEnvironment(operation, settings2, gradleVersion, id, listener2);
        String javaHome = settings2.getJavaHome();
        if (javaHome != null && new File(javaHome).isDirectory()) {
            operation.setJavaHome(new File(javaHome));
        }
        String buildRootDir = buildEnvironment == null ? null : ((buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment)) == null ? null : buildIdentifier.getRootDir().getPath());
        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
        operation.addProgressListener((ProgressListener)gradleProgressListener, new OperationType[]{OperationType.TASK, OperationType.TEST});
        operation.setStandardOutput(standardOutput);
        operation.setStandardError(standardError);
        InputStream inputStream = (InputStream)settings2.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    @Nullable
    private static BuildIdentifier getBuildIdentifier(@NotNull BuildEnvironment buildEnvironment) {
        try {
            return buildEnvironment.getBuildIdentifier();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return null;
        }
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2, @Nullable String gradleVersion, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
        boolean isEnvironmentCustomizationSupported;
        boolean bl = isEnvironmentCustomizationSupported = gradleVersion != null && GradleVersion.version((String)gradleVersion).getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0;
        if (!isEnvironmentCustomizationSupported) {
            if (!settings2.isPassParentEnvs() || !settings2.getEnv().isEmpty()) {
                listener2.onTaskOutput(taskId, String.format("The version of Gradle you are using%s does not support the environment variables customization feature. Support for this is available in Gradle 3.5 and all later versions.\n", gradleVersion == null ? "" : " (" + gradleVersion + ")"), false);
            }
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings2.getEnv());
        commandLine.withParentEnvironmentType(settings2.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    @ApiStatus.Experimental
    static List<String> mergeJvmArgs(String serviceDirectory, List<String> jvmArgs, List<String> jvmArgsFromIdeSettings) {
        File gradleUserHomeDir = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        LOG.debug("Gradle home: " + gradleUserHomeDir);
        NativeServices.initialize((File)gradleUserHomeDir);
        JvmOptions jvmOptions = new JvmOptions(null);
        List<String> mergedJvmArgs = GradleExecutionHelper.mergeJvmArgs(jvmArgs, jvmArgsFromIdeSettings);
        jvmOptions.setAllJvmArgs(mergedJvmArgs);
        return jvmOptions.getAllJvmArgs();
    }

    @ApiStatus.Experimental
    static List<String> mergeJvmArgs(List<String> jvmArgs, List<String> jvmArgsFromIdeSettings) {
        MultiMap argumentsMap = MultiMap.createLinkedSet();
        String lastKey = null;
        for (String jvmArg : ContainerUtil.concat(jvmArgs, jvmArgsFromIdeSettings)) {
            if (jvmArg.startsWith("-")) {
                argumentsMap.putValue((Object)jvmArg, (Object)"");
                lastKey = jvmArg;
                continue;
            }
            if (lastKey != null) {
                argumentsMap.putValue((Object)lastKey, (Object)jvmArg);
                lastKey = null;
                continue;
            }
            argumentsMap.putValue((Object)jvmArg, (Object)"");
        }
        LinkedHashMap<Object, Object> mergedKeys = new LinkedHashMap<Object, Object>();
        LinkedHashSet argKeySet = new LinkedHashSet(argumentsMap.keySet());
        for (String argKey : argKeySet) {
            Collection values = argumentsMap.getModifiable((Object)argKey);
            if (values.size() == 1 && ((String)values.iterator().next()).isEmpty()) {
                Couple<String> couple = GradleExecutionHelper.splitArg(argKey);
                mergedKeys.put(couple.first, couple.second);
                continue;
            }
            mergedKeys.put(argKey, "");
            LinkedHashMap<Object, Object> mergedArgs = new LinkedHashMap<Object, Object>();
            for (String jvmArg : values) {
                if (jvmArg.isEmpty()) continue;
                Couple<String> couple = GradleExecutionHelper.splitArg(jvmArg);
                mergedArgs.put(couple.first, couple.second);
            }
            values.clear();
            mergedArgs.forEach((key, value) -> values.add(key + value));
        }
        SmartList mergedArgs = new SmartList();
        mergedKeys.forEach((arg_0, arg_1) -> GradleExecutionHelper.lambda$mergeJvmArgs$6((List)mergedArgs, arg_0, arg_1));
        argKeySet.stream().filter(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$7((List)mergedArgs, arg_0)).forEach(arg_0 -> ((MultiMap)argumentsMap).remove(arg_0));
        argumentsMap.remove((Object)"--add-opens");
        SmartList result = new SmartList();
        argumentsMap.keySet().forEach(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$9(argumentsMap, (List)result, arg_0));
        return result;
    }

    private static Couple<String> splitArg(String arg) {
        int i2 = arg.indexOf(61);
        return i2 <= 0 ? Couple.of((Object)arg, (Object)"") : Couple.of((Object)arg.substring(0, i2), (Object)arg.substring(i2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File generateInitScript(boolean isBuildSrcProject, @NotNull Set<Class<?>> toolingExtensionClasses) {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/init.gradle");
        try {
            if (stream == null) {
                LOG.warn("Can't get init script template");
                File file = null;
                return file;
            }
            String toolingExtensionsJarPaths = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${EXTENSIONS_JARS_PATH}"), toolingExtensionsJarPaths);
            if (isBuildSrcProject) {
                String buildSrcDefaultInitScript = GradleExecutionHelper.getBuildSrcDefaultInitScript();
                if (buildSrcDefaultInitScript == null) {
                    File file = null;
                    return file;
                }
                script = script + buildSrcDefaultInitScript;
            }
            File file = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijinit");
            return file;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static File writeToFileGradleInitScript(@NotNull String content, @NotNull String filePrefix) throws IOException {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        int contentLength = contentBytes.length;
        return FileUtil.findSequentFile((File)new File(FileUtil.getTempDirectory()), (String)filePrefix, (String)"gradle", file -> {
            try {
                if (!file.exists()) {
                    FileUtil.writeToFile((File)file, (byte[])contentBytes, (boolean)false);
                    file.deleteOnExit();
                    return true;
                }
                if ((long)contentLength != file.length()) {
                    return false;
                }
                return content.equals(FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                return false;
            }
        });
    }

    @Nullable
    public static String getBuildSrcDefaultInitScript() {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/buildSrcInit.gradle");
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            String string = FileUtil.loadTextAndClose((InputStream)stream);
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't use IJ gradle init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource) {
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationTokenSource);
        GradleVersion gradleVersion = null;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource) {
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationToken);
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken) {
        BuildEnvironment buildEnvironment = null;
        try {
            ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
            if (cancellationToken != null) {
                modelBuilder.withCancellationToken(cancellationToken);
            }
            GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId);
            modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
            modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
            modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
            modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
            buildEnvironment = (BuildEnvironment)modelBuilder.get();
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Gradle version: " + buildEnvironment.getGradle().getGradleVersion());
                    LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                    LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
                }
                catch (Throwable t) {
                    LOG.debug(t);
                }
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
        return buildEnvironment;
    }

    private static void replaceTestCommandOptionWithInitScript(@NotNull List<String> args) {
        LinkedHashSet<String> testIncludePatterns = new LinkedHashSet<String>();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!"--tests".equals(next)) continue;
            it.remove();
            if (!it.hasNext()) continue;
            testIncludePatterns.add(it.next());
            it.remove();
        }
        if (!testIncludePatterns.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            Iterator iterator = testIncludePatterns.iterator();
            while (iterator.hasNext()) {
                String pattern = (String)iterator.next();
                String groovyPattern = GradleExecutionHelper.toGroovyString(pattern);
                buf.append('\'').append(groovyPattern).append('\'');
                if (!iterator.hasNext()) continue;
                buf.append(',');
            }
            buf.append(']');
            String path = GradleExecutionHelper.renderInitScript(buf.toString());
            if (path != null) {
                ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", path});
            }
        }
    }

    @NotNull
    public static String toGroovyString(@NotNull String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char ch : string.toCharArray()) {
            if (ch == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String renderInitScript(@NotNull String testArgs) {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/testFilterInit.gradle");
        try {
            if (stream == null) {
                LOG.error("Can't get test filter init script template");
                String string = null;
                return string;
            }
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${TEST_NAME_INCLUDES}"), Matcher.quoteReplacement(testArgs));
            File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijtestinit");
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle test filter init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @NotNull
    public static String getToolingExtensionsJarPaths(@NotNull Set<Class<?>> toolingExtensionClasses) {
        Set jarPaths = ContainerUtil.map2SetNotNull(toolingExtensionClasses, aClass -> {
            String path = PathManager.getJarPathForClass((Class)aClass);
            if (path != null) {
                if (FileUtilRt.getNameWithoutExtension((String)path).equals("gradle-api-" + GradleVersion.current().getBaseVersion())) {
                    LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
                    return null;
                }
                return FileUtil.toCanonicalPath((String)path);
            }
            return null;
        });
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = jarPaths.iterator();
        while (it.hasNext()) {
            String jarPath = (String)it.next();
            buf.append('\"').append(jarPath).append('\"');
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    @NotNull
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        return replaced;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$9(MultiMap argumentsMap, List result, String key) {
        argumentsMap.get((Object)key).forEach(val -> {
            result.add(key);
            if (StringUtil.isNotEmpty((String)val)) {
                result.add(val);
            }
        });
    }

    private static /* synthetic */ boolean lambda$mergeJvmArgs$7(List mergedArgs, String argKey) {
        return !mergedArgs.contains(argKey);
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$6(List mergedArgs, String s1, String s2) {
        mergedArgs.add(s1 + s2);
    }
}

