/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleInstallationManager {
    public static final Pattern GRADLE_JAR_FILE_PATTERN;
    public static final Pattern ANY_GRADLE_JAR_FILE_PATTERN;
    public static final Pattern ANT_JAR_PATTERN;
    public static final Pattern IVY_JAR_PATTERN;
    private static final String[] GRADLE_START_FILE_NAMES;
    @NonNls
    private static final String GRADLE_ENV_PROPERTY_NAME;
    private static final Path BREW_GRADLE_LOCATION;
    private static final String LIBEXEC = "libexec";
    @Nullable
    private Ref<File> myCachedGradleHomeFromPath;

    public static GradleInstallationManager getInstance() {
        return (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
    }

    @Nullable
    public Collection<File> getAllLibraries(@Nullable File gradleHome) {
        File plugins;
        if (gradleHome == null || !gradleHome.isDirectory()) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        File libs = new File(gradleHome, "lib");
        File[] files = libs.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file);
            }
        }
        if ((files = (plugins = new File(libs, "plugins")).listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file);
            }
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    public File getGradleHome(@Nullable Project project, @NotNull String linkedProjectPath) {
        return this.doGetGradleHome(project, linkedProjectPath);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    public Sdk getGradleJdk(@Nullable Project project, @NotNull String linkedProjectPath) {
        if (project == null) {
            return null;
        }
        String homePath = this.getGradleJvmPath(project, linkedProjectPath);
        if (homePath == null) {
            return null;
        }
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        return jdkProvider.createJdk(null, homePath);
    }

    @Nullable
    public String getGradleJvmPath(@NotNull Project project, @NotNull String linkedProjectPath) {
        GradleProjectSettings settings2 = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedProjectPath);
        if (settings2 == null) {
            return this.getAvailableJavaHome(project);
        }
        String gradleJvm = settings2.getGradleJvm();
        SdkLookupProvider sdkLookupProvider = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, settings2);
        SdkLookupProvider.SdkInfo sdkInfo2 = GradleJvmUtil.nonblockingResolveGradleJvmInfo(sdkLookupProvider, project, linkedProjectPath, gradleJvm);
        if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved) {
            return ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath();
        }
        return null;
    }

    @Nullable
    private String getAvailableJavaHome(@NotNull Project project) {
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)project);
        if (ExternalSystemJdkUtil.isValidJdk((Sdk)((Sdk)sdkPair.second))) {
            return ((Sdk)sdkPair.second).getHomePath();
        }
        return null;
    }

    @Nullable
    private File doGetGradleHome(@Nullable Project project, @NotNull String linkedProjectPath) {
        if (project == null) {
            return null;
        }
        GradleProjectSettings settings2 = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedProjectPath);
        if (settings2 == null || settings2.getDistributionType() == null) {
            return null;
        }
        String gradleHome = settings2.getDistributionType() == DistributionType.WRAPPED ? GradleLocalSettings.getInstance(project).getGradleHome(linkedProjectPath) : settings2.getGradleHome();
        return this.getGradleHome(settings2.getDistributionType(), linkedProjectPath, gradleHome);
    }

    @Nullable
    private File getGradleHome(@NotNull DistributionType distributionType, @NotNull String linkedProjectPath, @Nullable String gradleHome) {
        File candidate = null;
        switch (distributionType) {
            case LOCAL: 
            case WRAPPED: {
                if (gradleHome == null) break;
                candidate = new File(gradleHome);
                break;
            }
            case DEFAULT_WRAPPED: {
                WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration(linkedProjectPath);
                candidate = this.getWrappedGradleHome(linkedProjectPath, wrapperConfiguration);
                break;
            }
            case BUNDLED: {
                WrapperConfiguration bundledWrapperSettings = new WrapperConfiguration();
                DistributionLocator distributionLocator = new DistributionLocator();
                bundledWrapperSettings.setDistribution(distributionLocator.getDistributionFor(GradleVersion.current()));
                candidate = this.getWrappedGradleHome(linkedProjectPath, bundledWrapperSettings);
            }
        }
        File result = null;
        if (candidate != null) {
            File file = result = this.isGradleSdkHome(candidate) ? candidate : null;
        }
        if (result != null) {
            return result;
        }
        return this.getAutodetectedGradleHome();
    }

    @Nullable
    public File getAutodetectedGradleHome() {
        File result = this.getGradleHomeFromPath();
        if (result != null) {
            return result;
        }
        result = this.getGradleHomeFromEnvProperty();
        if (result != null) {
            return result;
        }
        if (SystemInfo.isMac) {
            return this.getGradleHomeFromBrew();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private File getGradleHomeFromBrew() {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(BREW_GRADLE_LOCATION);){
            Path bestPath = null;
            Version highestVersion = null;
            for (Path path : ds) {
                String fileName = path.getFileName().toString();
                try {
                    Version version = Version.parseVersion((String)fileName);
                    if (version == null || highestVersion != null && version.compareTo(highestVersion) <= 0) continue;
                    highestVersion = version;
                    bestPath = path;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (bestPath == null) return null;
            Path libexecPath = bestPath.resolve(LIBEXEC);
            if (!Files.exists(libexecPath, new LinkOption[0])) return null;
            File file = libexecPath.toFile();
            return file;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String suggestBetterGradleHomePath(@NotNull String homePath) {
        Path libexecPath;
        File libexecFile;
        Path path = Paths.get(homePath, new String[0]);
        if (path.startsWith(BREW_GRADLE_LOCATION) && this.isGradleSdkHome(libexecFile = (libexecPath = path.resolve(LIBEXEC)).toFile())) {
            return libexecPath.toString();
        }
        return null;
    }

    @Nullable
    public VirtualFile getGradleHome(@Nullable Module module) {
        VirtualFile[] roots;
        if (module == null) {
            return null;
        }
        for (VirtualFile root : roots = OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
            if (root == null || !this.isGradleSdkHome(root)) continue;
            return root;
        }
        return null;
    }

    @Nullable
    public VirtualFile getGradleHome(@Nullable Module module, @Nullable Project project, @NotNull String linkedProjectPath) {
        VirtualFile result = this.getGradleHome(module);
        if (result != null) {
            return result;
        }
        File home = this.getGradleHome(project, linkedProjectPath);
        return home == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(home);
    }

    @Nullable
    public File getGradleHomeFromPath() {
        Ref<File> ref = this.myCachedGradleHomeFromPath;
        if (ref != null) {
            return (File)ref.get();
        }
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        for (String pathEntry : path.split(File.pathSeparator)) {
            File dir = new File(pathEntry);
            if (!dir.isDirectory()) continue;
            for (String fileName : GRADLE_START_FILE_NAMES) {
                File candidate;
                File startFile = new File(dir, fileName);
                if (!startFile.isFile() || !this.isGradleSdkHome(candidate = dir.getParentFile())) continue;
                this.myCachedGradleHomeFromPath = new Ref((Object)candidate);
                return candidate;
            }
        }
        return null;
    }

    @Nullable
    public File getGradleHomeFromEnvProperty() {
        String path = System.getenv(GRADLE_ENV_PROPERTY_NAME);
        if (path == null) {
            return null;
        }
        File candidate = new File(path);
        return this.isGradleSdkHome(candidate) ? candidate : null;
    }

    public boolean isGradleSdkHome(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.isGradleSdkHome(new File(file.getPath()));
    }

    public boolean isGradleSdkHome(@Nullable File file) {
        if (file == null) {
            return false;
        }
        File libs = new File(file, "lib");
        if (!libs.isDirectory()) {
            if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
                GradleLog.LOG.info(String.format("Gradle sdk check failed for the path '%s'. Reason: it doesn't have a child directory named 'lib'", file.getAbsolutePath()));
            }
            return false;
        }
        boolean found = this.isGradleSdk(libs.listFiles());
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            GradleLog.LOG.info(String.format("Gradle home check %s for the path '%s'", found ? "passed" : "failed", file.getAbsolutePath()));
        }
        return found;
    }

    public boolean isGradleSdkHome(String gradleHomePath) {
        return this.isGradleSdkHome(new File(gradleHomePath));
    }

    public boolean isGradleSdk(VirtualFile ... files) {
        if (files == null) {
            return false;
        }
        File[] arg = new File[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            arg[i2] = new File(files[i2].getPath());
        }
        return this.isGradleSdk(arg);
    }

    private boolean isGradleSdk(File ... files) {
        return this.findGradleJar(files) != null;
    }

    @Nullable
    private File findGradleJar(File ... files) {
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!GRADLE_JAR_FILE_PATTERN.matcher(file.getName()).matches()) continue;
            return file;
        }
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            StringBuilder filesInfo = new StringBuilder();
            for (File file : files) {
                filesInfo.append(file.getAbsolutePath()).append(';');
            }
            if (filesInfo.length() > 0) {
                filesInfo.setLength(filesInfo.length() - 1);
            }
            GradleLog.LOG.info(String.format("Gradle sdk check fails. Reason: no one of the given files matches gradle JAR pattern (%s). Files: %s", GRADLE_JAR_FILE_PATTERN.toString(), filesInfo));
        }
        return null;
    }

    @Nullable
    public List<VirtualFile> getClassRoots(@Nullable Project project) {
        List<File> files = this.getClassRoots(project, null);
        if (files == null) {
            return null;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        return ContainerUtil.mapNotNull(files, file -> {
            VirtualFile virtualFile = localFileSystem.refreshAndFindFileByIoFile(file);
            return virtualFile != null ? jarFileSystem.getJarRootForLocalFile(virtualFile) : null;
        });
    }

    @Nullable
    public List<File> getClassRoots(@Nullable Project project, @Nullable String rootProjectPath) {
        if (project == null) {
            return null;
        }
        if (rootProjectPath == null) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                rootProjectPath = ExternalSystemModulePropertyManager.getInstance((Module)module).getRootProjectPath();
                List<File> result = this.findGradleSdkClasspath(project, rootProjectPath);
                if (result.isEmpty()) continue;
                return result;
            }
        } else {
            return this.findGradleSdkClasspath(project, rootProjectPath);
        }
        return null;
    }

    @Nullable
    public static String getGradleVersion(@Nullable String gradleHome) {
        if (gradleHome == null) {
            return null;
        }
        File libs = new File(gradleHome, "lib");
        if (!libs.isDirectory()) {
            return null;
        }
        File[] files = libs.listFiles();
        if (files != null) {
            for (File file : files) {
                Matcher matcher = GRADLE_JAR_FILE_PATTERN.matcher(file.getName());
                if (!matcher.matches()) continue;
                return matcher.group(2);
            }
        }
        return null;
    }

    private List<File> findGradleSdkClasspath(Project project, String rootProjectPath) {
        Collection<File> libraries;
        ArrayList<File> result = new ArrayList<File>();
        if (StringUtil.isEmpty((String)rootProjectPath)) {
            return result;
        }
        File gradleHome = this.getGradleHome(project, rootProjectPath);
        if (gradleHome == null || !gradleHome.isDirectory()) {
            return result;
        }
        File src = new File(gradleHome, "src");
        if (src.isDirectory()) {
            if (new File(src, "org").isDirectory()) {
                this.addRoots(result, src);
            } else {
                this.addRoots(result, src.listFiles());
            }
        }
        if ((libraries = this.getAllLibraries(gradleHome)) == null) {
            return result;
        }
        for (File file : libraries) {
            if (!this.isGradleBuildClasspathLibrary(file)) continue;
            ContainerUtil.addIfNotNull(result, (Object)file);
        }
        return result;
    }

    private boolean isGradleBuildClasspathLibrary(File file) {
        String fileName = file.getName();
        return ANY_GRADLE_JAR_FILE_PATTERN.matcher(fileName).matches() || ANT_JAR_PATTERN.matcher(fileName).matches() || IVY_JAR_PATTERN.matcher(fileName).matches() || GradleInstallationManager.isGroovyJar(fileName);
    }

    private void addRoots(@NotNull List<? super File> result, File ... files) {
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null || !file.isDirectory()) continue;
            result.add(file);
        }
    }

    private File getWrappedGradleHome(String linkedProjectPath, @Nullable WrapperConfiguration wrapperConfiguration) {
        if (wrapperConfiguration == null) {
            return null;
        }
        File gradleSystemDir = "PROJECT".equals(wrapperConfiguration.getDistributionBase()) ? new File(linkedProjectPath, ".gradle") : StartParameter.DEFAULT_GRADLE_USER_HOME;
        if (!gradleSystemDir.isDirectory()) {
            return null;
        }
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(gradleSystemDir).getDistribution(wrapperConfiguration);
        if (localDistribution.getDistributionDir() == null) {
            return null;
        }
        File[] distFiles = localDistribution.getDistributionDir().listFiles(f -> f.isDirectory() && StringUtil.startsWith((CharSequence)f.getName(), (CharSequence)"gradle-"));
        return distFiles == null || distFiles.length == 0 ? null : distFiles[0];
    }

    private static boolean isGroovyJar(@NotNull String name) {
        return (name = StringUtil.toLowerCase((String)name)).startsWith("groovy-all-") && name.endsWith(".jar") && !name.contains("src") && !name.contains("doc");
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull GradleProjectSettings settings2) {
        GradleVersion version = null;
        DistributionType distributionType = settings2.getDistributionType();
        if (distributionType == null) {
            return null;
        }
        if (distributionType == DistributionType.LOCAL) {
            String gradleVersion = GradleInstallationManager.getGradleVersion(settings2.getGradleHome());
            if (gradleVersion != null) {
                version = GradleInstallationManager.getGradleVersionSafe(gradleVersion);
            }
        } else {
            if (distributionType == DistributionType.BUNDLED) {
                return GradleVersion.current();
            }
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                String path;
                URI uri;
                String gradleVersion;
                WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration(settings2.getExternalProjectPath());
                GradleInstallationManager installationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
                File gradleHome = installationManager.getWrappedGradleHome(settings2.getExternalProjectPath(), wrapperConfiguration);
                if (gradleHome != null && (gradleVersion = GradleInstallationManager.getGradleVersion(gradleHome.getPath())) != null) {
                    version = GradleInstallationManager.getGradleVersionSafe(gradleVersion);
                }
                if (version == null && wrapperConfiguration != null && (uri = wrapperConfiguration.getDistribution()) != null && (path = uri.getRawPath()) != null) {
                    version = GradleInstallationManager.parseDistributionVersion(path);
                }
            }
        }
        return version;
    }

    @Nullable
    public static GradleVersion parseDistributionVersion(@NotNull String path) {
        if ((path = StringUtil.substringAfterLast((String)path, (String)"/")) == null) {
            return null;
        }
        if ((path = StringUtil.substringAfterLast((String)path, (String)"gradle-")) == null) {
            return null;
        }
        int i2 = path.lastIndexOf(45);
        if (i2 <= 0) {
            return null;
        }
        return GradleInstallationManager.getGradleVersionSafe(path.substring(0, i2));
    }

    @Nullable
    private static GradleVersion getGradleVersionSafe(String gradleVersion) {
        try {
            return GradleVersion.version((String)gradleVersion);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        ANT_JAR_PATTERN = Pattern.compile("ant(-(.*))?\\.jar");
        IVY_JAR_PATTERN = Pattern.compile("ivy(-(.*))?\\.jar");
        BREW_GRADLE_LOCATION = Paths.get("/usr/local/Cellar/gradle/", new String[0]);
        GRADLE_JAR_FILE_PATTERN = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(core-)?(\\d.*)\\.jar"));
        ANY_GRADLE_JAR_FILE_PATTERN = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(.*)\\.jar"));
        GRADLE_START_FILE_NAMES = System.getProperty("gradle.start.file.names", "gradle:gradle.cmd:gradle.sh").split(":");
        GRADLE_ENV_PROPERTY_NAME = System.getProperty("gradle.home.env.key", "GRADLE_HOME");
    }
}

