/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;

public class WebResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final WarDirectory warDirectory;
    @NotNull
    private final String warRelativePath;
    @NotNull
    private final File file;

    @PropertyMapping(value={"warDirectory", "warRelativePath", "file"})
    public WebResource(@NotNull WarDirectory warDirectory, @NotNull String warRelativePath, @NotNull File file) {
        this.warDirectory = warDirectory;
        this.warRelativePath = WebResource.getAdjustedPath(warRelativePath);
        this.file = file;
    }

    @NotNull
    public WarDirectory getWarDirectory() {
        return this.warDirectory;
    }

    @NotNull
    public String getWarRelativePath() {
        return this.warRelativePath;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebResource)) {
            return false;
        }
        WebResource resource = (WebResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.warDirectory != resource.warDirectory) {
            return false;
        }
        return this.warRelativePath.equals(resource.warRelativePath);
    }

    public int hashCode() {
        int result = this.warDirectory.hashCode();
        result = 31 * result + this.warRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "WebResource{myWarDirectory=" + this.warDirectory + ", warRelativePath='" + this.warRelativePath + '\'' + ", file=" + this.file + '}';
    }
}

