/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.model.data.WebResource;

public class War
extends Jar {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String webAppDirName;
    @NotNull
    private final File webAppDir;
    @Nullable
    private File webXml;
    @NotNull
    private List<WebResource> webResources;
    @NotNull
    private Set<File> classpath;

    @PropertyMapping(value={"name", "webAppDirName", "webAppDir"})
    public War(@NotNull String name, @NotNull String webAppDirName, @NotNull File webAppDir) {
        super(name);
        this.webAppDirName = webAppDirName;
        this.webAppDir = webAppDir;
        this.webResources = Collections.emptyList();
        this.classpath = Collections.emptySet();
    }

    @NotNull
    public String getWebAppDirName() {
        return this.webAppDirName;
    }

    @NotNull
    public File getWebAppDir() {
        return this.webAppDir;
    }

    public void setWebXml(@Nullable File webXml) {
        this.webXml = webXml;
    }

    @Nullable
    public File getWebXml() {
        return this.webXml;
    }

    public void setWebResources(@Nullable List<WebResource> webResources) {
        this.webResources = webResources == null ? Collections.emptyList() : webResources;
    }

    @NotNull
    public List<WebResource> getWebResources() {
        return this.webResources;
    }

    public void setClasspath(@Nullable Set<File> classpath) {
        this.classpath = classpath == null ? Collections.emptySet() : classpath;
    }

    @NotNull
    public Set<File> getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof War)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        War war = (War)o;
        if (!this.webAppDirName.equals(war.webAppDirName)) {
            return false;
        }
        if (!this.webResources.equals(war.webResources)) {
            return false;
        }
        return this.classpath.equals(war.classpath);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.webAppDirName.hashCode();
        result = 31 * result + this.webResources.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "War{name='" + this.getName() + '\'' + ", webAppDirName='" + this.webAppDirName + '\'' + ", webAppDir=" + this.webAppDir + ", webXml=" + this.webXml + ", webResources=" + this.webResources + '}';
    }
}

