/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class UnsupportedGradleVersionIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        GradleVersion gradleVersion;
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String rootCauseText = rootCause.toString();
        GradleVersion gradleVersionUsed = null;
        if (issueData.getBuildEnvironment() != null) {
            gradleVersionUsed = GradleVersion.version((String)issueData.getBuildEnvironment().getGradle().getGradleVersion());
        }
        if (!StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.tooling.UnsupportedVersionException: ", (boolean)false, (int)2, null)) {
            return null;
        }
        String errorMessagePrefix = "org.gradle.tooling.UnsupportedVersionException: Support for builds using Gradle versions older than ";
        boolean isVeryOldGradleVersion = StringsKt.endsWith$default((String)rootCauseText, (String)"does not support the ModelBuilder API. Support for this is available in Gradle 1.2 and all later versions.", (boolean)false, (int)2, null);
        if (!StringsKt.startsWith$default((String)rootCauseText, (String)errorMessagePrefix, (boolean)false, (int)2, null) && !isVeryOldGradleVersion) {
            return null;
        }
        String minRequiredVersionCandidate = null;
        minRequiredVersionCandidate = isVeryOldGradleVersion ? "2.6" : StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)rootCauseText, (String)errorMessagePrefix, null, (int)2, null), (String)" ", (String)"");
        try {
            gradleVersion = GradleVersion.version((String)minRequiredVersionCandidate);
        }
        catch (IllegalArgumentException e) {
            gradleVersion = GradleVersion.current();
        }
        GradleVersion gradleMinimumVersionRequired = gradleVersion;
        List quickFixes = null;
        quickFixes = new ArrayList();
        String str = isVeryOldGradleVersion ? "Support for builds using Gradle versions older than 2.6 was removed. You should upgrade your Gradle build to use Gradle 2.6 or later." : rootCause.getMessage();
        StringBuilder issueDescription = new StringBuilder(str);
        issueDescription.append("\n\nPossible solution:\n");
        File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(issueData.getProjectPath());
        if (wrapperPropertiesFile == null || isVeryOldGradleVersion || gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo(gradleMinimumVersionRequired) < 0) {
            GradleVersionQuickFix gradleVersionFix = new GradleVersionQuickFix(issueData.getProjectPath(), gradleMinimumVersionRequired, true);
            issueDescription.append(" - <a href=\"" + gradleVersionFix.getId() + "\">Upgrade Gradle wrapper to " + gradleMinimumVersionRequired.getVersion() + " version " + "and re-import the project</a>\n");
            quickFixes.add(gradleVersionFix);
        } else {
            GradleWrapperSettingsOpenQuickFix wrapperSettingsOpenQuickFix = new GradleWrapperSettingsOpenQuickFix(issueData.getProjectPath(), "distributionUrl");
            ReimportQuickFix reimportQuickFix = new ReimportQuickFix(issueData.getProjectPath(), GradleConstants.SYSTEM_ID);
            issueDescription.append(" - <a href=\"" + wrapperSettingsOpenQuickFix.getId() + "\">Open Gradle wrapper settings</a>, " + "upgrade version to " + gradleMinimumVersionRequired.getVersion() + " or newer and <a href=\"" + reimportQuickFix.getId() + "\">reload the project</a>\n");
            quickFixes.add(wrapperSettingsOpenQuickFix);
            quickFixes.add(reimportQuickFix);
        }
        String description = issueDescription.toString();
        String title = BuildConsoleUtils.getMessageTitle((String)description);
        return new BuildIssue(title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$description = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                this.description = $captured_local_variable$1;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        return GradleIssueChecker.DefaultImpls.consumeBuildOutputFailureMessage(this, message, failureCause, stacktrace, location, parentEventId, messageConsumer);
    }
}

