/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.gradle.internal.impldep.org.apache.commons.lang.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class DaemonsUi
implements Disposable {
    private final Project myProject;
    private final DaemonsTable myTable;
    private final RefreshAction myRefreshAction;
    private final StopAllAction myStopAllAction;
    private final StopSelectedAction myStopSelectedAction;
    private final JTextArea myDescriptionLabel;
    private final JPanel myContent = new JPanel();
    private MyDialogWrapper myDialog;
    private boolean myShowStopped;
    private List<? extends DaemonState> myDaemonStateList;

    public DaemonsUi(Project project) {
        this.myProject = project;
        this.myRefreshAction = new RefreshAction();
        this.myStopAllAction = new StopAllAction();
        this.myStopSelectedAction = new StopSelectedAction();
        this.myContent.setLayout(new BorderLayout(10, 4));
        this.myTable = new DaemonsTable();
        this.myDescriptionLabel = new JTextArea(6, 50);
        this.myDescriptionLabel.setWrapStyleWord(true);
        this.myDescriptionLabel.setLineWrap(true);
        this.myDescriptionLabel.setEditable(false);
        JScrollPane label = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionLabel);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)label, "Center");
        JBCheckBox showStoppedCb = new JBCheckBox(GradleBundle.message("gradle.daemons.show.stopped", new Object[0]));
        showStoppedCb.addActionListener(e -> {
            if (this.myShowStopped != showStoppedCb.isSelected()) {
                this.myShowStopped = showStoppedCb.isSelected();
                this.updateDaemonsList(this.myDaemonStateList);
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)showStoppedCb);
        descriptionPanel.add((Component)showStoppedCb, "South");
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GradleBundle.message("gradle.daemons.description.title", new Object[0]), (boolean)false));
        final TableView tableView = this.myTable.getTableView();
        tableView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DaemonState daemonState = (DaemonState)tableView.getSelectedObject();
                if (daemonState != null) {
                    String desc = daemonState.getDescription();
                    DaemonsUi.this.myDescriptionLabel.setText(desc);
                    DaemonsUi.this.myDescriptionLabel.setCaretPosition(0);
                } else {
                    DaemonsUi.this.myDescriptionLabel.setText(null);
                }
            }
        });
        this.myContent.add((Component)ScrollPaneFactory.createScrollPane((Component)tableView), "Center");
        this.myContent.add((Component)descriptionPanel, "South");
    }

    public void dispose() {
    }

    public void show(List<? extends DaemonState> daemonStateList) {
        this.updateDaemonsList(daemonStateList);
        this.myDialog = new MyDialogWrapper();
        this.myDialog.show();
    }

    private void updateDaemonsList(List<? extends DaemonState> daemonStateList) {
        this.myDaemonStateList = daemonStateList;
        daemonStateList = !this.myShowStopped ? ContainerUtil.filter(daemonStateList, state -> state.getToken() != null) : this.myDaemonStateList;
        this.myTable.setValues(daemonStateList);
        this.myTable.refreshValues();
        this.invalidateActions();
    }

    private void invalidateActions() {
        if (this.myDialog != null) {
            this.myDialog.invalidateActions();
        }
    }

    private static class MultiLineTableCellRenderer
    extends JBList<String>
    implements TableCellRenderer {
        private MultiLineTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int width = table.getColumnModel().getColumn(column).getPreferredWidth();
            Object[] data = WordUtils.wrap((String)String.valueOf(value), (int)width, null, (boolean)false).split("\n");
            this.setListData(data);
            table.setRowHeight(row, table.getRowHeight() * data.length);
            this.setBackground(UIUtil.getTableBackground((boolean)isSelected));
            return this;
        }
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private AbstractAction myCloseAction;

        MyDialogWrapper() {
            super(true);
            this.setTitle(GradleBundle.message("gradle.daemons.gradle.daemons", new Object[0]));
            this.setModal(false);
            this.init();
            DaemonsUi.this.myTable.getTableView().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    MyDialogWrapper.this.invalidateActions();
                }
            });
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel infoLabel = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)("Daemons started by " + ApplicationNamesInfo.getInstance().getFullProductName() + " (or other daemons of the similar configuration) are displayed. <i>Gradle 3.0 or better supported.<i>")));
            infoLabel.setIcon(UIUtil.getInformationIcon());
            panel.add((Component)infoLabel, "Center");
            return panel;
        }

        protected JComponent createCenterPanel() {
            return DaemonsUi.this.myContent;
        }

        protected void dispose() {
            super.dispose();
            DaemonsUi.this.myDialog = null;
            Disposer.dispose((Disposable)DaemonsUi.this);
        }

        protected String getDimensionServiceKey() {
            return "GradleDaemons";
        }

        public JComponent getPreferredFocusedComponent() {
            return DaemonsUi.this.myTable.getTableView();
        }

        protected Action @NotNull [] createActions() {
            return new Action[]{DaemonsUi.this.myStopAllAction, DaemonsUi.this.myStopSelectedAction, this.myCloseAction};
        }

        protected Action @NotNull [] createLeftSideActions() {
            return new Action[]{DaemonsUi.this.myRefreshAction};
        }

        protected void createDefaultActions() {
            super.createDefaultActions();
            this.myCloseAction = new AbstractAction(GradleBundle.message("gradle.daemons.close", new Object[0])){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    MyDialogWrapper.this.doOKAction();
                }
            };
            this.myCloseAction.putValue("DefaultAction", true);
        }

        public void invalidateActions() {
            DaemonsUi.this.myStopSelectedAction.setEnabled(DaemonsUi.this.myStopSelectedAction.isEnabled());
            DaemonsUi.this.myStopAllAction.setEnabled(DaemonsUi.this.myStopAllAction.isEnabled());
        }
    }

    private class StopSelectedAction
    extends AbstractAction {
        StopSelectedAction() {
            super(GradleBundle.message("gradle.daemons.stop.selected", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            Collection selection = DaemonsUi.this.myTable.getTableView().getSelection();
            return !selection.isEmpty() && selection.stream().anyMatch(state -> state.getToken() != null && !"Stopped".equals(state.getStatus()));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.ActionID.stopSelectedDaemons);
            GradleDaemonServices.stopDaemons(DaemonsUi.this.myTable.getTableView().getSelectedObjects());
            List<DaemonState> daemonStateList = GradleDaemonServices.getDaemonsStatus();
            DaemonsUi.this.myTable.setValues(daemonStateList);
            DaemonsUi.this.updateDaemonsList(daemonStateList);
        }
    }

    private class StopAllAction
    extends AbstractAction {
        StopAllAction() {
            super(GradleBundle.message("gradle.daemons.stop.all", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return DaemonsUi.this.myTable.getElements().stream().anyMatch(state -> state.getToken() != null && !"Stopped".equals(state.getStatus()));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.ActionID.stopAllDaemons);
            GradleDaemonServices.stopDaemons();
            List<DaemonState> daemonStateList = GradleDaemonServices.getDaemonsStatus();
            DaemonsUi.this.myTable.setValues(daemonStateList);
            DaemonsUi.this.updateDaemonsList(daemonStateList);
        }
    }

    private class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super(GradleBundle.message("gradle.daemons.refresh", new Object[0]), AllIcons.Actions.Refresh);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.ActionID.refreshDaemons);
            List<DaemonState> daemonStateList = GradleDaemonServices.getDaemonsStatus();
            DaemonsUi.this.myTable.setValues(daemonStateList);
            DaemonsUi.this.updateDaemonsList(daemonStateList);
        }
    }

    private static class DaemonsTable
    extends ListTableWithButtons<DaemonState> {
        private DaemonsTable() {
        }

        protected ListTableModel createListModel() {
            TableColumn pidColumn = new TableColumn("PID", 80){

                @Nullable
                public String valueOf(DaemonState daemonState) {
                    return String.valueOf(daemonState.getPid());
                }

                @Nullable
                public Comparator<DaemonState> getComparator() {
                    return Comparator.comparing(DaemonState::getPid);
                }
            };
            TableColumn statusColumn = new TableColumn("Status", 100){

                @Nullable
                public String valueOf(DaemonState daemonState) {
                    return daemonState.getStatus();
                }

                @Nullable
                public Comparator<DaemonState> getComparator() {
                    return Comparator.comparing(DaemonState::getStatus);
                }
            };
            TableColumn timeColumn = new TableColumn("Timestamp", 150){

                @NotNull
                public String valueOf(DaemonState daemonState) {
                    return DateFormatUtil.formatPrettyDateTime((long)daemonState.getTimestamp());
                }

                @Nullable
                public Comparator<DaemonState> getComparator() {
                    return Comparator.comparing(DaemonState::getTimestamp);
                }
            };
            TableColumn infoColumn = new TableColumn("Info", -1){
                private MultiLineTableCellRenderer myRenderer;

                @NotNull
                public String valueOf(DaemonState daemonState) {
                    return daemonState.getVersion() != null ? daemonState.getVersion() : StringUtil.capitalize((String)daemonState.getReason());
                }

                public TableCellRenderer getRenderer(DaemonState element) {
                    String text = this.valueOf(element);
                    if (text.length() < this.getTableView().getColumnModel().getColumn(2).getPreferredWidth()) {
                        return super.getRenderer((Object)element);
                    }
                    if (this.myRenderer == null) {
                        this.myRenderer = new MultiLineTableCellRenderer();
                    }
                    return this.myRenderer;
                }
            };
            ColumnInfo[] columnInfos = new ColumnInfo[]{pidColumn, statusColumn, infoColumn, timeColumn};
            return new ListTableModel(columnInfos, new ArrayList(), 3, SortOrder.DESCENDING);
        }

        protected DaemonState createElement() {
            return new DaemonState(null, null, null, null, null, -1L, null, null, null, null, null);
        }

        protected boolean isEmpty(DaemonState daemonState) {
            return StringUtil.isEmpty((String)daemonState.getStatus()) && StringUtil.isEmpty((String)daemonState.getVersion());
        }

        protected DaemonState cloneElement(DaemonState daemonState) {
            return new DaemonState(daemonState.getPid(), daemonState.getToken(), daemonState.getVersion(), daemonState.getStatus(), daemonState.getReason(), daemonState.getTimestamp(), daemonState.getDaemonExpirationStatus(), daemonState.getDaemonOpts(), daemonState.getJavaHome(), daemonState.getIdleTimeout(), daemonState.getRegistryDir());
        }

        protected boolean canDeleteElement(DaemonState selection) {
            return true;
        }

        public List<DaemonState> getElements() {
            return super.getElements();
        }

        private static abstract class TableColumn
        extends ListTableWithButtons.ElementsColumnInfoBase<DaemonState> {
            private final int myWidth;

            TableColumn(String name, int width) {
                super(name);
                this.myWidth = width;
            }

            public boolean isCellEditable(DaemonState daemonState) {
                return false;
            }

            @Nullable
            protected String getDescription(DaemonState daemonState) {
                return null;
            }

            public int getWidth(JTable table) {
                return this.myWidth;
            }
        }
    }
}

