/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMissingPropertyFix
implements LocalQuickFix,
BatchQuickFix<CommonProblemDescriptor> {
    private final JsonValidationError.MissingMultiplePropsIssueData myData;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public AddMissingPropertyFix(JsonValidationError.MissingMultiplePropsIssueData data, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JsonBundle.message("add.missing.properties", new Object[0]);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return JsonBundle.message("add.missing.0", this.myData.getMessage(true));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        TextRange range;
        PsiElement element = descriptor.getPsiElement();
        Ref hadComma = Ref.create((Object)false);
        VirtualFile file = element.getContainingFile().getVirtualFile();
        PsiElement newElement = this.performFix(element, (Ref<Boolean>)hadComma);
        if (newElement == null) {
            return;
        }
        PsiElement value = this.myQuickFixAdapter.getPropertyValue(newElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
        assert (editor != null);
        if (value == null) {
            WriteAction.run(() -> editor.getCaretModel().moveToOffset(newElement.getTextRange().getEndOffset()));
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        TemplateBuilderImpl builder = new TemplateBuilderImpl(newElement);
        String text = value.getText();
        boolean isEmptyArray = StringUtil.equalsIgnoreWhitespaces((CharSequence)text, (CharSequence)"[]");
        boolean isEmptyObject = StringUtil.equalsIgnoreWhitespaces((CharSequence)text, (CharSequence)"{}");
        boolean goInside = isEmptyArray || isEmptyObject || StringUtil.isQuotedString((String)text);
        TextRange textRange = range = goInside ? TextRange.create((int)1, (int)(text.length() - 1)) : TextRange.create((int)0, (int)text.length());
        builder.replaceElement(value, range, (Expression)(this.myData.myMissingPropertyIssues.iterator().next().enumItemsCount > 1 || isEmptyObject ? new MacroCallNode((Macro)new CompleteMacro()) : (isEmptyArray ? new EmptyNode() : new ConstantNode(goInside ? StringUtil.unquoteString((String)text) : text))));
        editor.getCaretModel().moveToOffset(newElement.getTextRange().getStartOffset());
        if (PsiTreeUtil.nextLeaf((PsiElement)newElement) != null) {
            builder.setEndVariableAfter(newElement);
        } else {
            builder.setEndVariableBefore(newElement.getLastChild());
        }
        WriteAction.run(() -> {
            Template template = builder.buildInlineTemplate();
            template.setToReformat(true);
            templateManager.startTemplate((Editor)editor, template);
        });
    }

    @Nullable
    public PsiElement performFix(@Nullable PsiElement node, @NotNull Ref<Boolean> hadComma) {
        if (node == null) {
            return null;
        }
        PsiElement element = node instanceof PsiFile ? node.getFirstChild() : node;
        Ref newElementRef = Ref.create(null);
        WriteAction.run(() -> {
            boolean isSingle = this.myData.myMissingPropertyIssues.size() == 1;
            PsiElement processedElement = element;
            List reverseOrder = ContainerUtil.reverse(new ArrayList<JsonValidationError.MissingPropertyIssueData>(this.myData.myMissingPropertyIssues));
            for (JsonValidationError.MissingPropertyIssueData issue : reverseOrder) {
                Object defaultValueObject = issue.defaultValue;
                String defaultValue = this.formatDefaultValue(defaultValueObject);
                PsiElement property = this.myQuickFixAdapter.createProperty(issue.propertyName, defaultValue == null ? this.myQuickFixAdapter.getDefaultValueFromType(issue.propertyType) : defaultValue, element);
                PsiElement newElement = processedElement instanceof LeafPsiElement ? this.myQuickFixAdapter.adjustPropertyAnchor((LeafPsiElement)processedElement).addBefore(property, null) : (processedElement == element ? processedElement.addBefore(property, processedElement.getLastChild()) : processedElement.getParent().addBefore(property, processedElement));
                PsiElement adjusted = this.myQuickFixAdapter.adjustNewProperty(newElement);
                hadComma.set((Object)this.myQuickFixAdapter.ensureComma(adjusted, PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)newElement)));
                if (!((Boolean)hadComma.get()).booleanValue()) {
                    hadComma.set((Object)(processedElement == element && this.myQuickFixAdapter.ensureComma(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)newElement), adjusted) ? 1 : 0));
                }
                processedElement = adjusted;
                if (!isSingle) continue;
                newElementRef.set((Object)adjusted);
            }
        });
        return (PsiElement)newElementRef.get();
    }

    @Nullable
    @Contract(value="null -> null")
    public String formatDefaultValue(@Nullable Object defaultValueObject) {
        if (defaultValueObject instanceof String) {
            return StringUtil.wrapWithDoubleQuote((String)defaultValueObject.toString());
        }
        if (defaultValueObject instanceof Boolean) {
            return Boolean.toString((Boolean)defaultValueObject);
        }
        if (defaultValueObject instanceof Number) {
            return defaultValueObject.toString();
        }
        if (defaultValueObject instanceof PsiElement) {
            return ((PsiElement)defaultValueObject).getText();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        ArrayList<Pair> propFixes = new ArrayList<Pair>();
        for (CommonProblemDescriptor descriptor : descriptors) {
            AddMissingPropertyFix fix;
            QuickFix[] fixes;
            if (!(descriptor instanceof ProblemDescriptor) || (fixes = descriptor.getFixes()) == null || (fix = AddMissingPropertyFix.getWorkingQuickFix(fixes)) == null) continue;
            propFixes.add(Pair.create((Object)fix, (Object)((ProblemDescriptor)descriptor).getPsiElement()));
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> propFixes.forEach(fix -> ((AddMissingPropertyFix)fix.first).performFix((PsiElement)fix.second, (Ref<Boolean>)Ref.create((Object)false))));
    }

    @Nullable
    private static AddMissingPropertyFix getWorkingQuickFix(QuickFix @NotNull [] fixes) {
        for (QuickFix fix : fixes) {
            if (!(fix instanceof AddMissingPropertyFix)) continue;
            return (AddMissingPropertyFix)fix;
        }
        return null;
    }
}

