/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.adapters;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonPropertyAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonJsonObjectAdapter
implements JsonObjectValueAdapter {
    @NotNull
    private final JsonObject myValue;

    public JsonJsonObjectAdapter(@NotNull JsonObject value) {
        this.myValue = value;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return false;
    }

    @Override
    public boolean isNumberLiteral() {
        return false;
    }

    @Override
    public boolean isBooleanLiteral() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getDelegate() {
        return this.myValue;
    }

    @Override
    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return this;
    }

    @Override
    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    @Override
    @NotNull
    public List<JsonPropertyAdapter> getPropertyList() {
        return this.myValue.getPropertyList().stream().filter(p -> p != null).map(p -> new JsonJsonPropertyAdapter((JsonProperty)p)).collect(Collectors.toList());
    }
}

