/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonRequiredPropsReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)Holder.REF_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(false));
        registrar.registerReferenceProvider((ElementPattern)Holder.REC_REF_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(false));
        registrar.registerReferenceProvider((ElementPattern)Holder.SCHEMA_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(true));
        registrar.registerReferenceProvider((ElementPattern)Holder.REQUIRED_PROP_PATTERN, (PsiReferenceProvider)new JsonRequiredPropsReferenceProvider());
    }

    private static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull String propertyName, final boolean schemaOnly, final boolean rootOnly) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonProperty property;
                if (element instanceof JsonValue && (property = (JsonProperty)ObjectUtils.tryCast((Object)((JsonValue)element).getParent(), JsonProperty.class)) != null && property.getValue() == element && propertyName.equals(property.getName())) {
                    PsiFile file = property.getContainingFile();
                    if (rootOnly && (!(file instanceof JsonFile) || ((JsonFile)file).getTopLevelValue() != property.getParent())) {
                        return false;
                    }
                    return !schemaOnly || JsonSchemaService.isSchemaFile((PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)file));
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static PsiElementPattern.Capture<JsonStringLiteral> createRequiredPropPattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (!(element instanceof JsonStringLiteral)) {
                    return false;
                }
                PsiElement parent = ((JsonStringLiteral)element).getParent();
                if (!(parent instanceof JsonArray)) {
                    return false;
                }
                PsiElement property = parent.getParent();
                if (!(property instanceof JsonProperty)) {
                    return false;
                }
                return "required".equals(((JsonProperty)property).getName()) && JsonSchemaService.isSchemaFile(((JsonStringLiteral)element).getContainingFile());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    static /* synthetic */ PsiElementPattern.Capture access$000(String x0, boolean x1, boolean x2) {
        return JsonSchemaReferenceContributor.createPropertyValuePattern(x0, x1, x2);
    }

    static /* synthetic */ PsiElementPattern.Capture access$100() {
        return JsonSchemaReferenceContributor.createRequiredPropPattern();
    }

    private static class Holder {
        private static final PsiElementPattern.Capture<JsonValue> REF_PATTERN = JsonSchemaReferenceContributor.access$000("$ref", true, false);
        private static final PsiElementPattern.Capture<JsonValue> REC_REF_PATTERN = JsonSchemaReferenceContributor.access$000("$recursiveRef", true, false);
        private static final PsiElementPattern.Capture<JsonValue> SCHEMA_PATTERN = JsonSchemaReferenceContributor.access$000("$schema", false, true);
        private static final PsiElementPattern.Capture<JsonStringLiteral> REQUIRED_PROP_PATTERN = JsonSchemaReferenceContributor.access$100();

        private Holder() {
        }
    }
}

