/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.navigation.JsonQualifiedNameProvider;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaFileValuesIndex;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonCachedValues {
    private static final Key<CachedValue<JsonSchemaObject>> JSON_OBJECT_CACHE_KEY = Key.create((String)"JsonSchemaObjectCache");
    static final String URL_CACHE_KEY = "JsonSchemaUrlCache";
    private static final Key<CachedValue<String>> SCHEMA_URL_KEY = Key.create((String)"JsonSchemaUrlCache");
    static final String ID_CACHE_KEY = "JsonSchemaIdCache";
    static final String OBSOLETE_ID_CACHE_KEY = "JsonSchemaObsoleteIdCache";
    private static final Key<CachedValue<String>> SCHEMA_ID_CACHE_KEY = Key.create((String)"JsonSchemaIdCache");
    static final String ID_PATHS_CACHE_KEY = "JsonSchemaIdToPointerCache";
    private static final Key<CachedValue<Map<String, String>>> SCHEMA_ID_PATHS_CACHE_KEY = Key.create((String)"JsonSchemaIdToPointerCache");
    private static final Key<CachedValue<List<JsonSchemaCatalogEntry>>> SCHEMA_CATALOG_CACHE_KEY = Key.create((String)"JsonSchemaCatalogCache");
    public static final Key<CachedValue<JsonSchemaObject>> OBJECT_FOR_FILE_KEY = new Key("JsonCachedValues.OBJ_KEY");

    @Nullable
    public static JsonSchemaObject getSchemaObject(@NotNull VirtualFile schemaFile, @NotNull Project project) {
        JsonFileResolver.startFetchingHttpFileIfNeeded(schemaFile, project);
        return JsonCachedValues.computeForFile(schemaFile, project, JsonCachedValues::computeSchemaObject, JSON_OBJECT_CACHE_KEY);
    }

    @Nullable
    private static JsonSchemaObject computeSchemaObject(@NotNull PsiFile f) {
        return new JsonSchemaReader(f.getVirtualFile()).read(f);
    }

    @Nullable
    public static String getSchemaUrlFromSchemaProperty(@NotNull VirtualFile file, @NotNull Project project) {
        String value = JsonSchemaFileValuesIndex.getCachedValue(project, file, URL_CACHE_KEY);
        if (value != null) {
            return "$NULL$".equals(value) ? null : value;
        }
        PsiFile psiFile = JsonCachedValues.resolveFile(file, project);
        return !(psiFile instanceof JsonFile) ? null : JsonCachedValues.getOrCompute(psiFile, JsonCachedValues::fetchSchemaUrl, SCHEMA_URL_KEY);
    }

    private static PsiFile resolveFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (project.isDisposed() || !file.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(file);
    }

    @Nullable
    static String fetchSchemaUrl(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        String url = JsonSchemaFileValuesIndex.readTopLevelProps(psiFile.getFileType(), psiFile.getText()).get(URL_CACHE_KEY);
        return url == null || "$NULL$".equals(url) ? null : url;
    }

    @Nullable
    public static String getSchemaId(@NotNull VirtualFile schemaFile, @NotNull Project project) {
        if (schemaFile instanceof LightVirtualFile) {
            return null;
        }
        String value = JsonSchemaFileValuesIndex.getCachedValue(project, schemaFile, ID_CACHE_KEY);
        if (value != null && !"$NULL$".equals(value)) {
            return JsonPointerUtil.normalizeId(value);
        }
        String obsoleteValue = JsonSchemaFileValuesIndex.getCachedValue(project, schemaFile, OBSOLETE_ID_CACHE_KEY);
        if (obsoleteValue != null && !"$NULL$".equals(obsoleteValue)) {
            return JsonPointerUtil.normalizeId(obsoleteValue);
        }
        if ("$NULL$".equals(value) || "$NULL$".equals(obsoleteValue)) {
            return null;
        }
        String result = JsonCachedValues.computeForFile(schemaFile, project, JsonCachedValues::fetchSchemaId, SCHEMA_ID_CACHE_KEY);
        return result == null ? null : JsonPointerUtil.normalizeId(result);
    }

    @Nullable
    private static <T> T computeForFile(@NotNull VirtualFile schemaFile, @NotNull Project project, @NotNull Function<? super PsiFile, ? extends T> eval, @NotNull Key<CachedValue<T>> cacheKey) {
        PsiFile psiFile = JsonCachedValues.resolveFile(schemaFile, project);
        if (psiFile == null) {
            return null;
        }
        return JsonCachedValues.getOrCompute(psiFile, eval, cacheKey);
    }

    public static Collection<String> getAllIdsInFile(PsiFile psiFile) {
        Map<String, String> map = JsonCachedValues.getOrComputeIdsMap(psiFile);
        return map == null ? ContainerUtil.emptyList() : map.keySet();
    }

    @Nullable
    public static String resolveId(PsiFile psiFile, String id) {
        Map<String, String> map = JsonCachedValues.getOrComputeIdsMap(psiFile);
        return map == null ? null : map.get(id);
    }

    @Nullable
    public static Map<String, String> getOrComputeIdsMap(PsiFile psiFile) {
        return JsonCachedValues.getOrCompute(psiFile, JsonCachedValues::computeIdsMap, SCHEMA_ID_PATHS_CACHE_KEY);
    }

    @NotNull
    private static Map<String, String> computeIdsMap(PsiFile file) {
        return SyntaxTraverser.psiTraverser((PsiElement)file).filter(JsonProperty.class).filter(p -> "$id".equals(StringUtil.unquoteString((String)p.getNameElement().getText()))).filter(p -> p.getValue() instanceof JsonStringLiteral).toMap(p -> ((JsonStringLiteral)Objects.requireNonNull(p.getValue())).getValue(), p -> JsonQualifiedNameProvider.generateQualifiedName(p.getParent(), JsonQualifiedNameKind.JsonPointer));
    }

    @Nullable
    static String fetchSchemaId(@NotNull PsiFile psiFile) {
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        Map<String, String> props = JsonSchemaFileValuesIndex.readTopLevelProps(psiFile.getFileType(), psiFile.getText());
        String id = props.get(ID_CACHE_KEY);
        if (id != null && !"$NULL$".equals(id)) {
            return id;
        }
        String obsoleteId = props.get(OBSOLETE_ID_CACHE_KEY);
        return obsoleteId == null || "$NULL$".equals(obsoleteId) ? null : obsoleteId;
    }

    @Nullable
    public static List<JsonSchemaCatalogEntry> getSchemaCatalog(@NotNull VirtualFile catalog, @NotNull Project project) {
        if (!catalog.isValid()) {
            return null;
        }
        return JsonCachedValues.computeForFile(catalog, project, JsonCachedValues::computeSchemaCatalog, SCHEMA_CATALOG_CACHE_KEY);
    }

    private static List<JsonSchemaCatalogEntry> computeSchemaCatalog(PsiFile catalog) {
        if (!catalog.isValid()) {
            return null;
        }
        VirtualFile virtualFile = catalog.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        JsonValue value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)catalog, () -> catalog instanceof JsonFile ? ((JsonFile)catalog).getTopLevelValue() : null);
        if (!(value instanceof JsonObject)) {
            return null;
        }
        JsonProperty schemas = ((JsonObject)value).findProperty("schemas");
        if (schemas == null) {
            return null;
        }
        JsonValue schemasValue = schemas.getValue();
        if (!(schemasValue instanceof JsonArray)) {
            return null;
        }
        ArrayList<JsonSchemaCatalogEntry> catalogMap = new ArrayList<JsonSchemaCatalogEntry>();
        JsonCachedValues.fillMap((JsonArray)schemasValue, catalogMap);
        return catalogMap;
    }

    private static void fillMap(@NotNull JsonArray array, @NotNull List<JsonSchemaCatalogEntry> catalogMap) {
        for (JsonValue value : array.getValueList()) {
            JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            if (obj == null) continue;
            JsonProperty fileMatch = obj.findProperty("fileMatch");
            List masks = fileMatch == null ? ContainerUtil.emptyList() : JsonCachedValues.resolveMasks(fileMatch.getValue());
            String urlString = JsonCachedValues.readStringValue(obj.findProperty("url"));
            if (urlString == null) continue;
            catalogMap.add(new JsonSchemaCatalogEntry(masks, urlString, JsonCachedValues.readStringValue(obj.findProperty("name")), JsonCachedValues.readStringValue(obj.findProperty("description"))));
        }
    }

    @Nullable
    private static String readStringValue(@Nullable JsonProperty property) {
        String urlStringValue;
        if (property == null) {
            return null;
        }
        JsonValue urlValue = property.getValue();
        if (urlValue instanceof JsonStringLiteral && !StringUtil.isEmpty((String)(urlStringValue = ((JsonStringLiteral)urlValue).getValue()))) {
            return urlStringValue;
        }
        return null;
    }

    @NotNull
    private static Collection<String> resolveMasks(@Nullable JsonValue value) {
        if (value instanceof JsonStringLiteral) {
            return ContainerUtil.createMaybeSingletonList((Object)((JsonStringLiteral)value).getValue());
        }
        if (value instanceof JsonArray) {
            ArrayList<String> strings = new ArrayList<String>();
            for (JsonValue val : ((JsonArray)value).getValueList()) {
                if (!(val instanceof JsonStringLiteral)) continue;
                strings.add(((JsonStringLiteral)val).getValue());
            }
            return strings;
        }
        return ContainerUtil.emptyList();
    }

    @Nullable
    private static <T> T getOrCompute(@NotNull PsiFile psiFile, @NotNull Function<? super PsiFile, ? extends T> eval, @NotNull Key<CachedValue<T>> key) {
        return (T)CachedValuesManager.getCachedValue((PsiElement)psiFile, key, () -> CachedValueProvider.Result.create((Object)eval.fun((Object)psiFile), (Object[])new Object[]{psiFile}));
    }

    @Nullable
    static JsonSchemaObject computeSchemaForFile(@NotNull PsiFile file, @NotNull JsonSchemaService service) {
        PsiFile originalFile = (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)file);
        JsonSchemaObject value = (JsonSchemaObject)CachedValuesManager.getCachedValue((PsiElement)originalFile, OBJECT_FOR_FILE_KEY, () -> {
            VirtualFile virtualFile = originalFile.getVirtualFile();
            VirtualFile schemaFile = virtualFile == null ? null : JsonCachedValues.getSchemaFile(virtualFile, service);
            JsonSchemaObject schemaObject = virtualFile == null ? null : service.getSchemaObject(virtualFile);
            PsiFile psiFile = schemaFile == null || !schemaFile.isValid() ? null : originalFile.getManager().findFile(schemaFile);
            JsonSchemaObject object = schemaObject == null ? JsonSchemaObject.NULL_OBJ : schemaObject;
            return psiFile == null ? CachedValueProvider.Result.create((Object)object, (Object[])new Object[]{originalFile, service}) : CachedValueProvider.Result.create((Object)object, (Object[])new Object[]{originalFile, psiFile, service});
        });
        return value == JsonSchemaObject.NULL_OBJ ? null : value;
    }

    static VirtualFile getSchemaFile(@NotNull VirtualFile sourceFile, @NotNull JsonSchemaService service) {
        JsonSchemaServiceImpl serviceImpl = (JsonSchemaServiceImpl)service;
        Collection<VirtualFile> schemas = serviceImpl.getSchemasForFile(sourceFile, true, false);
        if (schemas.size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        return schemas.iterator().next();
    }
}

