/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsonSchemaCatalogProjectConfiguration", storages={@Storage(value="jsonCatalog.xml")})
public class JsonSchemaCatalogProjectConfiguration
implements PersistentStateComponent<MyState> {
    public volatile MyState myState = new MyState();
    private final List<Runnable> myChangeHandlers = ContainerUtil.createConcurrentList();

    public boolean isCatalogEnabled() {
        MyState state = this.getState();
        return state != null && state.myIsCatalogEnabled;
    }

    public boolean isPreferRemoteSchemas() {
        MyState state = this.getState();
        return state != null && state.myIsPreferRemoteSchemas;
    }

    public void addChangeHandler(Runnable runnable) {
        this.myChangeHandlers.add(runnable);
    }

    public static JsonSchemaCatalogProjectConfiguration getInstance(@NotNull Project project) {
        return (JsonSchemaCatalogProjectConfiguration)ServiceManager.getService((Project)project, JsonSchemaCatalogProjectConfiguration.class);
    }

    public void setState(boolean isEnabled, boolean isRemoteActivityEnabled, boolean isPreferRemoteSchemas) {
        this.myState = new MyState(isEnabled, isRemoteActivityEnabled, isPreferRemoteSchemas);
        for (Runnable handler : this.myChangeHandlers) {
            handler.run();
        }
    }

    @Nullable
    public MyState getState() {
        return this.myState;
    }

    public boolean isRemoteActivityEnabled() {
        MyState state = this.getState();
        return state != null && state.myIsRemoteActivityEnabled;
    }

    public void loadState(@NotNull MyState state) {
        this.myState = state;
        for (Runnable handler : this.myChangeHandlers) {
            handler.run();
        }
    }

    static class MyState {
        @Tag(value="enabled")
        public boolean myIsCatalogEnabled = true;
        @Tag(value="remoteActivityEnabled")
        public boolean myIsRemoteActivityEnabled = true;
        @Tag(value="preferRemoteSchemas")
        public boolean myIsPreferRemoteSchemas = false;

        MyState() {
        }

        MyState(boolean isCatalogEnabled, boolean isRemoteActivityEnabled, boolean isPreferRemoteSchemas) {
            this.myIsCatalogEnabled = isCatalogEnabled;
            this.myIsRemoteActivityEnabled = isRemoteActivityEnabled;
            this.myIsPreferRemoteSchemas = isPreferRemoteSchemas;
        }
    }
}

