/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPointerUtil {
    @NotNull
    public static String escapeForJsonPointer(@NotNull String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return URLUtil.encodeURIComponent((String)name);
        }
        return StringUtil.replace((String)StringUtil.replace((String)name, (String)"~", (String)"~0"), (String)"/", (String)"~1");
    }

    @NotNull
    public static String unescapeJsonPointerPart(@NotNull String part) {
        part = URLUtil.unescapePercentSequences((String)part);
        return StringUtil.replace((String)StringUtil.replace((String)part, (String)"~0", (String)"~"), (String)"~1", (String)"/");
    }

    public static boolean isSelfReference(@Nullable String ref) {
        return "#".equals(ref) || "#/".equals(ref) || StringUtil.isEmpty((String)ref);
    }

    @NotNull
    public static List<String> split(@NotNull String pointer) {
        return StringUtil.split((String)pointer, (String)"/", (boolean)true, (boolean)false);
    }

    @NotNull
    public static String normalizeSlashes(@NotNull String ref) {
        return StringUtil.trimStart((String)ref.replace('\\', '/'), (String)"/");
    }

    @NotNull
    public static String normalizeId(@NotNull String id) {
        id = id.endsWith("#") ? id.substring(0, id.length() - 1) : id;
        return id.startsWith("#") ? id.substring(1) : id;
    }
}

