/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonStructureViewElement
implements StructureViewTreeElement {
    private final JsonElement myElement;

    public JsonStructureViewElement(@NotNull JsonElement element) {
        assert (PsiTreeUtil.instanceOf((Object)element, (Class[])new Class[]{JsonFile.class, JsonProperty.class, JsonObject.class, JsonArray.class}));
        this.myElement = element;
    }

    public JsonElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation presentation = this.myElement.getPresentation();
        assert (presentation != null);
        return presentation;
    }

    public TreeElement @NotNull [] getChildren() {
        JsonElement value = null;
        if (this.myElement instanceof JsonFile) {
            value = ((JsonFile)this.myElement).getTopLevelValue();
        } else if (this.myElement instanceof JsonProperty) {
            value = ((JsonProperty)this.myElement).getValue();
        } else if (PsiTreeUtil.instanceOf((Object)this.myElement, (Class[])new Class[]{JsonObject.class, JsonArray.class})) {
            value = this.myElement;
        }
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            return (TreeElement[])ContainerUtil.map2Array(object.getPropertyList(), TreeElement.class, property -> new JsonStructureViewElement((JsonElement)property));
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            List childObjects = ContainerUtil.mapNotNull(array.getValueList(), value1 -> {
                if (value1 instanceof JsonObject && !((JsonObject)value1).getPropertyList().isEmpty()) {
                    return new JsonStructureViewElement((JsonElement)value1);
                }
                if (value1 instanceof JsonArray && PsiTreeUtil.findChildOfType((PsiElement)value1, JsonProperty.class) != null) {
                    return new JsonStructureViewElement((JsonElement)value1);
                }
                return null;
            });
            return childObjects.toArray(TreeElement.EMPTY_ARRAY);
        }
        return EMPTY_ARRAY;
    }
}

