/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class JsonCodeStyleSettings
extends CustomCodeStyleSettings {
    public static final int DO_NOT_ALIGN_PROPERTY = PropertyAlignment.DO_NOT_ALIGN.getId();
    public static final int ALIGN_PROPERTY_ON_VALUE = PropertyAlignment.ALIGN_ON_VALUE.getId();
    public static final int ALIGN_PROPERTY_ON_COLON = PropertyAlignment.ALIGN_ON_COLON.getId();
    public boolean SPACE_AFTER_COLON = true;
    public boolean SPACE_BEFORE_COLON = false;
    public boolean KEEP_TRAILING_COMMA = false;
    public int PROPERTY_ALIGNMENT = PropertyAlignment.DO_NOT_ALIGN.getId();
    public int OBJECT_WRAPPING = 2;
    public int ARRAY_WRAPPING = 2;

    public JsonCodeStyleSettings(CodeStyleSettings container) {
        super(JsonLanguage.INSTANCE.getID(), container);
    }

    public static enum PropertyAlignment {
        DO_NOT_ALIGN(0, "formatter.align.properties.none"),
        ALIGN_ON_VALUE(1, "formatter.align.properties.on.value"),
        ALIGN_ON_COLON(2, "formatter.align.properties.on.colon");

        @PropertyKey(resourceBundle="messages.JsonBundle")
        private final String myKey;
        private final int myId;

        private PropertyAlignment(int id, String key) {
            this.myKey = key;
            this.myId = id;
        }

        @NotNull
        public String getDescription() {
            return JsonBundle.message(this.myKey, new Object[0]);
        }

        public int getId() {
            return this.myId;
        }
    }
}

