/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.codeinsight.JsonStandardComplianceProvider;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStandardComplianceInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(JsonStandardComplianceInspection.class);
    public boolean myWarnAboutComments = true;
    public boolean myWarnAboutNanInfinity = true;
    public boolean myWarnAboutTrailingCommas = true;
    public boolean myWarnAboutMultipleTopLevelValues = true;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!JsonDialectUtil.isStandardJson((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new StandardJsonValidatingElementVisitor(holder);
    }

    @Nullable
    private static PsiElement findTrailingComma(@NotNull JsonContainer container, @NotNull IElementType ending) {
        PsiElement lastChild = container.getLastChild();
        if (lastChild.getNode().getElementType() != ending) {
            return null;
        }
        PsiElement beforeEnding = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        if (beforeEnding != null && beforeEnding.getNode().getElementType() == JsonElementTypes.COMMA) {
            return beforeEnding;
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.comments", new Object[0]), "myWarnAboutComments");
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.multiple.top.level.values", new Object[0]), "myWarnAboutMultipleTopLevelValues");
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.trailing.comma", new Object[0]), "myWarnAboutTrailingCommas");
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.nan.infinity", new Object[0]), "myWarnAboutNanInfinity");
        return optionsPanel;
    }

    protected class StandardJsonValidatingElementVisitor
    extends JsonElementVisitor {
        private final ProblemsHolder myHolder;
        private static final String MISSING_VALUE = "missingValue";

        public StandardJsonValidatingElementVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        protected boolean allowComments() {
            return false;
        }

        protected boolean allowSingleQuotes() {
            return false;
        }

        protected boolean allowIdentifierPropertyNames() {
            return false;
        }

        protected boolean allowTrailingCommas() {
            return false;
        }

        protected boolean isValidPropertyName(@NotNull PsiElement literal) {
            return literal instanceof JsonLiteral && JsonPsiUtil.getElementTextWithoutHostEscaping(literal).startsWith("\"");
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (!this.allowComments() && JsonStandardComplianceInspection.this.myWarnAboutComments && JsonStandardComplianceProvider.shouldWarnAboutComment(comment) && comment.getContainingFile().getLanguage() instanceof JsonLanguage) {
                this.myHolder.registerProblem((PsiElement)comment, JsonBundle.message("inspection.compliance.msg.comments", new Object[0]), new LocalQuickFix[0]);
            }
        }

        @Override
        public void visitStringLiteral(@NotNull JsonStringLiteral stringLiteral) {
            if (!this.allowSingleQuotes() && JsonPsiUtil.getElementTextWithoutHostEscaping(stringLiteral).startsWith("'")) {
                this.myHolder.registerProblem((PsiElement)stringLiteral, JsonBundle.message("inspection.compliance.msg.single.quoted.strings", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
            }
            super.visitStringLiteral(stringLiteral);
        }

        @Override
        public void visitLiteral(@NotNull JsonLiteral literal) {
            String text;
            if (JsonPsiUtil.isPropertyKey(literal) && !this.isValidPropertyName(literal)) {
                this.myHolder.registerProblem((PsiElement)literal, JsonBundle.message("inspection.compliance.msg.illegal.property.key", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
            }
            if (!this.allowNanInfinity() && literal instanceof JsonNumberLiteral && JsonStandardComplianceInspection.this.myWarnAboutNanInfinity && ("Infinity".equals(text = JsonPsiUtil.getElementTextWithoutHostEscaping(literal)) || "-Infinity".equals(text) || "NaN".equals(text))) {
                this.myHolder.registerProblem((PsiElement)literal, JsonBundle.message("syntax.error.illegal.floating.point.literal", new Object[0]), new LocalQuickFix[0]);
            }
            super.visitLiteral(literal);
        }

        protected boolean allowNanInfinity() {
            return false;
        }

        @Override
        public void visitReferenceExpression(@NotNull JsonReferenceExpression reference) {
            if (!(this.allowIdentifierPropertyNames() && JsonPsiUtil.isPropertyKey(reference) && this.isValidPropertyName(reference) || MISSING_VALUE.equals(reference.getText()) && InjectedLanguageManager.getInstance((Project)this.myHolder.getProject()).isInjectedFragment(this.myHolder.getFile()))) {
                this.myHolder.registerProblem((PsiElement)reference, JsonBundle.message("inspection.compliance.msg.bad.token", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
            }
            super.visitReferenceExpression(reference);
        }

        @Override
        public void visitArray(@NotNull JsonArray array) {
            PsiElement trailingComma;
            if (JsonStandardComplianceInspection.this.myWarnAboutTrailingCommas && !this.allowTrailingCommas() && (trailingComma = JsonStandardComplianceInspection.findTrailingComma(array, JsonElementTypes.R_BRACKET)) != null) {
                this.myHolder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
            }
            super.visitArray(array);
        }

        @Override
        public void visitObject(@NotNull JsonObject object) {
            PsiElement trailingComma;
            if (JsonStandardComplianceInspection.this.myWarnAboutTrailingCommas && !this.allowTrailingCommas() && (trailingComma = JsonStandardComplianceInspection.findTrailingComma(object, JsonElementTypes.R_CURLY)) != null) {
                this.myHolder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
            }
            super.visitObject(object);
        }

        @Override
        public void visitValue(@NotNull JsonValue value) {
            if (value.getContainingFile() instanceof JsonFile) {
                JsonFile jsonFile = (JsonFile)value.getContainingFile();
                if (JsonStandardComplianceInspection.this.myWarnAboutMultipleTopLevelValues && value.getParent() == jsonFile && value != jsonFile.getTopLevelValue()) {
                    this.myHolder.registerProblem((PsiElement)value, JsonBundle.message("inspection.compliance.msg.multiple.top.level.values", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static class AddDoubleQuotesFix
    implements LocalQuickFix {
        private AddDoubleQuotesFix() {
        }

        @NotNull
        public String getFamilyName() {
            return JsonBundle.message("quickfix.add.double.quotes.desc", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            String rawText = element.getText();
            if (element instanceof JsonLiteral || element instanceof JsonReferenceExpression) {
                String content = JsonPsiUtil.stripQuotes(rawText);
                if (element instanceof JsonStringLiteral && rawText.startsWith("'")) {
                    content = AddDoubleQuotesFix.escapeSingleQuotedStringContent(content);
                }
                Object replacement = new JsonElementGenerator(project).createValue("\"" + content + "\"");
                CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> element.replace(replacement));
            } else {
                LOG.error("Quick fix was applied to unexpected element", new String[]{rawText, element.getParent().getText()});
            }
        }

        @NotNull
        private static String escapeSingleQuotedStringContent(@NotNull String content) {
            StringBuilder result = new StringBuilder();
            boolean nextCharEscaped = false;
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (nextCharEscaped && c != '\'' || !nextCharEscaped && c == '\"') {
                    result.append('\\');
                }
                if (c != '\\' || nextCharEscaped) {
                    result.append(c);
                    nextCharEscaped = false;
                    continue;
                }
                nextCharEscaped = true;
            }
            if (nextCharEscaped) {
                result.append('\\');
            }
            return result.toString();
        }
    }
}

