/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonDialectUtil {
    public static boolean isStandardJson(@NotNull PsiElement element) {
        return JsonDialectUtil.isStandardJson(JsonDialectUtil.getLanguageOrDefaultJson(element));
    }

    @NotNull
    public static Language getLanguageOrDefaultJson(@NotNull PsiElement element) {
        Language language;
        PsiFile file = element.getContainingFile();
        if (file != null && (language = file.getLanguage()) instanceof JsonLanguage) {
            return language;
        }
        return (Language)ObjectUtils.coalesce((Object)ObjectUtils.tryCast((Object)element.getLanguage(), JsonLanguage.class), (Object)((Object)JsonLanguage.INSTANCE));
    }

    public static boolean isStandardJson(@Nullable Language language) {
        return language == JsonLanguage.INSTANCE;
    }
}

