/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vcs;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.PairConsumer;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.vcs.BunchCheckinHandlerKt;
import org.jetbrains.kotlin.idea.vcs.BunchFileUtils;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/vcs/BunchFileCheckInHandlerFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "BunchCheckInHandler", "kotlin.jvm"})
public final class BunchFileCheckInHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        return new BunchCheckInHandler(panel);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/vcs/BunchFileCheckInHandlerFactory$BunchCheckInHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "checkInProjectPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;)V", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "beforeCheckin", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "additionalDataConsumer", "Lcom/intellij/util/PairConsumer;", "", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "kotlin.jvm"})
    public static final class BunchCheckInHandler
    extends CheckinHandler {
        private final CheckinProjectPanel checkInProjectPanel;

        private final Project getProject() {
            return this.checkInProjectPanel.getProject();
        }

        @Nullable
        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            if (PluginManagerCore.isPluginInstalled((PluginId)BunchCheckinHandlerKt.access$getBUNCH_PLUGIN_ID$p())) {
                return null;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            if (BunchFileUtils.INSTANCE.bunchFile(project) == null) {
                return null;
            }
            NonFocusableCheckBox bunchFilesCheckBox = new NonFocusableCheckBox(BundleBase.replaceMnemonicAmpersand((String)KotlinJvmBundle.message("check.bunch.files", new Object[0])));
            return new RefreshableOnComponent(this, bunchFilesCheckBox){
                final /* synthetic */ BunchCheckInHandler this$0;
                final /* synthetic */ NonFocusableCheckBox $bunchFilesCheckBox;

                @NotNull
                public JComponent getComponent() {
                    JPanel panel = new JPanel(new GridLayout(1, 0));
                    panel.add((Component)this.$bunchFilesCheckBox);
                    return panel;
                }

                public void refresh() {
                }

                public void saveState() {
                    Project project = BunchCheckInHandler.access$getProject$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    BunchCheckinHandlerKt.access$setBunchFileCheckEnabled$p(project, this.$bunchFilesCheckBox.isSelected());
                }

                public void restoreState() {
                    Project project = BunchCheckInHandler.access$getProject$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    this.$bunchFilesCheckBox.setSelected(BunchCheckinHandlerKt.access$getBunchFileCheckEnabled$p(project));
                }
                {
                    this.this$0 = this$0;
                    this.$bunchFilesCheckBox = $captured_local_variable$1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, @Nullable PairConsumer<Object, Object> additionalDataConsumer) {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            if (!BunchCheckinHandlerKt.access$getBunchFileCheckEnabled$p(project)) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            Collection<String> collection = BunchFileUtils.INSTANCE.bunchExtension(project2);
            if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            Collection<String> extensions = collection;
            HashSet<File> forgottenFiles = new HashSet<File>();
            Collection collection2 = this.checkInProjectPanel.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"checkInProjectPanel.files");
            Iterable $this$filter$iv = collection2;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                if (!file.isFile()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set commitFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterator $i$f$filter22 = commitFiles.iterator();
            while ($i$f$filter22.hasNext()) {
                File file;
                File file2 = file = (File)$i$f$filter22.next();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                if (extensions.contains(FilesKt.getExtension((File)file2))) continue;
                if (file.getParent() == null) {
                    continue;
                }
                String name = file.getName();
                for (String extension : extensions) {
                    String parent;
                    File bunchFile = new File(parent, name + '.' + extension);
                    if (commitFiles.contains(bunchFile) || !bunchFile.exists()) continue;
                    forgottenFiles.add(bunchFile);
                }
            }
            if (forgottenFiles.isEmpty()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            File projectBaseFile = new File(project3.getBasePath());
            Iterable $this$map$iv = forgottenFiles;
            boolean $i$f$map = false;
            Iterable extension = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl = false;
                String string = FilesKt.relativeTo((File)it, (File)projectBaseFile).getPath();
                collection3.add(string);
            }
            List filePaths = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
            if (filePaths.size() > 15) {
                filePaths = CollectionsKt.plus((Collection)CollectionsKt.take((Iterable)filePaths, (int)15), (Object)"...");
            }
            switch (Messages.showYesNoCancelDialog((Project)this.getProject(), (String)KotlinJvmBundle.message("several.bunch.files.haven.t.been.updated.0.do.you.want.to.review.them.before.commit", CollectionsKt.joinToString$default((Iterable)filePaths, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (String)KotlinJvmBundle.message("button.text.forgotten.bunch.files", new Object[0]), (String)KotlinJvmBundle.message("button.text.review", new Object[0]), (String)KotlinJvmBundle.message("button.text.commit", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) {
                case 0: {
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                case 1: {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
            }
            return CheckinHandler.ReturnResult.CANCEL;
        }

        public BunchCheckInHandler(@NotNull CheckinProjectPanel checkInProjectPanel) {
            Intrinsics.checkNotNullParameter((Object)checkInProjectPanel, (String)"checkInProjectPanel");
            this.checkInProjectPanel = checkInProjectPanel;
        }

        public static final /* synthetic */ Project access$getProject$p(BunchCheckInHandler $this) {
            return $this.getProject();
        }
    }
}

