/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run.script.standalone;

import com.intellij.DynamicBundle;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.run.script.standalone.KotlinStandaloneScriptRunConfiguration;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

public class KotlinStandaloneScriptRunConfigurationEditor
extends SettingsEditor<KotlinStandaloneScriptRunConfiguration>
implements PanelWithAnchor {
    private JPanel mainPanel;
    private CommonJavaParametersPanel commonProgramParameters;
    private JrePathEditor jrePathEditor;
    private TextFieldWithBrowseButton chooseScriptFileTextField;
    private LabeledComponent<TextFieldWithBrowseButton> chooseScriptFileComponent;
    private JComponent anchor;

    public KotlinStandaloneScriptRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.initChooseFileField(project);
        this.jrePathEditor.setDefaultJreSelector(DefaultJreSelector.projectSdk((Project)project));
        this.anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.chooseScriptFileComponent, this.commonProgramParameters, this.jrePathEditor});
    }

    void initChooseFileField(Project project) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter((Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file.isDirectory() || KotlinParserDefinition.STD_SCRIPT_SUFFIX.equals(file.getExtension());
            }
        }).withTreeRootVisible(true);
        this.chooseScriptFileTextField.addBrowseFolderListener(KotlinJvmBundle.message("script.choose.file", new Object[0]), null, project, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    protected void resetEditorFrom(KotlinStandaloneScriptRunConfiguration configuration) {
        this.commonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        String path = configuration.filePath;
        this.chooseScriptFileTextField.setText(path != null ? path : "");
        this.jrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
    }

    protected void applyEditorTo(KotlinStandaloneScriptRunConfiguration configuration) throws ConfigurationException {
        this.commonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setAlternativeJrePath(this.jrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.jrePathEditor.isAlternativeJreSelected());
        configuration.filePath = this.chooseScriptFileTextField.getText();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            KotlinStandaloneScriptRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.commonProgramParameters.setAnchor(anchor);
        this.jrePathEditor.setAnchor(anchor);
        this.chooseScriptFileComponent.setAnchor(anchor);
    }

    private void createUIComponents() {
        this.chooseScriptFileComponent = new LabeledComponent();
        this.chooseScriptFileTextField = new TextFieldWithBrowseButton();
        this.chooseScriptFileComponent.setComponent((JComponent)this.chooseScriptFileTextField);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.commonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.jrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent = this.chooseScriptFileComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", KotlinStandaloneScriptRunConfigurationEditor.class).getString("configuration.title.script.file"));
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/script/standalone/KotlinStandaloneScriptRunConfigurationEditor", "createEditor"));
    }
}

