/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal.makeBackup;

import com.intellij.compiler.server.BuildManager;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.patches.PatchCreator;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.internal.makeBackup.CreateIncrementalCompilationBackup;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "copyLogs", "backupDir", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "copyProjectSystemDir", "project", "Lcom/intellij/openapi/project/Project;", "createPatches", "zipProjectDir", "projectDir", "Companion", "kotlin.jvm"})
public final class CreateIncrementalCompilationBackup
extends AnAction {
    @NotNull
    public static final String BACKUP_DIR_NAME = ".backup";
    public static final int PATCHES_TO_CREATE = 5;
    public static final double PATCHES_FRACTION = 0.25;
    public static final double LOGS_FRACTION = 0.05;
    public static final double PROJECT_SYSTEM_FRACTION = 0.05;
    public static final double ZIP_FRACTION = 0.6499999999999999;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
        Project project2 = project;
        VirtualFile virtualFile = project2.getBaseDir();
        Intrinsics.checkNotNull((Object)virtualFile);
        File projectBaseDir = new File(virtualFile.getPath());
        File backupDir = new File(FileUtil.createTempDirectory((String)"makeBackup", null), BACKUP_DIR_NAME);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, backupDir, project2, projectBaseDir, project2, KotlinJvmBundle.message("creating.backup.for.debugging.kotlin.incremental.compilation", new Object[0]), true){
            final /* synthetic */ CreateIncrementalCompilationBackup this$0;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ File $projectBaseDir;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CreateIncrementalCompilationBackup.access$createPatches(this.this$0, this.$backupDir, this.$project, indicator);
                CreateIncrementalCompilationBackup.access$copyLogs(this.this$0, this.$backupDir, indicator);
                CreateIncrementalCompilationBackup.access$copyProjectSystemDir(this.this$0, this.$backupDir, this.$project, indicator);
                CreateIncrementalCompilationBackup.access$zipProjectDir(this.this$0, this.$backupDir, this.$project, this.$projectBaseDir, indicator);
            }
            {
                this.this$0 = this$0;
                this.$backupDir = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$projectBaseDir = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    private final void createPatches(File backupDir, Project project, ProgressIndicator indicator) {
        ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Unit>(project, backupDir, indicator){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ ProgressIndicator $indicator;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.getInstanceImpl();
                Intrinsics.checkNotNull((Object)localHistoryImpl);
                Intrinsics.checkNotNullExpressionValue((Object)localHistoryImpl, (String)"LocalHistoryImpl.getInstanceImpl()!!");
                LocalHistoryImpl localHistoryImpl2 = localHistoryImpl;
                IdeaGateway ideaGateway = localHistoryImpl2.getGateway();
                Intrinsics.checkNotNull((Object)ideaGateway);
                Intrinsics.checkNotNullExpressionValue((Object)ideaGateway, (String)"localHistoryImpl.gateway!!");
                IdeaGateway gateway = ideaGateway;
                LocalHistoryFacade localHistoryFacade = localHistoryImpl2.getFacade();
                RootEntry rootEntry = gateway.createTransientRootEntry();
                VirtualFile virtualFile = this.$project.getBaseDir();
                Intrinsics.checkNotNull((Object)virtualFile);
                RevisionsCollector revisionsCollector = new RevisionsCollector(localHistoryFacade, rootEntry, virtualFile.getPath(), this.$project.getLocationHash(), null);
                int patchesCreated = 0;
                File patchesDir = new File(this.$backupDir, "patches");
                patchesDir.mkdirs();
                List list = revisionsCollector.getResult();
                Intrinsics.checkNotNull((Object)list);
                List revisions = list;
                Iterator<E> iterator = revisions.iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv;
                    List differences;
                    Revision rev;
                    Revision revision = rev = (Revision)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"rev");
                    String label = revision.getLabel();
                    if (label == null || !StringsKt.startsWith$default((String)label, (String)"build started ", (boolean)false, (int)2, null)) continue;
                    File patchFile = new File(patchesDir, StringsKt.removePrefix((String)label, (CharSequence)"build started ") + ".patch");
                    this.$indicator.setText(KotlinJvmBundle.message("creating.patch.0", patchFile));
                    this.$indicator.setFraction(0.25 * (double)patchesCreated / (double)5);
                    Intrinsics.checkNotNull((Object)((Revision)revisions.get(0)).getDifferencesWith(rev));
                    Iterable $this$map$iv = differences;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void d;
                        Difference difference = (Difference)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Change change = new Change(d.getLeftContentRevision(gateway), d.getRightContentRevision(gateway));
                        collection.add(change);
                    }
                    List changes = (List)destination$iv$iv;
                    PatchCreator.create((Project)this.$project, (List)changes, (String)patchFile.getPath(), (boolean)false, null);
                    if (++patchesCreated < 5) continue;
                    break;
                }
            }
            {
                this.$project = project;
                this.$backupDir = file;
                this.$indicator = progressIndicator;
                super(0);
            }
        }));
    }

    private final void copyLogs(File backupDir, ProgressIndicator indicator) {
        indicator.setText(KotlinJvmBundle.message("copying.logs", new Object[0]));
        indicator.setFraction(0.25);
        File logsDir = new File(backupDir, "logs");
        FileUtil.copyDir((File)new File(PathManager.getLogPath()), (File)logsDir);
        indicator.setFraction(0.3);
    }

    private final void copyProjectSystemDir(File backupDir, Project project, ProgressIndicator indicator) {
        indicator.setText(KotlinJvmBundle.message("copying.project.s.system.dir", new Object[0]));
        indicator.setFraction(0.25);
        File projectSystemDir = new File(backupDir, "project-system");
        File file = BuildManager.getInstance().getProjectSystemDirectory(project);
        Intrinsics.checkNotNull((Object)file);
        FileUtil.copyDir((File)file, (File)projectSystemDir);
        indicator.setFraction(0.35);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void zipProjectDir(File backupDir, Project project, File projectDir, ProgressIndicator indicator) {
        void totalBytes;
        ArrayList files = new ArrayList();
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        Object[] objectArray = new File[2];
        objectArray[0] = projectDir;
        File file = backupDir.getParentFile();
        Intrinsics.checkNotNull((Object)file);
        objectArray[1] = file;
        for (File dir : CollectionsKt.listOf((Object[])objectArray)) {
            FileUtil.processFilesRecursively((File)dir, (Processor)((Processor)new Processor<File>(indicator, files, dir, (Ref.LongRef)totalBytes){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ ArrayList $files;
                final /* synthetic */ File $dir;
                final /* synthetic */ Ref.LongRef $totalBytes;

                public final boolean process(File it) {
                    block2: {
                        block3: {
                            File file = it;
                            Intrinsics.checkNotNull((Object)file);
                            if (!file.isFile()) break block2;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string, (String)".hprof", (boolean)false, (int)2, null)) break block2;
                            String string2 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                            if (!StringsKt.startsWith$default((String)string2, (String)"make_backup_", (boolean)false, (int)2, null)) break block3;
                            String string3 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string3, (String)".zip", (boolean)false, (int)2, null)) break block2;
                        }
                        this.$indicator.setText(KotlinJvmBundle.message("scanning.project.dir.0", it));
                        String string = FileUtil.getRelativePath((File)this.$dir, (File)it);
                        Intrinsics.checkNotNull((Object)string);
                        this.$files.add(new Pair((Object)it, (Object)string));
                        this.$totalBytes.element += it.length();
                    }
                    return true;
                }
                {
                    this.$indicator = progressIndicator;
                    this.$files = arrayList;
                    this.$dir = file;
                    this.$totalBytes = longRef;
                }
            }), (Processor)zipProjectDir.2.INSTANCE);
        }
        File backupFile = new File(projectDir, "make_backup_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));
        long processedBytes = 0L;
        Closeable closeable = zos;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            boolean bl3 = false;
            for (Pair pair : files) {
                void file2;
                File file3 = (File)pair.component1();
                String relativePath = (String)pair.component2();
                indicator.setText(KotlinJvmBundle.message("adding.file.to.backup.0", relativePath));
                indicator.setFraction(0.3 + (double)processedBytes / (double)totalBytes.element * 0.6499999999999999);
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)file2, (String)relativePath, null, null);
                processedBytes += file2.length();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FileUtil.delete((File)backupDir);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(project, backupFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupFile;

            public final void run() {
                Object[] objectArray = new Object[1];
                String string = this.$backupFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backupFile.absolutePath");
                objectArray[0] = string;
                RevealFileAction.showDialog((Project)this.$project, (String)KotlinJvmBundle.message("successfully.created.backup.0", objectArray), (String)KotlinJvmBundle.message("created.backup", new Object[0]), (File)this.$backupFile, null);
            }
            {
                this.$project = project;
                this.$backupFile = file;
            }
        }, null, (Project)project);
    }

    public CreateIncrementalCompilationBackup() {
        super(KotlinJvmBundle.message("create.backup.for.debugging.kotlin.incremental.compilation", new Object[0]));
    }

    public static final /* synthetic */ void access$createPatches(CreateIncrementalCompilationBackup $this, File backupDir, Project project, ProgressIndicator indicator) {
        $this.createPatches(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$copyLogs(CreateIncrementalCompilationBackup $this, File backupDir, ProgressIndicator indicator) {
        $this.copyLogs(backupDir, indicator);
    }

    public static final /* synthetic */ void access$copyProjectSystemDir(CreateIncrementalCompilationBackup $this, File backupDir, Project project, ProgressIndicator indicator) {
        $this.copyProjectSystemDir(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$zipProjectDir(CreateIncrementalCompilationBackup $this, File backupDir, Project project, File projectDir, ProgressIndicator indicator) {
        $this.zipProjectDir(backupDir, project, projectDir, indicator);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup$Companion;", "", "()V", "BACKUP_DIR_NAME", "", "LOGS_FRACTION", "", "PATCHES_FRACTION", "PATCHES_TO_CREATE", "", "PROJECT_SYSTEM_FRACTION", "ZIP_FRACTION", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

