/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.framework.LibraryEffectiveKindProviderKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/LibraryKindSearchScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "module", "Lcom/intellij/openapi/module/Module;", "baseScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;)V", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getModule", "()Lcom/intellij/openapi/module/Module;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm"})
public final class LibraryKindSearchScope
extends DelegatingGlobalSearchScope {
    @NotNull
    private final Module module;
    @NotNull
    private final PersistentLibraryKind<?> libraryKind;

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!super.contains(file)) {
            return false;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
        if (orderEntry instanceof LibraryOrderEntry) {
            Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
            }
            LibraryEx libraryEx = (LibraryEx)library2;
            Project project = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            return Intrinsics.areEqual((Object)LibraryEffectiveKindProviderKt.effectiveKind((LibraryEx)libraryEx, (Project)project), this.libraryKind);
        }
        return true;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final PersistentLibraryKind<?> getLibraryKind() {
        return this.libraryKind;
    }

    public LibraryKindSearchScope(@NotNull Module module, @NotNull GlobalSearchScope baseScope, @NotNull PersistentLibraryKind<?> libraryKind) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
        Intrinsics.checkNotNullParameter(libraryKind, (String)"libraryKind");
        super(baseScope);
        this.module = module;
        this.libraryKind = libraryKind;
    }
}

