/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class BaseFixture
implements IdeaTestFixture {
    private boolean myInitialized;
    private boolean myDisposed;
    private final Disposable myTestRootDisposable = Disposer.newDisposable();
    private List<Throwable> mySuppressedExceptions;

    @Override
    public void setUp() throws Exception {
        Assert.assertFalse((String)"setUp() already has been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.myInitialized = true;
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.myInitialized) {
            return;
        }
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        new RunAll(() -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS), () -> this.disposeRootDisposable()).run((List)ObjectUtils.notNull(this.mySuppressedExceptions, (Object)ContainerUtil.emptyList()));
        this.myDisposed = true;
        this.resetClassFields(this.getClass());
    }

    protected void disposeRootDisposable() {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (!Disposer.isDisposed((Disposable)this.myTestRootDisposable)) {
                Disposer.dispose((Disposable)this.myTestRootDisposable);
            }
        }));
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields(this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass != BaseFixture.class) {
            this.resetClassFields(aClass.getSuperclass());
        }
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    protected void addSuppressedException(@NotNull Throwable e) {
        SmartList list = this.mySuppressedExceptions;
        if (list == null) {
            this.mySuppressedExceptions = list = new SmartList();
        }
        list.add((Throwable)e);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
    }
}

